/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.TestMethodConfigurationProducer;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.junit.TestsPattern;
import com.intellij.execution.testframework.AbstractPatternBasedConfigurationProducer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import java.util.LinkedHashSet;
import java.util.Set;

public class PatternConfigurationProducer
extends AbstractPatternBasedConfigurationProducer<JUnitConfiguration> {
    protected PatternConfigurationProducer() {
        super((ConfigurationType)JUnitConfigurationType.getInstance());
    }

    protected boolean isTestClass(PsiClass psiClass) {
        return JUnitUtil.isTestClass((PsiClass)psiClass);
    }

    protected boolean isTestMethod(boolean checkAbstract, PsiElement psiElement) {
        return JUnitUtil.getTestMethod((PsiElement)psiElement, (boolean)checkAbstract) != null;
    }

    public boolean isPreferredConfiguration(ConfigurationFromContext self, ConfigurationFromContext other) {
        return !other.isProducedBy(TestMethodConfigurationProducer.class);
    }

    protected boolean setupConfigurationFromContext(JUnitConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        PsiElement element = this.checkPatterns(context, classes);
        if (element == null) {
            return false;
        }
        sourceElement.set((Object)element);
        JUnitConfiguration.Data data = configuration.getPersistentData();
        data.setPatterns(classes);
        data.TEST_OBJECT = "pattern";
        data.setScope(this.setupPackageConfiguration(context, (ModuleBasedConfiguration)configuration, data.getScope()));
        configuration.setGeneratedName();
        return true;
    }

    protected Module findModule(JUnitConfiguration configuration, Module contextModule) {
        Set<String> patterns = configuration.getPersistentData().getPatterns();
        return this.findModule((ModuleBasedConfiguration)configuration, contextModule, patterns);
    }

    public boolean isConfigurationFromContext(JUnitConfiguration unitConfiguration, ConfigurationContext context) {
        Set<String> patterns;
        TestObject testobject = unitConfiguration.getTestObject();
        return testobject instanceof TestsPattern && this.isConfiguredFromContext(context, patterns = unitConfiguration.getPersistentData().getPatterns());
    }
}

