/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInsight;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.MissingDependencyFixUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.codeInsight.daemon.quickFix.MissingDependencyFixProvider;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.execution.junit.JUnit3Framework;
import com.intellij.execution.junit.JUnit4Framework;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.JavaTestFramework;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitUnresolvedReferenceQuickFixProvider
extends UnresolvedReferenceQuickFixProvider<PsiJavaCodeReferenceElement> {
    public void registerFixes(final @NotNull PsiJavaCodeReferenceElement reference, @NotNull QuickFixActionRegistrar registrar) {
        String className;
        JavaTestFramework framework;
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/execution/junit/codeInsight/JUnitUnresolvedReferenceQuickFixProvider", "registerFixes"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/execution/junit/codeInsight/JUnitUnresolvedReferenceQuickFixProvider", "registerFixes"));
        }
        PsiElement psiElement = reference.getElement();
        String referenceName = reference.getRangeInElement().substring(psiElement.getText());
        Project project = psiElement.getProject();
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null) {
            return;
        }
        VirtualFile classVFile = containingFile.getVirtualFile();
        if (classVFile == null) {
            return;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        final Module currentModule = fileIndex.getModuleForFile(classVFile);
        if (currentModule == null) {
            return;
        }
        if ("TestCase".equals(referenceName)) {
            framework = (JavaTestFramework)TestFramework.EXTENSION_NAME.findExtension(JUnit3Framework.class);
            className = "junit.framework.TestCase";
        } else if (PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiAnnotation.class) != null && JUnitUnresolvedReferenceQuickFixProvider.isJunitAnnotationName(referenceName, psiElement)) {
            framework = (JavaTestFramework)TestFramework.EXTENSION_NAME.findExtension(JUnit4Framework.class);
            className = "org.junit." + referenceName;
        } else {
            return;
        }
        PsiClass found = JavaPsiFacade.getInstance((Project)project).findClass(className, currentModule.getModuleWithDependenciesAndLibrariesScope(true));
        if (found != null) {
            return;
        }
        final OrderEntryFix platformFix = new OrderEntryFix(){

            @NotNull
            public String getText() {
                String string = QuickFixBundle.message((String)"orderEntry.fix.add.junit.jar.to.classpath", (Object[])new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/codeInsight/JUnitUnresolvedReferenceQuickFixProvider$1", "getText"));
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = this.getText();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/codeInsight/JUnitUnresolvedReferenceQuickFixProvider$1", "getFamilyName"));
                }
                return string;
            }

            public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/junit/codeInsight/JUnitUnresolvedReferenceQuickFixProvider$1", "isAvailable"));
                }
                return !project.isDisposed() && !currentModule.isDisposed();
            }

            public void invoke(@NotNull Project project, @Nullable Editor editor, PsiFile file) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/junit/codeInsight/JUnitUnresolvedReferenceQuickFixProvider$1", "invoke"));
                }
                List jarPaths = framework.getLibraryPaths();
                String libraryName = jarPaths.size() == 1 ? null : framework.getName();
                1.addJarsToRootsAndImportClass((List)jarPaths, (String)libraryName, (Module)currentModule, (Editor)editor, (PsiReference)reference, (String)className);
            }
        };
        OrderEntryFix providedFix = (OrderEntryFix)MissingDependencyFixUtil.provideFix((Function)new Function<MissingDependencyFixProvider, OrderEntryFix>(){

            public OrderEntryFix fun(MissingDependencyFixProvider provider) {
                return provider.getJUnitFix((PsiReference)reference, platformFix, currentModule, framework, className);
            }
        });
        OrderEntryFix fix = (OrderEntryFix)ObjectUtils.notNull((Object)providedFix, (Object)platformFix);
        registrar.register((IntentionAction)fix);
    }

    private static boolean isJunitAnnotationName(@NonNls String referenceName, @NotNull PsiElement psiElement) {
        PsiReference reference;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/execution/junit/codeInsight/JUnitUnresolvedReferenceQuickFixProvider", "isJunitAnnotationName"));
        }
        if ("Test".equals(referenceName) || "Ignore".equals(referenceName) || "RunWith".equals(referenceName) || "Before".equals(referenceName) || "BeforeClass".equals(referenceName) || "After".equals(referenceName) || "AfterClass".equals(referenceName)) {
            return true;
        }
        PsiElement parent = psiElement.getParent();
        if (parent != null && !(parent instanceof PsiAnnotation) && (reference = parent.getReference()) != null) {
            String referenceText = parent.getText();
            if (JUnitUnresolvedReferenceQuickFixProvider.isJunitAnnotationName(reference.getRangeInElement().substring(referenceText), parent)) {
                int lastDot = referenceText.lastIndexOf(46);
                return lastDot > -1 && referenceText.substring(0, lastDot).equals("org.junit");
            }
        }
        return false;
    }

    @NotNull
    public Class<PsiJavaCodeReferenceElement> getReferenceClass() {
        if (PsiJavaCodeReferenceElement.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/codeInsight/JUnitUnresolvedReferenceQuickFixProvider", "getReferenceClass"));
        }
        return PsiJavaCodeReferenceElement.class;
    }
}

