/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava;

import com.intellij.lang.Language;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KotlinLightElement;
import org.jetbrains.kotlin.asJava.KotlinLightMethod;
import org.jetbrains.kotlin.asJava.KotlinLightModifierList;
import org.jetbrains.kotlin.asJava.LightParameter;
import org.jetbrains.kotlin.idea.JetLanguage;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;

public class KotlinLightParameter
extends LightParameter
implements KotlinLightElement<JetParameter, PsiParameter> {
    private final PsiModifierList modifierList;
    private final PsiParameter delegate;
    private final int index;
    private final KotlinLightMethod method;

    private static String getName(PsiParameter delegate2, int index2) {
        String name2 = delegate2.getName();
        return name2 != null ? name2 : "p" + index2;
    }

    public KotlinLightParameter(final PsiParameter delegate2, int index2, KotlinLightMethod method) {
        super(KotlinLightParameter.getName(delegate2, index2), delegate2.getType(), (PsiElement)method, (Language)JetLanguage.INSTANCE);
        this.delegate = delegate2;
        this.index = index2;
        this.method = method;
        this.modifierList = new KotlinLightModifierList(method.getManager(), ArrayUtil.EMPTY_STRING_ARRAY){

            @Override
            public PsiAnnotationOwner getDelegate() {
                return delegate2.getModifierList();
            }
        };
    }

    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList psiModifierList = this.modifierList;
        if (psiModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightParameter", "getModifierList"));
        }
        return psiModifierList;
    }

    @Override
    @NotNull
    public PsiParameter getDelegate() {
        PsiParameter psiParameter = this.delegate;
        if (psiParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightParameter", "getDelegate"));
        }
        return psiParameter;
    }

    @Override
    @Nullable
    public JetParameter getOrigin() {
        int jetIndex;
        JetDeclaration declaration = this.method.getOrigin();
        if (declaration == null) {
            return null;
        }
        int n = jetIndex = PsiUtilPackage.isExtensionDeclaration(declaration) ? this.index - 1 : this.index;
        if (jetIndex < 0) {
            return null;
        }
        if (declaration instanceof JetNamedFunction) {
            List<JetParameter> paramList = ((JetNamedFunction)declaration).getValueParameters();
            return jetIndex < paramList.size() ? paramList.get(jetIndex) : null;
        }
        if (declaration instanceof JetClass) {
            List<JetParameter> paramList = ((JetClass)declaration).getPrimaryConstructorParameters();
            return jetIndex < paramList.size() ? paramList.get(jetIndex) : null;
        }
        if (jetIndex != 0) {
            return null;
        }
        JetPropertyAccessor setter = null;
        if (declaration instanceof JetPropertyAccessor) {
            JetPropertyAccessor accessor = (JetPropertyAccessor)declaration;
            setter = accessor.isSetter() ? accessor : null;
        } else if (declaration instanceof JetProperty) {
            setter = ((JetProperty)declaration).getSetter();
        }
        return setter != null ? setter.getParameter() : null;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        JetParameter origin = this.getOrigin();
        JetParameter jetParameter = origin != null ? origin : super.getNavigationElement();
        if (jetParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightParameter", "getNavigationElement"));
        }
        return jetParameter;
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/asJava/KotlinLightParameter", "setName"));
        }
        JetParameter origin = this.getOrigin();
        if (origin != null) {
            origin.setName(name2);
        }
        return this;
    }

    public PsiFile getContainingFile() {
        JetDeclaration declaration = this.method.getOrigin();
        return declaration != null ? declaration.getContainingFile() : super.getContainingFile();
    }

    @NotNull
    public Language getLanguage() {
        JetLanguage jetLanguage = JetLanguage.INSTANCE;
        if (jetLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightParameter", "getLanguage"));
        }
        return jetLanguage;
    }

    @NotNull
    public SearchScope getUseScope() {
        JetParameter origin = this.getOrigin();
        Object object = origin != null ? origin.getUseScope() : GlobalSearchScope.EMPTY_SCOPE;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightParameter", "getUseScope"));
        }
        return object;
    }
}

