/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.codegen.ClassFileFactory;

public class GeneratedClassLoader
extends URLClassLoader {
    private ClassFileFactory factory;

    public GeneratedClassLoader(@NotNull ClassFileFactory factory2, ClassLoader parentClassLoader, URL ... urls) {
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/codegen/GeneratedClassLoader", "<init>"));
        }
        super(urls, parentClassLoader);
        this.factory = factory2;
    }

    @Override
    @NotNull
    protected Class<?> findClass(@NotNull String name2) throws ClassNotFoundException {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/GeneratedClassLoader", "findClass"));
        }
        String classFilePath = name2.replace('.', '/') + ".class";
        OutputFile outputFile = this.factory.get(classFilePath);
        if (outputFile != null) {
            String pkgName;
            byte[] bytes2 = outputFile.asByteArray();
            int lastDot = name2.lastIndexOf(46);
            if (lastDot >= 0 && this.getPackage(pkgName = name2.substring(0, lastDot)) == null) {
                this.definePackage(pkgName, new Manifest(), null);
            }
            Class<?> clazz = this.defineClass(name2, bytes2, 0, bytes2.length);
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/GeneratedClassLoader", "findClass"));
            }
            return clazz;
        }
        Class<?> clazz = super.findClass(name2);
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/GeneratedClassLoader", "findClass"));
        }
        return clazz;
    }

    public void dispose() {
        this.factory = null;
    }

    @NotNull
    public List<OutputFile> getAllGeneratedFiles() {
        List<OutputFile> list = this.factory.asList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/GeneratedClassLoader", "getAllGeneratedFiles"));
        }
        return list;
    }
}

