/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.Sequence;
import kotlin.Unit;
import kotlin.io.IoPackage;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FunctionReference;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KLocalFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.actions.JavaToKotlinAction;
import org.jetbrains.kotlin.idea.j2k.IdeaResolverForConverter;
import org.jetbrains.kotlin.idea.j2k.J2kPostProcessor;
import org.jetbrains.kotlin.idea.util.application.ApplicationPackage;
import org.jetbrains.kotlin.j2k.ConverterSettings;
import org.jetbrains.kotlin.j2k.IdeaReferenceSearcher;
import org.jetbrains.kotlin.j2k.JavaToKotlinConverter;
import org.jetbrains.kotlin.j2k.PostProcessor;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\u0018\b)\u0011\"*\u0019<b)>\\u\u000e\u001e7j]\u0006\u001bG/[8o\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'\u0002B5eK\u0006Tq!Y2uS>t7O\u0003\u0005B]\u0006\u001bG/[8o\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*9q\u000e]3oCBL'\u0002D1di&|gnU=ti\u0016l'B\u0002\u001fj]&$hHC\bbGRLwN\u001c)fe\u001a|'/\\3e\u0015\u0005)'\"D!o\u0003\u000e$\u0018n\u001c8Fm\u0016tGO\u0003\u0003V]&$(\u0002C1mY\u001aKG.Z:\u000b\u0017\u0019LG.Z:Pe\u0012K'o\u001d\u0006\u0006\u0003J\u0014\u0018-\u001f\u0006\f-&\u0014H/^1m\r&dWMC\u0002wMNT!bQ8mY\u0016\u001cG/[8o\u0015\u0011Q\u0017M^1\u000b\tU$\u0018\u000e\u001c\u0006\rC2d'*\u0019<b\r&dWm\u001d\u0006\baJ|'.Z2u\u0015\u001d\u0001&o\u001c6fGRT\u0001bU3rk\u0016t7-\u001a\u0006\f!NL'*\u0019<b\r&dWMC\u0002qg&T1b]1wKJ+7/\u001e7ug*I!.\u0019<b\r&dWm\u001d\u0006\u0005\u0019&\u001cHO\u0003\bd_:4XM\u001d;fIR+\u0007\u0010^:\u000b\rM#(/\u001b8h\u0015E\u0019X\r\\3di\u0016$'*\u0019<b\r&dWm\u001d\u0006\u0015k:L\u0017/^3L_Rd\u0017N\u001c$jY\u0016t\u0015-\\3\u000b\u0011)\fg/\u0019$jY\u0016TA\u0001\\1oO*1Q\u000f\u001d3bi\u0016\u0014\u001fA\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0005\u0011\r\u0001RA\u0003\u0004\t\tA\u0001\u0001\u0004\u0001\u0006\u0003!\u001dQA\u0001\u0003\u0004\u0011\u0011)!\u0001b\u0002\t\n\u0015\u0011A\u0001\u0002\u0005\u0006\u000b\r!I\u0001C\u0002\r\u0001\u0015\u0019A\u0011\u0002\u0005\b\u0019\u0001)\u0011\u0001c\u0001\u0006\u0007\u00111\u0001r\u0002\u0007\u0001\u000b\t!I\u0001C\u0004\u0006\u0007\u00111\u0001\"\u0003\u0007\u0001\u000b\t!A\u0001\u0003\u0006\u0006\u0007\u0011A\u00012\u0003\u0007\u0001\u000b\r!a\u0001#\u0006\r\u0001\u0015\t\u0001bC\u0003\u0003\t'A9\"\u0002\u0002\u0005\u0015!UQA\u0001\u0003\t\u0011')!\u0001\u0002\u0003\t\u001a\u0015\u0019Aq\u0003\u0005\u000e\u0019\u0001)1\u0001\u0002\u0004\t\u001c1\u0001QA\u0001C\u0004\u0011;)1\u0001B\u0007\t\u001d1\u0001QA\u0001\u0003\u0007\u00117)!\u0001b\u0006\t\u001b\u0015\u0019AA\u0002\u0005\u0011\u0019\u0001)1\u0001\u0002\u0004\t#1\u0001QA\u0001\u0003\u000b\u0011A)!\u0001b\u0005\t'\u0015\u0011A\u0011\u0005\u0005\u0012\t\ra)!\u0007\u0002\u0006\u0003!)Qf\u0005\u0003\f1\u0019ij\u0001\u0002\u0001\t\u000e5\u0011Q!\u0001E\u0006!\u000e\u0001\u0011EA\u0003\u0002\u0011\u001b\t6!\u0002\u0003\u0007\u0013\u0005!\u0001!D\u0001\t\u000f5bB!\u0001\r\t;+!\u0001\u0001#\u0005\u000e\r\u0015\t\u0001rB\u0005\u0004\u0013\t)\u0011\u0001#\u0005Q\u0007\u0001\tc!B\u0001\t\u0013%\u0019\u0011BA\u0003\u0002\u0011#\t6A\u0002\u0003\t\u0013\u0005A)\"\u0004\u0002\t\u00171\u0005Q6\n\u0003\u000211i*\u0002\u0002\u0001\t\u001251Q!\u0001E\b\u0013\rI!!B\u0001\t\u0012A\u001b\u0001!(\u0004\u0005\u0001!eQBA\u0003\u0002\u00111\u00016\u0011A\u0011\u0007\u000b\u0005AI\"C\u0002\n\u0005\u0015\t\u00012D)\u0004\u0011\u0011a\u0011\"\u0001\u0005\u000f\u001b\tA1\u0002$\u0001\u000e\u0003!uQ\u0016\u000b\u0003\u00021=i*\u0002\u0002\u0001\t 51Q!\u0001\u0005\u0010\u0013\rI!!B\u0001\t\u001cA\u001b\u0001!(\u0006\u0005\u0001!\u0005RBB\u0003\u0002\u0011=I1!\u0003\u0002\u0006\u0003!}\u0001k!\u0001\"\r\u0015\t\u0001bD\u0005\u0004\u0013\t)\u0011\u0001#\u0005R\u0007\u001d!q\"C\u0001\t!5\t\u0001\u0002E\u0007\u0002\u0011Ais\u0003B\u0001\u0019$u5A\u0001\u0001E\u0007\u001b\t)\u0011\u0001c\u0003Q\u0007\u0001\tc!B\u0001\t\u001a%\u0019\u0011BA\u0003\u0002\u00117\t6!\u0002C\u0012\u0013\u0005Aa\"D\u0001\t\u000f5\u001aB!\u0001\r\u0013;\u001b!\u0001\u0001#\n\u000e\u0005\u0015\t\u0001\u0012\u0003)\u0004\u0001\u0005\u0012Q!\u0001E\u0010#\u000e)AAE\u0005\u0002\u0011Ei\u0011\u0001C\u0006.'\u0011Y\u0001tEO\u0007\t\u0001Ai!\u0004\u0002\u0006\u0003!-\u0001k\u0001\u0001\"\u0005\u0015\t\u0001RB)\u0004\u000b\u0011\u001d\u0012\"\u0001\u0003\u0001\u001b\u0005Aq!N\u0006\u0006\u0015\u0011\u0019\u000f\u0001g\u0003\"\u0005\u0015\t\u0001RA)\u0004\u0007\u0011-\u0011\"\u0001\u0003\u0001"})
public final class JavaToKotlinAction
extends AnAction {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(JavaToKotlinAction.class);
    }

    public void actionPerformed(@JetValueParameter(name="e") @NotNull AnActionEvent e) {
        Object externalCodeUpdate;
        String question;
        Object converterResult;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        List javaFiles = KotlinPackage.toList(this.selectedJavaFiles(e));
        Object object = CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Project project = (Project)object;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Function0<Unit> convert$ = new Function0<Unit>(project, (Ref.ObjectRef)converterResult, javaFiles){
            final /* synthetic */ Project $project;
            final /* synthetic */ Ref.ObjectRef $converterResult;
            final /* synthetic */ List $javaFiles;

            public final void invoke() {
                JavaToKotlinConverter converter = new JavaToKotlinConverter(this.$project, ConverterSettings.Companion.getDefaultSettings(), IdeaReferenceSearcher.INSTANCE$, IdeaResolverForConverter.INSTANCE$);
                PostProcessor postProcessor = new J2kPostProcessor(true);
                ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                Intrinsics.checkExpressionValueIsNotNull((Object)progressIndicator, (String)"ProgressManager.getInsta\u2026().getProgressIndicator()");
                this.$converterResult.element = converter.filesToKotlin(this.$javaFiles, postProcessor, progressIndicator);
            }
            {
                this.$project = project;
                this.$converterResult = objectRef;
                this.$javaFiles = list;
                super(0);
            }
        };
        String title = "Convert Java to Kotlin";
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(convert$){
            final /* synthetic */ actionPerformed.1 $convert;

            public final void run() {
                ApplicationPackage.runReadAction((Function0)((KLocalFunction)Reflection.function((FunctionReference)new Function0<Unit>(this){
                    final /* synthetic */ actionPerformed.2 this$0;

                    public final void invoke() {
                        this.this$0.$convert.invoke();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                })));
            }
            {
                this.$convert = var1_1;
            }
        }, title, true, project)) {
            return;
        }
        Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
        objectRef2.element = null;
        JavaToKotlinConverter.FilesResult filesResult = (JavaToKotlinConverter.FilesResult)converterResult.element;
        if (filesResult == null) {
            Intrinsics.throwNpe();
        }
        if (filesResult.getExternalCodeProcessing() != null && Messages.showOkCancelDialog((Project)project, (String)(question = "Some code in the rest of your project may require corrections after performing this conversion. Do you want to find such code and correct it too?"), (String)title, (Icon)Messages.getQuestionIcon()) == 0) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(externalCodeUpdate, converterResult){
                final /* synthetic */ Ref.ObjectRef $externalCodeUpdate;
                final /* synthetic */ Ref.ObjectRef $converterResult;

                public final void run() {
                    ApplicationPackage.runReadAction((Function0)new Function0<Unit>(this){
                        final /* synthetic */ actionPerformed.3 this$0;

                        public final void invoke() {
                            Ref.ObjectRef objectRef = this.this$0.$externalCodeUpdate;
                            JavaToKotlinConverter.FilesResult filesResult = (JavaToKotlinConverter.FilesResult)this.this$0.$converterResult.element;
                            if (filesResult == null) {
                                Intrinsics.throwNpe();
                            }
                            JavaToKotlinConverter.ExternalCodeProcessing externalCodeProcessing2 = filesResult.getExternalCodeProcessing();
                            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                            Intrinsics.checkExpressionValueIsNotNull((Object)progressIndicator, (String)"ProgressManager.getInsta\u2026().getProgressIndicator()");
                            objectRef.element = externalCodeProcessing2.prepareWriteOperation(progressIndicator);
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    });
                }
                {
                    this.$externalCodeUpdate = objectRef;
                    this.$converterResult = objectRef2;
                }
            }, title, true, project);
        }
        ApplicationPackage.executeWriteCommand(project, "Convert files from Java to Kotlin", (Function0<? extends Unit>)((Function0)new Function0<Unit>(this, project, javaFiles, (Ref.ObjectRef)converterResult, (Ref.ObjectRef)externalCodeUpdate){
            final /* synthetic */ JavaToKotlinAction this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ List $javaFiles;
            final /* synthetic */ Ref.ObjectRef $converterResult;
            final /* synthetic */ Ref.ObjectRef $externalCodeUpdate;

            public final void invoke() {
                FileEditor[] fileEditorArray;
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(this.$project);
                JavaToKotlinConverter.FilesResult filesResult = (JavaToKotlinConverter.FilesResult)this.$converterResult.element;
                if (filesResult == null) {
                    Intrinsics.throwNpe();
                }
                List<VirtualFile> newFiles = JavaToKotlinAction.access$saveResults$0(this.this$0, this.$javaFiles, filesResult.getResults());
                Function0 function0 = (Function0)this.$externalCodeUpdate.element;
                Object object = function0 != null ? (Unit)function0.invoke() : null;
                VirtualFile virtualFile = (VirtualFile)KotlinPackage.singleOrNull(newFiles);
                if (virtualFile != null) {
                    VirtualFile $receiver = virtualFile;
                    VirtualFile it = $receiver;
                    fileEditorArray = FileEditorManager.getInstance((Project)this.$project).openFile(it, true);
                } else {
                    fileEditorArray = null;
                }
            }
            {
                this.this$0 = javaToKotlinAction;
                this.$project = project;
                this.$javaFiles = list;
                this.$converterResult = objectRef;
                this.$externalCodeUpdate = objectRef2;
                super(0);
            }
        }));
        externalCodeUpdate = null;
        converterResult = null;
    }

    public void update(@JetValueParameter(name="e") @NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        boolean enabled = KotlinPackage.any(this.selectedJavaFiles(e));
        e.getPresentation().setEnabled(enabled);
    }

    private final Sequence<PsiJavaFile> selectedJavaFiles(@JetValueParameter(name="e") AnActionEvent e) {
        VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFileArray == null) {
            return KotlinPackage.sequenceOf((Object[])new PsiJavaFile[0]);
        }
        VirtualFile[] virtualFiles = virtualFileArray;
        Project project = e.getProject();
        if (project == null) {
            return KotlinPackage.sequenceOf((Object[])new PsiJavaFile[0]);
        }
        Project project2 = project;
        return this.allJavaFiles(virtualFiles, project2);
    }

    private final Sequence<PsiJavaFile> allJavaFiles(@JetValueParameter(name="filesOrDirs") VirtualFile[] filesOrDirs, @JetValueParameter(name="project") Project project) {
        PsiManager manager = PsiManager.getInstance((Project)project);
        return KotlinPackage.filterNotNull((Sequence)KotlinPackage.map((Sequence)KotlinPackage.asSequence((Iterable)this.allFiles(filesOrDirs)), (Function1)((Function1)new Function1<VirtualFile, PsiJavaFile>(manager){
            final /* synthetic */ PsiManager $manager;

            @Nullable
            public final PsiJavaFile invoke(@JetValueParameter(name="it") @NotNull VirtualFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                PsiFile psiFile = this.$manager.findFile(it);
                if (!(psiFile instanceof PsiJavaFile)) {
                    psiFile = null;
                }
                return (PsiJavaFile)psiFile;
            }
            {
                this.$manager = psiManager;
                super(1);
            }
        })));
    }

    private final Collection<VirtualFile> allFiles(@JetValueParameter(name="filesOrDirs") VirtualFile[] filesOrDirs) {
        ArrayList result2 = new ArrayList();
        for (int i = 0; i < filesOrDirs.length; ++i) {
            VirtualFile file = filesOrDirs[i];
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Unit>(result2, new VirtualFileVisitor.Option[0]){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ ArrayList $result;

                static {
                    $kotlinClass = Reflection.createKotlinClass(allFiles.1.class);
                }

                public boolean visitFile(@JetValueParameter(name="file") @NotNull VirtualFile file) {
                    Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                    this.$result.add(file);
                    return true;
                }
                {
                    this.$result = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            }));
        }
        return result2;
    }

    private final List<VirtualFile> saveResults(@JetValueParameter(name="javaFiles") List<? extends PsiJavaFile> javaFiles, @JetValueParameter(name="convertedTexts") List<? extends String> convertedTexts) {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (Pair pair2 : KotlinPackage.zip((Iterable)javaFiles, (Iterable)convertedTexts)) {
            VirtualFile virtualFile;
            PsiJavaFile psiFile = (PsiJavaFile)pair2.component1();
            String text = (String)pair2.component2();
            VirtualFile virtualFile2 = virtualFile = psiFile.getVirtualFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"virtualFile");
            String fileName = this.uniqueKotlinFileName(virtualFile2);
            try {
                virtualFile.rename((Object)this, fileName);
                virtualFile.setBinaryContent(CharsetToolkit.getUtf8Bytes((String)text));
                result2.add(virtualFile);
            }
            catch (IOException e) {
                MessagesEx.error((Project)psiFile.getProject(), (String)e.getMessage()).showLater();
            }
        }
        return result2;
    }

    private final String uniqueKotlinFileName(@JetValueParameter(name="javaFile") VirtualFile javaFile) {
        File ioFile = new File(KotlinPackage.replace$default((String)javaFile.getPath(), (char)'/', (char)File.separatorChar, (boolean)false, (int)4));
        int i = 0;
        String fileName;
        while (IoPackage.resolveSibling((File)ioFile, (String)(fileName = javaFile.getNameWithoutExtension() + (i > 0 ? Integer.valueOf(i) : (Comparable)((Object)"")) + ".kt")).exists()) {
            ++i;
        }
        return fileName;
    }

    @NotNull
    public static final /* synthetic */ List<VirtualFile> access$saveResults$0(@JetValueParameter(name="$this", type="?") JavaToKotlinAction $this, @JetValueParameter(name="javaFiles") @NotNull List<? extends PsiJavaFile> javaFiles, @JetValueParameter(name="convertedTexts") @NotNull List<? extends String> convertedTexts) {
        return $this.saveResults(javaFiles, convertedTexts);
    }
}

