/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.idea.JetLanguage;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.JetType;

public class ShowExpressionTypeAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        JetType type2;
        JetExpression expression2;
        Editor editor = (Editor)e.getData(PlatformDataKeys.EDITOR);
        PsiFile psiFile = (PsiFile)e.getData(LangDataKeys.PSI_FILE);
        assert (editor != null && psiFile != null);
        BindingContext bindingContext2 = ResolvePackage.analyzeFully((JetFile)psiFile);
        if (editor.getSelectionModel().hasSelection()) {
            int startOffset = editor.getSelectionModel().getSelectionStart();
            int endOffset = editor.getSelectionModel().getSelectionEnd();
            expression2 = (JetExpression)CodeInsightUtilBase.findElementInRange((PsiFile)psiFile, (int)startOffset, (int)endOffset, JetExpression.class, (Language)JetLanguage.INSTANCE);
        } else {
            int offset = editor.getCaretModel().getOffset();
            expression2 = (JetExpression)PsiTreeUtil.getParentOfType((PsiElement)psiFile.findElementAt(offset), JetExpression.class);
            while (expression2 != null && bindingContext2.getType(expression2) == null) {
                expression2 = (JetExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, JetExpression.class);
            }
            if (expression2 != null) {
                editor.getSelectionModel().setSelection(expression2.getTextRange().getStartOffset(), expression2.getTextRange().getEndOffset());
            }
        }
        if (expression2 != null && (type2 = bindingContext2.getType(expression2)) != null) {
            HintManager.getInstance().showInformationHint(editor, "<html>" + DescriptorRenderer.HTML.renderType(type2) + "</html>");
        }
    }

    public void update(AnActionEvent e) {
        Editor editor = (Editor)e.getData(PlatformDataKeys.EDITOR);
        PsiFile psiFile = (PsiFile)e.getData(LangDataKeys.PSI_FILE);
        e.getPresentation().setEnabled(editor != null && psiFile instanceof JetFile);
    }
}

