/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.surroundWith.statement;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.KotlinSurrounderUtils;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.MoveDeclarationsOutHelper;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.statement.KotlinStatementsSurrounder;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.PsiPackage;

public class KotlinFunctionLiteralSurrounder
extends KotlinStatementsSurrounder {
    @Override
    @Nullable
    protected TextRange surroundStatements(Project project, Editor editor, PsiElement container2, PsiElement[] statements) {
        if ((statements = MoveDeclarationsOutHelper.move(container2, statements, true)).length == 0) {
            KotlinSurrounderUtils.showErrorHint(project, editor, KotlinSurrounderUtils.SURROUND_WITH_ERROR);
            return null;
        }
        JetPsiFactory psiFactory = PsiPackage.JetPsiFactory(project);
        JetCallExpression callExpression = (JetCallExpression)psiFactory.createExpression("run {\n}");
        callExpression = (JetCallExpression)container2.addAfter((PsiElement)callExpression, statements[statements.length - 1]);
        container2.addBefore(psiFactory.createWhiteSpace(), (PsiElement)callExpression);
        JetFunctionLiteralExpression bodyExpression = callExpression.getFunctionLiteralArguments().get(0).getFunctionLiteral();
        assert (bodyExpression != null) : "Body expression should exists for " + callExpression.getText();
        JetBlockExpression blockExpression = bodyExpression.getBodyExpression();
        assert (blockExpression != null) : "JetBlockExpression should exists for " + callExpression.getText();
        KotlinSurrounderUtils.addStatementsInBlock(blockExpression, statements);
        container2.deleteChildRange(statements[0], statements[statements.length - 1]);
        callExpression = (JetCallExpression)CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement((PsiElement)callExpression);
        JetExpression literalName = callExpression.getCalleeExpression();
        assert (literalName != null) : "Run expression should have callee expression " + callExpression.getText();
        return literalName.getTextRange();
    }

    public String getTemplateDescription() {
        return JetBundle.message("surround.with.function.template", new Object[0]);
    }
}

