/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.refactoring;

import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.changeSignature.ChangeSignatureUtil;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.ui.components.JBList;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.CharIterator;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.inline;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KotlinLightMethod;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.JetFileType;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.core.CorePackage;
import org.jetbrains.kotlin.idea.core.refactoring.RefactoringPackage$javaElementFactoryUtils$79cd28cc;
import org.jetbrains.kotlin.idea.core.refactoring.RefactoringPackage$jetRefactoringUtil$12783858;
import org.jetbrains.kotlin.idea.core.refactoring.RefactoringPackage$jetRefactoringUtil$12783858$WhenMappings;
import org.jetbrains.kotlin.idea.core.refactoring.RefactoringPackage$jetRefactoringUtil$12783858$getPsiElementPopup$;
import org.jetbrains.kotlin.idea.core.refactoring.RefactoringPackage$sam$Runnable$738b3719;
import org.jetbrains.kotlin.idea.core.refactoring.SelectionAwareScopeHighlighter;
import org.jetbrains.kotlin.idea.j2k.IdeaResolverForConverter;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.idea.util.string.StringPackage;
import org.jetbrains.kotlin.j2k.ConverterSettings;
import org.jetbrains.kotlin.j2k.IdeaReferenceSearcher;
import org.jetbrains.kotlin.j2k.JavaToKotlinConverter;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassBody;
import org.jetbrains.kotlin.psi.JetClassInitializer;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDeclarationWithBody;
import org.jetbrains.kotlin.psi.JetDelegationSpecifierList;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetMultiDeclaration;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetWithExpressionInitializer;
import org.jetbrains.kotlin.psi.codeFragmentUtil.CodeFragmentUtilPackage;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class RefactoringPackage$jetRefactoringUtil$12783858 {
    @Nullable
    public static final <T> T getAndRemoveCopyableUserData(@JetValueParameter(name="$receiver") PsiElement $receiver, @JetValueParameter(name="key") @NotNull Key<T> key) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        Object data2 = $receiver.getCopyableUserData(key);
        $receiver.putCopyableUserData(key, null);
        return (T)data2;
    }

    @Nullable
    public static final JetFile getOrCreateKotlinFile(@JetValueParameter(name="fileName") @NotNull String fileName, @JetValueParameter(name="targetDir") @NotNull PsiDirectory targetDir) {
        PsiFile psiFile;
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)targetDir, (String)"targetDir");
        PsiFile psiFile2 = targetDir.findFile(fileName);
        if (psiFile2 == null) {
            psiFile2 = psiFile = (PsiFile)RefactoringPackage$jetRefactoringUtil$12783858.createKotlinFile(fileName, targetDir);
        }
        if (!(psiFile2 instanceof JetFile)) {
            psiFile = null;
        }
        return (JetFile)psiFile;
    }

    @NotNull
    public static final JetFile createKotlinFile(@JetValueParameter(name="fileName") @NotNull String fileName, @JetValueParameter(name="targetDir") @NotNull PsiDirectory targetDir) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)targetDir, (String)"targetDir");
        PsiPackage psiPackage = CorePackage.getPackage(targetDir);
        String packageName = psiPackage != null ? psiPackage.getQualifiedName() : null;
        targetDir.checkCreateFile(fileName);
        PsiFile file = PsiFileFactory.getInstance((Project)targetDir.getProject()).createFileFromText(fileName, (FileType)JetFileType.INSTANCE, (CharSequence)(packageName != null && KotlinPackage.isNotEmpty((String)packageName) ? "package " + packageName + " " + "\n" + "\n" : ""));
        PsiElement psiElement = targetDir.add((PsiElement)file);
        if (psiElement == null) {
            throw new TypeCastException("com.intellij.psi.PsiElement! cannot be cast to org.jetbrains.kotlin.psi.JetFile");
        }
        return (JetFile)psiElement;
    }

    @Nullable
    public static final VirtualFile toVirtualFile(@JetValueParameter(name="$receiver") File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return LocalFileSystem.getInstance().findFileByIoFile($receiver);
    }

    @Nullable
    public static final PsiFile toPsiFile(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="project") @NotNull Project project) {
        PsiFile psiFile;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        VirtualFile virtualFile = RefactoringPackage$jetRefactoringUtil$12783858.toVirtualFile($receiver);
        if (virtualFile != null) {
            VirtualFile $receiver2 = virtualFile;
            VirtualFile vfile = $receiver2;
            psiFile = PsiManager.getInstance((Project)project).findFile(vfile);
        } else {
            psiFile = null;
        }
        return psiFile;
    }

    @Nullable
    public static final PsiDirectory toPsiDirectory(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="project") @NotNull Project project) {
        PsiDirectory psiDirectory;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        VirtualFile virtualFile = RefactoringPackage$jetRefactoringUtil$12783858.toVirtualFile($receiver);
        if (virtualFile != null) {
            VirtualFile $receiver2 = virtualFile;
            VirtualFile vfile = $receiver2;
            psiDirectory = PsiManager.getInstance((Project)project).findDirectory(vfile);
        } else {
            psiDirectory = null;
        }
        return psiDirectory;
    }

    @NotNull
    public static final PsiElement getUsageContext(@JetValueParameter(name="$receiver") PsiElement $receiver) {
        PsiElement psiElement;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiElement psiElement2 = $receiver;
        if (psiElement2 instanceof JetElement) {
            psiElement = PsiTreeUtil.getParentOfType((PsiElement)$receiver, (Class[])new Class[]{JetNamedDeclaration.class, JetFile.class});
            if (psiElement == null) {
                Intrinsics.throwNpe();
            }
        } else {
            PsiElement psiElement3 = ConflictsUtil.getContainer((PsiElement)$receiver);
            psiElement = psiElement3;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"ConflictsUtil.getContainer(this)");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"when (this) {\n        is\u2026.getContainer(this)\n    }");
        return psiElement;
    }

    public static final boolean isInJavaSourceRoot(@JetValueParameter(name="$receiver") PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return !JavaProjectRootsUtil.isOutsideJavaSourceRoot((PsiFile)$receiver.getContainingFile());
    }

    @inline
    @NotNull
    public static final JetFile createTempCopy(@JetValueParameter(name="$receiver") JetFile $receiver, @JetValueParameter(name="textTransform") @NotNull Function1<? super String, ? extends String> textTransform) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(textTransform, (String)"textTransform");
        JetPsiFactory jetPsiFactory = org.jetbrains.kotlin.psi.PsiPackage.JetPsiFactory((PsiElement)$receiver);
        String string = $receiver.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getName()");
        String string2 = $receiver.getText();
        if (string2 == null) {
            string2 = "";
        }
        JetFile tmpFile = jetPsiFactory.createAnalyzableFile(string, (String)textTransform.invoke((Object)string2), (PsiElement)$receiver);
        tmpFile.setOriginalFile((PsiFile)$receiver);
        CodeFragmentUtilPackage.setSuppressDiagnosticsInDebugMode(tmpFile, CodeFragmentUtilPackage.getSuppressDiagnosticsInDebugMode($receiver));
        return tmpFile;
    }

    @NotNull
    public static final List<JetElement> getAllExtractionContainers(@JetValueParameter(name="$receiver") PsiElement $receiver, @JetValueParameter(name="strict") boolean strict) {
        PsiElement element;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ArrayList<JetElement> containers = new ArrayList<JetElement>();
        PsiElement psiElement = element = strict ? $receiver.getParent() : $receiver;
        while (element != null) {
            PsiElement psiElement2 = element;
            if (psiElement2 instanceof JetBlockExpression || psiElement2 instanceof JetClassBody || psiElement2 instanceof JetFile) {
                PsiElement psiElement3 = element;
                if (psiElement3 == null) {
                    throw new TypeCastException("com.intellij.psi.PsiElement? cannot be cast to org.jetbrains.kotlin.psi.JetElement");
                }
                containers.add((JetElement)psiElement3);
            }
            PsiElement psiElement4 = element;
            if (psiElement4 == null) {
                Intrinsics.throwNpe();
            }
            element = psiElement4.getParent();
        }
        return containers;
    }

    @NotNull
    public static /* synthetic */ List getAllExtractionContainers$default(PsiElement psiElement, boolean bl, int n) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return RefactoringPackage$jetRefactoringUtil$12783858.getAllExtractionContainers(psiElement, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<JetElement> getExtractionContainers(@JetValueParameter(name="$receiver") PsiElement $receiver, @JetValueParameter(name="strict") boolean strict, @JetValueParameter(name="includeAll") boolean includeAll) {
        List<Object> list;
        PsiElement enclosingDeclaration;
        PsiElement psiElement;
        Object it;
        PsiElement psiElement2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        getExtractionContainers.1 getEnclosingDeclaration$ = getExtractionContainers.1.INSTANCE$;
        if (includeAll) {
            return RefactoringPackage$jetRefactoringUtil$12783858.getAllExtractionContainers($receiver, strict);
        }
        PsiElement psiElement3 = getEnclosingDeclaration$.invoke($receiver, strict);
        if (psiElement3 != null) {
            void $receiver2;
            psiElement2 = psiElement3;
            it = (PsiElement)$receiver2;
            psiElement = it instanceof JetDeclarationWithBody || it instanceof JetClassInitializer ? getExtractionContainers.1.INSTANCE$.invoke((PsiElement)it, true) : it;
        } else {
            psiElement = null;
        }
        psiElement2 = enclosingDeclaration = psiElement;
        if (psiElement2 instanceof JetFile) {
            List<Object> list2 = Collections.singletonList(enclosingDeclaration);
            list = list2;
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Collections.singletonList(enclosingDeclaration)");
        } else if (psiElement2 instanceof JetClassBody) {
            void destination;
            void $receiver3;
            void $receiver4;
            it = RefactoringPackage$jetRefactoringUtil$12783858.getAllExtractionContainers($receiver, strict);
            void var7_7 = $receiver4;
            Collection collection = new ArrayList();
            for (Object element : $receiver3) {
                if (!(element instanceof JetClassBody)) continue;
                destination.add(element);
            }
            list = (List)destination;
        } else {
            PsiElement psiElement4 = enclosingDeclaration;
            JetExpression targetContainer = psiElement4 instanceof JetDeclarationWithBody ? ((JetDeclarationWithBody)enclosingDeclaration).getBodyExpression() : (psiElement4 instanceof JetClassInitializer ? ((JetClassInitializer)enclosingDeclaration).getBody() : (JetExpression)null);
            list = targetContainer instanceof JetBlockExpression ? Collections.singletonList(targetContainer) : Collections.emptyList();
        }
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"when (enclosingDeclarati\u2026ptyList()\n        }\n    }");
        return list;
    }

    @NotNull
    public static /* synthetic */ List getExtractionContainers$default(PsiElement psiElement, boolean bl, boolean bl2, int n) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return RefactoringPackage$jetRefactoringUtil$12783858.getExtractionContainers(psiElement, bl, bl2);
    }

    public static final void checkConflictsInteractively(@JetValueParameter(name="$receiver") Project $receiver, @JetValueParameter(name="conflicts") @NotNull MultiMap<PsiElement, String> conflicts2, @JetValueParameter(name="onAccept") @NotNull Function0<? extends Unit> onAccept) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(conflicts2, (String)"conflicts");
        Intrinsics.checkParameterIsNotNull(onAccept, (String)"onAccept");
        if (!conflicts2.isEmpty()) {
            Application application = ApplicationManager.getApplication();
            if (application == null) {
                Intrinsics.throwNpe();
            }
            if (application.isUnitTestMode()) {
                throw (Throwable)new BaseRefactoringProcessor.ConflictsInTestsException(conflicts2.values());
            }
            Function0<? extends Unit> function0 = onAccept;
            ConflictsDialog dialog2 = new ConflictsDialog($receiver, conflicts2, (Runnable)(function0 == null ? null : new RefactoringPackage$sam$Runnable$738b3719(function0)));
            dialog2.show();
            if (!dialog2.isOK()) {
                return;
            }
        }
        onAccept.invoke();
    }

    public static final void reportDeclarationConflict(@JetValueParameter(name="conflicts") @NotNull MultiMap<PsiElement, String> conflicts2, @JetValueParameter(name="declaration") @NotNull PsiElement declaration, @JetValueParameter(name="message") @NotNull Function1<? super String, ? extends String> message) {
        Intrinsics.checkParameterIsNotNull(conflicts2, (String)"conflicts");
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        conflicts2.putValue((Object)declaration, message.invoke((Object)KotlinPackage.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)declaration, (boolean)true))));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T, E extends PsiElement> JBPopup getPsiElementPopup(@JetValueParameter(name="editor") @NotNull Editor editor, @JetValueParameter(name="elements") @NotNull List<? extends T> elements, @JetValueParameter(name="renderer") @NotNull PsiElementListCellRenderer<E> renderer, @JetValueParameter(name="title", type="?") @Nullable String title, @JetValueParameter(name="highlightSelection") boolean highlightSelection, @JetValueParameter(name="toPsi") @NotNull Function1<? super T, ? extends E> toPsi, @JetValueParameter(name="processor") @NotNull Function1<? super T, ? extends Boolean> processor) {
        PopupChooserBuilder popupChooserBuilder;
        void receiver;
        String destination;
        PopupChooserBuilder $receiver;
        PopupChooserBuilder $receiver2;
        JBList jBList;
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        Intrinsics.checkParameterIsNotNull(renderer, (String)"renderer");
        Intrinsics.checkParameterIsNotNull(toPsi, (String)"toPsi");
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        SelectionAwareScopeHighlighter highlighter = highlightSelection ? new SelectionAwareScopeHighlighter(editor) : (SelectionAwareScopeHighlighter)null;
        Iterable iterable = elements;
        JBList jBList2 = jBList;
        JBList jBList3 = jBList;
        void var10_11 = $receiver2;
        Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            destination.add(toPsi.invoke(item));
        }
        List list = (List)((Object)destination);
        jBList2((Collection)list);
        JBList list2 = jBList3;
        list2.setCellRenderer((ListCellRenderer)renderer);
        ((JList)list2).addListSelectionListener(new ListSelectionListener(highlighter, list2){
            final /* synthetic */ SelectionAwareScopeHighlighter $highlighter;
            final /* synthetic */ JBList $list;

            public final void valueChanged(@JetValueParameter(name="e") ListSelectionEvent e) {
                Unit unit;
                SelectionAwareScopeHighlighter selectionAwareScopeHighlighter = this.$highlighter;
                if (selectionAwareScopeHighlighter != null) {
                    selectionAwareScopeHighlighter.dropHighlight();
                    unit = Unit.INSTANCE$;
                } else {
                    unit = null;
                }
                int index2 = this.$list.getSelectedIndex();
                if (index2 >= 0) {
                    Unit unit2;
                    SelectionAwareScopeHighlighter selectionAwareScopeHighlighter2 = this.$highlighter;
                    if (selectionAwareScopeHighlighter2 != null) {
                        ListModel listModel = this.$list.getModel();
                        if (listModel == null) {
                            Intrinsics.throwNpe();
                        }
                        E e2 = listModel.getElementAt(index2);
                        if (e2 == null) {
                            throw new TypeCastException("kotlin.Any! cannot be cast to com.intellij.psi.PsiElement");
                        }
                        selectionAwareScopeHighlighter2.highlight((PsiElement)e2);
                        unit2 = Unit.INSTANCE$;
                    } else {
                        unit2 = null;
                    }
                }
            }
            {
                this.$highlighter = selectionAwareScopeHighlighter;
                this.$list = jBList;
            }
        });
        $receiver2 = new PopupChooserBuilder((JList)list2);
        $receiver = (PopupChooserBuilder)receiver;
        String string = title;
        if (string != null) {
            void $receiver3;
            destination = string;
            String it = (String)$receiver3;
            popupChooserBuilder = $receiver.setTitle(it);
        } else {
            popupChooserBuilder = null;
        }
        renderer.installSpeedSearch($receiver, true);
        $receiver.setItemChoosenCallback(new Runnable(title, renderer, list2, processor, elements, highlighter){
            final /* synthetic */ String $title$inlined;
            final /* synthetic */ PsiElementListCellRenderer $renderer$inlined;
            final /* synthetic */ JBList $list$inlined;
            final /* synthetic */ Function1 $processor$inlined;
            final /* synthetic */ List $elements$inlined;
            final /* synthetic */ SelectionAwareScopeHighlighter $highlighter$inlined;

            public final void run() {
                int index2 = this.$list$inlined.getSelectedIndex();
                if (index2 >= 0) {
                    this.$processor$inlined.invoke(this.$elements$inlined.get(index2));
                }
            }
            {
                this.$title$inlined = string;
                this.$renderer$inlined = psiElementListCellRenderer;
                this.$list$inlined = jBList;
                this.$processor$inlined = function1;
                this.$elements$inlined = list;
                this.$highlighter$inlined = selectionAwareScopeHighlighter;
            }
        });
        $receiver.addListener((JBPopupListener)new JBPopupAdapter(title, renderer, list2, processor, elements, highlighter){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ String $title$inlined;
            final /* synthetic */ PsiElementListCellRenderer $renderer$inlined;
            final /* synthetic */ JBList $list$inlined;
            final /* synthetic */ Function1 $processor$inlined;
            final /* synthetic */ List $elements$inlined;
            final /* synthetic */ SelectionAwareScopeHighlighter $highlighter$inlined;

            static {
                $kotlinClass = Reflection.createKotlinClass(getPsiElementPopup$$inlined$with$lambda$2.class);
            }

            public void onClosed(LightweightWindowEvent event) {
                Unit unit;
                SelectionAwareScopeHighlighter selectionAwareScopeHighlighter = this.$highlighter$inlined;
                if (selectionAwareScopeHighlighter != null) {
                    selectionAwareScopeHighlighter.dropHighlight();
                    unit = Unit.INSTANCE$;
                } else {
                    unit = null;
                }
            }
            {
                this.$title$inlined = string;
                this.$renderer$inlined = psiElementListCellRenderer;
                this.$list$inlined = jBList;
                this.$processor$inlined = function1;
                this.$elements$inlined = list;
                this.$highlighter$inlined = selectionAwareScopeHighlighter;
            }
        });
        JBPopup jBPopup = $receiver.createPopup();
        Intrinsics.checkExpressionValueIsNotNull((Object)jBPopup, (String)"with(PopupChooserBuilder\u2026      createPopup()\n    }");
        return jBPopup;
    }

    /*
     * WARNING - void declaration
     */
    public static final int getLineCount(@JetValueParameter(name="$receiver") PsiElement $receiver) {
        void var3_4;
        Document doc;
        Document document;
        Object $receiver2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiFile psiFile = $receiver.getContainingFile();
        if (psiFile != null) {
            $receiver2 = psiFile;
            PsiFile file = $receiver2;
            document = PsiDocumentManager.getInstance((Project)$receiver.getProject()).getDocument(file);
        } else {
            document = doc = null;
        }
        if (doc != null) {
            TextRange textRange = $receiver.getTextRange();
            if (textRange == null) {
                textRange = TextRange.EMPTY_RANGE;
            }
            TextRange spaceRange = textRange;
            int startLine = doc.getLineNumber(spaceRange.getStartOffset());
            int endLine = doc.getLineNumber(spaceRange.getEndOffset());
            return endLine - startLine;
        }
        String string = $receiver.getText();
        if (string == null) {
            string = "";
        }
        $receiver2 = string;
        int count = 0;
        CharIterator charIterator = KotlinPackage.iterator((CharSequence)((CharSequence)$receiver2));
        while (charIterator.hasNext()) {
            char element = charIterator.nextChar();
            char it = element;
            if (!(it == '\n')) continue;
            ++count;
        }
        return (int)(var3_4 + true);
    }

    public static final boolean isMultiLine(@JetValueParameter(name="$receiver") PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return RefactoringPackage$jetRefactoringUtil$12783858.getLineCount($receiver) > 1;
    }

    @Nullable
    public static final BindingContext getContextForContainingDeclarationBody(@JetValueParameter(name="$receiver") JetElement $receiver) {
        BindingContext bindingContext2;
        JetElement bodyElement;
        JetDelegationSpecifierList delegationSpecifierList;
        JetDeclaration enclosingDeclaration;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiElement $receiver2 = (PsiElement)$receiver;
        JetDeclaration jetDeclaration = enclosingDeclaration = (JetDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$receiver2, JetDeclaration.class, (boolean)true);
        JetElement jetElement = jetDeclaration instanceof JetDeclarationWithBody ? (JetElement)((JetDeclarationWithBody)enclosingDeclaration).getBodyExpression() : (jetDeclaration instanceof JetWithExpressionInitializer ? (JetElement)((JetWithExpressionInitializer)((Object)enclosingDeclaration)).getInitializer() : (jetDeclaration instanceof JetMultiDeclaration ? (JetElement)((JetMultiDeclaration)enclosingDeclaration).getInitializer() : (jetDeclaration instanceof JetParameter ? (JetElement)((JetParameter)enclosingDeclaration).getDefaultValue() : (jetDeclaration instanceof JetClassInitializer ? (JetElement)((JetClassInitializer)enclosingDeclaration).getBody() : (jetDeclaration instanceof JetClass ? (PsiUtilPackage.isAncestor$default((PsiElement)(delegationSpecifierList = ((JetClass)enclosingDeclaration).getDelegationSpecifierList()), (PsiElement)$receiver, false, 2) ? $receiver : (JetElement)null) : (JetElement)null)))));
        JetElement jetElement2 = bodyElement = jetElement;
        if (jetElement2 != null) {
            JetElement $receiver3 = jetElement2;
            JetElement it = $receiver3;
            bindingContext2 = ResolvePackage.analyze$default(it, null, 1);
        } else {
            bindingContext2 = null;
        }
        return bindingContext2;
    }

    public static final <T> void chooseContainerElement(@JetValueParameter(name="containers") @NotNull List<? extends T> containers, @JetValueParameter(name="editor") @NotNull Editor editor, @JetValueParameter(name="title") @NotNull String title, @JetValueParameter(name="highlightSelection") boolean highlightSelection, @JetValueParameter(name="toPsi") @NotNull Function1<? super T, ? extends PsiElement> toPsi, @JetValueParameter(name="onSelect") @NotNull Function1<? super T, ? extends Unit> onSelect) {
        Intrinsics.checkParameterIsNotNull(containers, (String)"containers");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull(toPsi, (String)"toPsi");
        Intrinsics.checkParameterIsNotNull(onSelect, (String)"onSelect");
        RefactoringPackage$jetRefactoringUtil$12783858.getPsiElementPopup(editor, containers, (PsiElementListCellRenderer)new PsiElementListCellRenderer<PsiElement>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(chooseContainerElement.1.class);
            }

            /*
             * WARNING - void declaration
             */
            private final String renderName(@JetValueParameter(name="$receiver") PsiElement $receiver) {
                Object object;
                if ($receiver instanceof JetPropertyAccessor) {
                    PsiElement psiElement = ((JetPropertyAccessor)$receiver).getParent();
                    if (psiElement == null) {
                        throw new TypeCastException("com.intellij.psi.PsiElement! cannot be cast to org.jetbrains.kotlin.psi.JetProperty");
                    }
                    return this.renderName((JetProperty)psiElement) + (((JetPropertyAccessor)$receiver).isGetter() ? ".get" : ".set");
                }
                if ($receiver instanceof JetObjectDeclaration && ((JetObjectDeclaration)$receiver).isCompanion()) {
                    void $receiver2;
                    PsiElement psiElement = $receiver;
                    StringBuilder stringBuilder = new StringBuilder().append("Companion object of ");
                    PsiElement psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)$receiver2, JetClassOrObject.class, (boolean)true);
                    Object object2 = (JetClassOrObject)psiElement2;
                    if (object2 == null || (object2 = this.renderName((PsiElement)object2)) == null) {
                        object2 = "<anonymous>";
                    }
                    return stringBuilder.append((String)object2).toString();
                }
                PsiElement psiElement = $receiver;
                if (!(psiElement instanceof PsiNamedElement)) {
                    psiElement = null;
                }
                if ((object = (PsiNamedElement)psiElement) == null || (object = object.getName()) == null) {
                    object = "<anonymous>";
                }
                return object;
            }

            /*
             * WARNING - void declaration
             */
            private final String renderDeclaration(@JetValueParameter(name="$receiver") PsiElement $receiver) {
                Object object;
                String name2;
                block7: {
                    block6: {
                        void destination;
                        void $receiver2;
                        void $receiver3;
                        void $receiver4;
                        Object object2 = $receiver instanceof JetFile ? ((JetFile)$receiver).getName() : ($receiver instanceof JetElement ? ResolvePackage.analyze$default((JetElement)$receiver, null, 1).get(BindingContext.DECLARATION_TO_DESCRIPTOR, $receiver) : ($receiver instanceof PsiMember ? ResolvePackage.getJavaMemberDescriptor((PsiMember)$receiver) : null));
                        if (object2 == null) {
                            return null;
                        }
                        String descriptor2 = object2;
                        name2 = this.renderName($receiver);
                        String string = descriptor2;
                        if (!(string instanceof FunctionDescriptor)) {
                            string = null;
                        }
                        if ((object = (FunctionDescriptor)((Object)string)) == null) break block6;
                        FunctionDescriptor functionDescriptor = object;
                        FunctionDescriptor descriptor3 = (FunctionDescriptor)$receiver4;
                        Iterable iterable = descriptor3.getValueParameters();
                        void var8_7 = $receiver3;
                        Collection collection = new ArrayList<E>(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver3, (int)10));
                        for (T item : $receiver2) {
                            void it;
                            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item;
                            void var13_12 = destination;
                            String string2 = DescriptorRenderer.SHORT_NAMES_IN_TYPES.renderType(it.getType());
                            var13_12.add(string2);
                        }
                        object = KotlinPackage.joinToString$default((Iterable)((List)destination), (String)", ", (String)"(", (String)")", (int)0, null, null, (int)56);
                        if (object != null) break block7;
                    }
                    object = "";
                }
                Object params2 = object;
                return name2 + (String)params2;
            }

            private final String renderText(@JetValueParameter(name="$receiver") PsiElement $receiver) {
                String string = $receiver.getText();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                String string2 = StringUtil.shortenTextWithEllipsis((String)StringPackage.collapseSpaces(string), (int)53, (int)0);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringUtil.shortenTextWi\u2026.collapseSpaces(), 53, 0)");
                return string2;
            }

            private final PsiElement getRepresentativeElement(@JetValueParameter(name="$receiver") PsiElement $receiver) {
                PsiElement psiElement;
                PsiElement psiElement2 = $receiver;
                if (psiElement2 instanceof JetBlockExpression) {
                    PsiElement psiElement3 = ((JetBlockExpression)$receiver).getParent();
                    if (!(psiElement3 instanceof JetDeclarationWithBody)) {
                        psiElement3 = null;
                    }
                    JetDeclarationWithBody jetDeclarationWithBody = (JetDeclarationWithBody)psiElement3;
                    psiElement = (PsiElement)(jetDeclarationWithBody != null ? (JetExpression)jetDeclarationWithBody : (JetExpression)$receiver);
                } else if (psiElement2 instanceof JetClassBody) {
                    PsiElement psiElement4 = ((JetClassBody)$receiver).getParent();
                    if (psiElement4 == null) {
                        throw new TypeCastException("com.intellij.psi.PsiElement! cannot be cast to org.jetbrains.kotlin.psi.JetClassOrObject");
                    }
                    psiElement = (JetClassOrObject)psiElement4;
                } else {
                    psiElement = $receiver;
                }
                return psiElement;
            }

            @Nullable
            public String getElementText(@JetValueParameter(name="element") @NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                PsiElement representativeElement = this.getRepresentativeElement(element);
                String string = this.renderDeclaration(representativeElement);
                if (string == null) {
                    string = this.renderText(representativeElement);
                }
                return string;
            }

            @Nullable
            protected String getContainerText(@JetValueParameter(name="element") @NotNull PsiElement element, @JetValueParameter(name="name", type="?") @Nullable String name2) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                return null;
            }

            protected int getIconFlags() {
                return 0;
            }

            @Nullable
            protected Icon getIcon(@JetValueParameter(name="element") @NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                return super.getIcon(this.getRepresentativeElement(element));
            }
        }, title, highlightSelection, toPsi, (Function1)new Function1<T, Boolean>(onSelect){
            final /* synthetic */ Function1 $onSelect;

            public final boolean invoke(@JetValueParameter(name="it") T it) {
                this.$onSelect.invoke(it);
                return true;
            }
            {
                this.$onSelect = function1;
                super(1);
            }
        }).showInBestPositionFor(editor);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final <T> void chooseContainerElementIfNecessary(@JetValueParameter(name="containers") @NotNull List<? extends T> containers, @JetValueParameter(name="editor") @NotNull Editor editor, @JetValueParameter(name="title") @NotNull String title, @JetValueParameter(name="highlightSelection") boolean highlightSelection, @JetValueParameter(name="toPsi") @NotNull Function1<? super T, ? extends PsiElement> toPsi, @JetValueParameter(name="onSelect") @NotNull Function1<? super T, ? extends Unit> onSelect) {
        Intrinsics.checkParameterIsNotNull(containers, (String)"containers");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull(toPsi, (String)"toPsi");
        Intrinsics.checkParameterIsNotNull(onSelect, (String)"onSelect");
        if (containers.isEmpty()) {
            return;
        }
        if (containers.size() != 1) {
            Application application = ApplicationManager.getApplication();
            if (application == null) {
                Intrinsics.throwNpe();
            }
            if (!application.isUnitTestMode()) {
                RefactoringPackage$jetRefactoringUtil$12783858.chooseContainerElement(containers, editor, title, highlightSelection, toPsi, onSelect);
                return;
            }
        }
        onSelect.invoke(KotlinPackage.first(containers));
    }

    public static final boolean isTrueJavaMethod(@JetValueParameter(name="$receiver") PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof PsiMethod && !($receiver instanceof KotlinLightMethod);
    }

    public static final boolean canRefactor(@JetValueParameter(name="$receiver") PsiElement $receiver) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            if ($receiver instanceof PsiPackage) {
                Object[] $receiver2 = ((PsiPackage)$receiver).getDirectories();
                for (int i = 0; i < $receiver2.length; ++i) {
                    Object element = $receiver2[i];
                    PsiDirectory it = (PsiDirectory)element;
                    if (!RefactoringPackage$jetRefactoringUtil$12783858.canRefactor((PsiElement)it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            } else {
                bl = $receiver instanceof JetElement || $receiver instanceof PsiMember && Intrinsics.areEqual((Object)((PsiMember)$receiver).getLanguage(), (Object)JavaLanguage.INSTANCE) || $receiver instanceof PsiDirectory ? $receiver.isWritable() && ProjectRootsUtil.isInProjectSource($receiver) : false;
            }
        }
        return bl;
    }

    public static final void copyModifierListItems(@JetValueParameter(name="from") @NotNull PsiModifierList from, @JetValueParameter(name="to") @NotNull PsiModifierList to, @JetValueParameter(name="withPsiModifiers") boolean withPsiModifiers) {
        int n;
        String[] stringArray;
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        if (withPsiModifiers) {
            stringArray = PsiModifier.MODIFIERS;
            for (n = 0; n < stringArray.length; ++n) {
                String modifier = stringArray[n];
                if (!from.hasExplicitModifier(modifier)) continue;
                to.setModifierProperty(modifier, true);
            }
        }
        stringArray = from.getAnnotations();
        for (n = 0; n < stringArray.length; ++n) {
            String annotation2 = stringArray[n];
            to.addAnnotation(annotation2.getQualifiedName());
        }
    }

    public static /* synthetic */ void copyModifierListItems$default(PsiModifierList psiModifierList, PsiModifierList psiModifierList2, boolean bl, int n) {
        if ((n & 4) != 0) {
            bl = true;
        }
        RefactoringPackage$jetRefactoringUtil$12783858.copyModifierListItems(psiModifierList, psiModifierList2, bl);
    }

    /*
     * WARNING - void declaration
     */
    public static final <T extends PsiTypeParameterListOwner & PsiNameIdentifierOwner> void copyTypeParameters(@JetValueParameter(name="from") @NotNull T from, @JetValueParameter(name="to") @NotNull T to, @JetValueParameter(name="inserter") @NotNull Function2<? super T, ? super PsiTypeParameterList, ? extends Unit> inserter) {
        Intrinsics.checkParameterIsNotNull(from, (String)"from");
        Intrinsics.checkParameterIsNotNull(to, (String)"to");
        Intrinsics.checkParameterIsNotNull(inserter, (String)"inserter");
        PsiElementFactory factory2 = PsiElementFactory.SERVICE.getInstance((Project)((PsiElement)from).getProject());
        PsiTypeParameter[] psiTypeParameterArray = from.getTypeParameterList();
        if (psiTypeParameterArray == null || (psiTypeParameterArray = psiTypeParameterArray.getTypeParameters()) == null) {
            psiTypeParameterArray = PsiTypeParameter.EMPTY_ARRAY;
            Intrinsics.checkExpressionValueIsNotNull((Object)PsiTypeParameter.EMPTY_ARRAY, (String)"PsiTypeParameter.EMPTY_ARRAY");
        }
        PsiTypeParameter[] templateTypeParams = psiTypeParameterArray;
        if (KotlinPackage.isNotEmpty((Object[])templateTypeParams)) {
            void destination;
            void $receiver;
            void $receiver2;
            PsiTypeParameterList psiTypeParameterList = factory2.createTypeParameterList();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiTypeParameterList, (String)"factory.createTypeParameterList()");
            inserter.invoke(to, (Object)psiTypeParameterList);
            PsiTypeParameterList targetTypeParamList = to.getTypeParameterList();
            Object[] objectArray = templateTypeParams;
            void var8_7 = $receiver2;
            Collection collection = new ArrayList(((void)$receiver2).length);
            for (int i = 0; i < ((void)$receiver).length; ++i) {
                void it;
                void item = $receiver[i];
                PsiTypeParameter psiTypeParameter = (PsiTypeParameter)item;
                void var13_12 = destination;
                PsiTypeParameter psiTypeParameter2 = factory2.createTypeParameter(it.getName(), it.getExtendsList().getReferencedTypes());
                var13_12.add(psiTypeParameter2);
            }
            List newTypeParams = (List)destination;
            ChangeSignatureUtil.synchronizeList((PsiElement)((PsiElement)targetTypeParamList), (List)newTypeParams, (ChangeSignatureUtil.ChildrenGenerator)copyTypeParameters.1.INSTANCE$, (boolean[])new boolean[newTypeParams.size()]);
        }
    }

    @NotNull
    public static final PsiMethod createJavaMethod(@JetValueParameter(name="function") @NotNull JetFunction function2, @JetValueParameter(name="targetClass") @NotNull PsiClass targetClass) {
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        Intrinsics.checkParameterIsNotNull((Object)targetClass, (String)"targetClass");
        PsiMethod psiMethod = LightClassUtil.getLightClassMethod(function2);
        if (psiMethod == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Can't generate light method: " + PsiUtilPackage.getElementTextWithContext(function2))));
        }
        PsiMethod template = psiMethod;
        return RefactoringPackage$jetRefactoringUtil$12783858.createJavaMethod(template, targetClass);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final PsiMethod createJavaMethod(@JetValueParameter(name="template") @NotNull PsiMethod template, @JetValueParameter(name="targetClass") @NotNull PsiClass targetClass) {
        void destination;
        void $receiver;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull((Object)template, (String)"template");
        Intrinsics.checkParameterIsNotNull((Object)targetClass, (String)"targetClass");
        PsiElementFactory factory2 = PsiElementFactory.SERVICE.getInstance((Project)template.getProject());
        PsiMethod methodToAdd = template.isConstructor() ? factory2.createConstructor(template.getName()) : factory2.createMethod(template.getName(), template.getReturnType());
        PsiElement psiElement = targetClass.add((PsiElement)methodToAdd);
        if (psiElement == null) {
            throw new TypeCastException("com.intellij.psi.PsiElement! cannot be cast to com.intellij.psi.PsiMethod");
        }
        PsiMethod method = (PsiMethod)psiElement;
        PsiModifierList psiModifierList = template.getModifierList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiModifierList, (String)"template.getModifierList()");
        PsiModifierList psiModifierList2 = method.getModifierList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiModifierList2, (String)"method.getModifierList()");
        RefactoringPackage$jetRefactoringUtil$12783858.copyModifierListItems$default(psiModifierList, psiModifierList2, false, 4);
        RefactoringPackage$jetRefactoringUtil$12783858.copyTypeParameters((PsiTypeParameterListOwner)template, (PsiTypeParameterListOwner)method, createJavaMethod.1.INSTANCE$);
        PsiParameterList targetParamList = method.getParameterList();
        Object[] objectArray = template.getParameterList().getParameters();
        void var8_7 = $receiver2;
        Collection collection = new ArrayList(((void)$receiver2).length);
        for (int i = 0; i < ((void)$receiver).length; ++i) {
            void it;
            void item = $receiver[i];
            PsiParameter psiParameter = (PsiParameter)item;
            void var14_13 = destination;
            PsiParameter param = factory2.createParameter(it.getName(), it.getType());
            PsiModifierList psiModifierList3 = it.getModifierList();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiModifierList3, (String)"it.getModifierList()");
            PsiModifierList psiModifierList4 = param.getModifierList();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiModifierList4, (String)"param.getModifierList()");
            RefactoringPackage$jetRefactoringUtil$12783858.copyModifierListItems$default(psiModifierList3, psiModifierList4, false, 4);
            PsiParameter psiParameter2 = param;
            var14_13.add(psiParameter2);
        }
        List newParams = (List)destination;
        ChangeSignatureUtil.synchronizeList((PsiElement)((PsiElement)targetParamList), (List)newParams, (ChangeSignatureUtil.ChildrenGenerator)createJavaMethod.2.INSTANCE$, (boolean[])new boolean[newParams.size()]);
        if (template.getModifierList().hasModifierProperty(PsiModifier.ABSTRACT) || targetClass.isInterface()) {
            method.getBody().delete();
        } else if (!template.isConstructor()) {
            CreateFromUsageUtils.setupMethodBody((PsiMethod)method);
        }
        return method;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final PsiField createJavaField(@JetValueParameter(name="property") @NotNull JetProperty property, @JetValueParameter(name="targetClass") @NotNull PsiClass targetClass) {
        void receiver;
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        Intrinsics.checkParameterIsNotNull((Object)targetClass, (String)"targetClass");
        PsiMethod psiMethod = LightClassUtil.getLightClassPropertyMethods(property).getGetter();
        if (psiMethod == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Can't generate light method: " + PsiUtilPackage.getElementTextWithContext(property))));
        }
        PsiMethod template = psiMethod;
        PsiElementFactory factory2 = PsiElementFactory.SERVICE.getInstance((Project)template.getProject());
        PsiElement psiElement = targetClass.add((PsiElement)factory2.createField(property.getName(), template.getReturnType()));
        if (psiElement == null) {
            throw new TypeCastException("com.intellij.psi.PsiElement! cannot be cast to com.intellij.psi.PsiField");
        }
        PsiField field = (PsiField)psiElement;
        PsiModifierList psiModifierList = field.getModifierList();
        PsiModifierList $receiver = (PsiModifierList)receiver;
        PsiModifierList templateModifiers = template.getModifierList();
        $receiver.setModifierProperty(VisibilityUtil.getVisibilityModifier((PsiModifierList)templateModifiers), true);
        if (!property.isVar() || targetClass.isInterface()) {
            $receiver.setModifierProperty(PsiModifier.FINAL, true);
        }
        PsiModifierList psiModifierList2 = templateModifiers;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiModifierList2, (String)"templateModifiers");
        PsiModifierList psiModifierList3 = $receiver;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiModifierList3, (String)"this");
        RefactoringPackage$jetRefactoringUtil$12783858.copyModifierListItems(psiModifierList2, psiModifierList3, false);
        return field;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final PsiMember createJavaClass(@JetValueParameter(name="klass") @NotNull JetClass klass, @JetValueParameter(name="targetClass") @NotNull PsiClass targetClass) {
        Intrinsics.checkParameterIsNotNull((Object)klass, (String)"klass");
        Intrinsics.checkParameterIsNotNull((Object)targetClass, (String)"targetClass");
        v0 = ResolvePackage.resolveToDescriptor(klass);
        if (v0 == null) {
            throw new TypeCastException("org.jetbrains.kotlin.descriptors.DeclarationDescriptor cannot be cast to org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        kind = ((ClassDescriptor)v0).getKind();
        factory = PsiElementFactory.SERVICE.getInstance((Project)klass.getProject());
        v1 = kind;
        if (v1 == null) ** GOTO lbl-1000
        switch (RefactoringPackage$jetRefactoringUtil$12783858$WhenMappings.$EnumSwitchMapping$0[v1.ordinal()]) {
            case 1: {
                v2 = factory.createClass(klass.getName());
                break;
            }
            case 2: {
                v2 = factory.createInterface(klass.getName());
                break;
            }
            case 3: {
                v2 = factory.createAnnotationType(klass.getName());
                break;
            }
            case 4: {
                v2 = factory.createEnum(klass.getName());
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                throw (Throwable)new AssertionError((Object)("Unexpected class kind: " + PsiUtilPackage.getElementTextWithContext(klass)));
            }
        }
        javaClassToAdd = v2;
        v3 = targetClass.add((PsiElement)javaClassToAdd);
        if (v3 == null) {
            throw new TypeCastException("com.intellij.psi.PsiElement! cannot be cast to com.intellij.psi.PsiClass");
        }
        javaClass = (PsiClass)v3;
        v4 = LightClassUtil.getPsiClass(klass);
        if (v4 == null) {
            throw (Throwable)new AssertionError((Object)("Can't generate light class: " + PsiUtilPackage.getElementTextWithContext(klass)));
        }
        template = v4;
        v5 = template.getModifierList();
        Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"template.getModifierList()");
        v6 = javaClass.getModifierList();
        Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"javaClass.getModifierList()");
        RefactoringPackage$jetRefactoringUtil$12783858.copyModifierListItems$default(v5, v6, false, 4);
        if (template.isInterface()) {
            javaClass.getModifierList().setModifierProperty(PsiModifier.ABSTRACT, false);
        }
        RefactoringPackage$jetRefactoringUtil$12783858.copyTypeParameters((PsiTypeParameterListOwner)template, (PsiTypeParameterListOwner)javaClass, createJavaClass.1.INSTANCE$);
        v7 = template.getExtendsList();
        if (v7 == null || (v7 = v7.getReferenceElements()) == null) {
            v7 = PsiJavaCodeReferenceElement.EMPTY_ARRAY;
            Intrinsics.checkExpressionValueIsNotNull((Object)PsiJavaCodeReferenceElement.EMPTY_ARRAY, (String)"PsiJavaCodeReferenceElement.EMPTY_ARRAY");
        }
        v8 = extendsList = RefactoringPackage$javaElementFactoryUtils$79cd28cc.createReferenceListWithRole(factory, v7, PsiReferenceList.Role.EXTENDS_LIST);
        if (v8 != null) {
            var8_8 = v8;
            it = (PsiReferenceList)$receiver;
            v9 = javaClass.getExtendsList();
            v10 = v9 != null ? v9.replace((PsiElement)it) : null;
        } else {
            v10 = null;
        }
        if ((v11 = template.getImplementsList()) == null || (v11 = v11.getReferenceElements()) == null) {
            v11 = PsiJavaCodeReferenceElement.EMPTY_ARRAY;
            Intrinsics.checkExpressionValueIsNotNull((Object)PsiJavaCodeReferenceElement.EMPTY_ARRAY, (String)"PsiJavaCodeReferenceElement.EMPTY_ARRAY");
        }
        v12 = implementsList = RefactoringPackage$javaElementFactoryUtils$79cd28cc.createReferenceListWithRole(factory, v11, PsiReferenceList.Role.IMPLEMENTS_LIST);
        if (v12 != null) {
            it = v12;
            it = (PsiReferenceList)$receiver;
            v13 = javaClass.getImplementsList();
            v14 = v13 != null ? v13.replace((PsiElement)it) : null;
        } else {
            v14 = null;
        }
        var11_12 = template.getMethods();
        for (var10_11 = 0; var10_11 < var11_12.length; ++var10_11) {
            block21: {
                method = var11_12[var10_11];
                v15 = hasParams = method.getParameterList().getParametersCount() > 0;
                if (template.isEnum()) ** GOTO lbl-1000
                v16 = template.getSuperClass();
                if (v16 == null || (v16 = v16.getConstructors()) == null) {
                    v16 = PsiMethod.EMPTY_ARRAY;
                    Intrinsics.checkExpressionValueIsNotNull((Object)PsiMethod.EMPTY_ARRAY, (String)"PsiMethod.EMPTY_ARRAY");
                }
                var14_15 = v16;
                for (var15_16 = 0; var15_16 < ((PsiMethod)$receiver).length; ++var15_16) {
                    element = $receiver[var15_16];
                    it = element;
                    if (it.getParameterList().getParametersCount() > 0) continue;
                    v17 = false;
                    break block21;
                }
                v17 = true;
            }
            if (v17) {
                v18 = true;
            } else lbl-1000:
            // 2 sources

            {
                v18 = needSuperCall = false;
            }
            if (method.isConstructor() && !hasParams && !needSuperCall) continue;
            v19 = method;
            Intrinsics.checkExpressionValueIsNotNull((Object)v19, (String)"method");
            $receiver = RefactoringPackage$jetRefactoringUtil$12783858.createJavaMethod(v19, javaClass);
            $receiver = (PsiMethod)receiver;
            if (!$receiver.isConstructor() || !needSuperCall) continue;
            $receiver.getBody().add((PsiElement)factory.createStatementFromText("super();", (PsiElement)$receiver));
        }
        return (PsiMember)javaClass;
    }

    @Nullable
    public static final JetExpression j2k(@JetValueParameter(name="$receiver") PsiExpression $receiver) {
        Project project;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (Intrinsics.areEqual((Object)$receiver.getLanguage(), (Object)JavaLanguage.INSTANCE) ^ true) {
            return null;
        }
        Project project2 = project = $receiver.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        JavaToKotlinConverter j2kConverter = new JavaToKotlinConverter(project2, ConverterSettings.Companion.getDefaultSettings(), IdeaReferenceSearcher.INSTANCE$, IdeaResolverForConverter.INSTANCE$);
        Object object = (JavaToKotlinConverter.ElementResult)KotlinPackage.single(j2kConverter.elementsToKotlin(KotlinPackage.listOf((Object)$receiver)).getResults());
        if (object == null || (object = ((JavaToKotlinConverter.ElementResult)object).getText()) == null) {
            return null;
        }
        Object text = object;
        Project project3 = $receiver.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"getProject()");
        return new JetPsiFactory(project3).createExpression((String)text);
    }
}

