/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.hierarchy.calls;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.call.CallHierarchyNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.idea.hierarchy.calls.KotlinCallHierarchyNodeDescriptor;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;

public abstract class KotlinCallTreeStructure
extends HierarchyTreeStructure {
    protected final String scopeType;
    private static final Function1<PsiElement, Boolean> IS_NON_LOCAL_DECLARATION = new Function1<PsiElement, Boolean>(){

        public Boolean invoke(@javax.annotation.Nullable PsiElement input) {
            return input instanceof PsiMethod || (input instanceof JetNamedFunction || input instanceof JetClassOrObject || input instanceof JetProperty) && !JetPsiUtil.isLocal((JetNamedDeclaration)input);
        }
    };

    public KotlinCallTreeStructure(@NotNull Project project, PsiElement element, String scopeType) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCallTreeStructure", "<init>"));
        }
        super(project, KotlinCallTreeStructure.createNodeDescriptor(project, element, null, false));
        this.scopeType = scopeType;
    }

    protected static JetElement getEnclosingElementForLocalDeclaration(PsiElement element) {
        return element instanceof JetNamedDeclaration ? JetPsiUtil.getEnclosingElementForLocalDeclaration((JetNamedDeclaration)element) : null;
    }

    protected static HierarchyNodeDescriptor createNodeDescriptor(Project project, PsiElement element, HierarchyNodeDescriptor parent, boolean navigateToReference) {
        boolean root = parent == null;
        return element instanceof JetElement ? new KotlinCallHierarchyNodeDescriptor(project, parent, element, root, navigateToReference) : new CallHierarchyNodeDescriptor(project, parent, element, root, navigateToReference);
    }

    protected static PsiElement getTargetElement(HierarchyNodeDescriptor descriptor2) {
        return descriptor2 instanceof CallHierarchyNodeDescriptor ? ((CallHierarchyNodeDescriptor)descriptor2).getEnclosingElement() : ((KotlinCallHierarchyNodeDescriptor)descriptor2).getTargetElement();
    }

    @Nullable
    protected static PsiMethod getRepresentativePsiMethod(PsiElement element) {
        while ((element = PsiUtilPackage.getParentOfTypesAndPredicate(element, false, ArrayUtil.EMPTY_CLASS_ARRAY, IS_NON_LOCAL_DECLARATION)) != null) {
            PsiMethod method = KotlinCallTreeStructure.getRepresentativePsiMethodForNonLocalDeclaration(element);
            if (method != null) {
                return method;
            }
            element = element.getParent();
        }
        return null;
    }

    private static PsiMethod getRepresentativePsiMethodForNonLocalDeclaration(PsiElement element) {
        if (element instanceof PsiMethod) {
            return (PsiMethod)element;
        }
        if (element instanceof JetNamedFunction || element instanceof JetSecondaryConstructor) {
            return LightClassUtil.getLightClassMethod((JetFunction)element);
        }
        if (element instanceof JetProperty) {
            LightClassUtil.PropertyAccessorsPsiMethods propertyMethods2 = LightClassUtil.getLightClassPropertyMethods((JetProperty)element);
            return propertyMethods2.getGetter() != null ? propertyMethods2.getGetter() : propertyMethods2.getSetter();
        }
        if (element instanceof JetClassOrObject) {
            PsiClass psiClass = LightClassUtil.getPsiClass((JetClassOrObject)element);
            if (psiClass == null) {
                return null;
            }
            PsiMethod[] constructors2 = psiClass.getConstructors();
            if (constructors2.length > 0) {
                return constructors2[0];
            }
        }
        return null;
    }

    protected static CallHierarchyNodeDescriptor getJavaNodeDescriptor(HierarchyNodeDescriptor originalDescriptor) {
        if (originalDescriptor instanceof CallHierarchyNodeDescriptor) {
            return (CallHierarchyNodeDescriptor)originalDescriptor;
        }
        assert (originalDescriptor instanceof KotlinCallHierarchyNodeDescriptor);
        return ((KotlinCallHierarchyNodeDescriptor)originalDescriptor).getJavaDelegate();
    }

    protected Object[] collectNodeDescriptors(HierarchyNodeDescriptor descriptor2, Map<PsiReference, PsiElement> referencesToCalleeElements, PsiClass basePsiClass) {
        HashMap declarationToDescriptorMap = new HashMap();
        for (Map.Entry<PsiReference, PsiElement> refToCallee : referencesToCalleeElements.entrySet()) {
            PsiReference ref = refToCallee.getKey();
            PsiElement callee = refToCallee.getValue();
            if (basePsiClass != null && !this.isInScope((PsiElement)basePsiClass, callee, this.scopeType)) continue;
            this.addNodeDescriptorForElement(ref, callee, (Map<PsiElement, HierarchyNodeDescriptor>)declarationToDescriptorMap, descriptor2);
        }
        return declarationToDescriptorMap.values().toArray(new Object[declarationToDescriptorMap.size()]);
    }

    protected final void addNodeDescriptorForElement(PsiReference reference, PsiElement element, Map<PsiElement, HierarchyNodeDescriptor> declarationToDescriptorMap, HierarchyNodeDescriptor descriptor2) {
        HierarchyNodeDescriptor d = declarationToDescriptorMap.get(element);
        if (d == null) {
            d = KotlinCallTreeStructure.createNodeDescriptor(this.myProject, element, descriptor2, true);
            declarationToDescriptorMap.put(element, d);
        } else if (d instanceof CallHierarchyNodeDescriptor) {
            ((CallHierarchyNodeDescriptor)d).incrementUsageCount();
        }
        if (d instanceof CallHierarchyNodeDescriptor) {
            ((CallHierarchyNodeDescriptor)d).addReference(reference);
        } else if (d instanceof KotlinCallHierarchyNodeDescriptor) {
            ((KotlinCallHierarchyNodeDescriptor)d).addReference(reference);
        }
    }

    public boolean isAlwaysShowPlus() {
        return true;
    }
}

