/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.ktSignature;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ui.UIUtil;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.JetIcons;
import org.jetbrains.kotlin.idea.caches.resolve.JavaResolveExtension;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.ktSignature.DeleteSignatureAction;
import org.jetbrains.kotlin.idea.ktSignature.EditSignatureAction;
import org.jetbrains.kotlin.idea.ktSignature.KotlinSignatureUtil;
import org.jetbrains.kotlin.idea.project.ProjectStructureUtil;
import org.jetbrains.kotlin.load.java.JavaBindingContext;
import org.jetbrains.kotlin.load.java.structure.impl.JavaConstructorImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaFieldImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaMethodImpl;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.jvm.JavaDescriptorResolver;

public class KotlinSignatureInJavaMarkerProvider
implements LineMarkerProvider {
    private static final String SHOW_MARKERS_PROPERTY = "kotlin.signature.markers.enabled";
    private static final Logger LOG = Logger.getInstance(KotlinSignatureInJavaMarkerProvider.class);
    private static final GutterIconNavigationHandler<PsiModifierListOwner> NAVIGATION_HANDLER = new GutterIconNavigationHandler<PsiModifierListOwner>(){

        public void navigate(MouseEvent e, PsiModifierListOwner element) {
            if (UIUtil.isActionClick((MouseEvent)e, (int)502)) {
                new EditSignatureAction(element).actionPerformed(DataManager.getInstance().getDataContext(e.getComponent()), e.getPoint());
            }
        }
    };

    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureInJavaMarkerProvider", "getLineMarkerInfo"));
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result2) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureInJavaMarkerProvider", "collectSlowLineMarkers"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureInJavaMarkerProvider", "collectSlowLineMarkers"));
        }
        if (elements.isEmpty()) {
            return;
        }
        PsiElement firstElement = elements.get(0);
        Project project = firstElement.getProject();
        if (!KotlinSignatureInJavaMarkerProvider.isMarkersEnabled(project)) {
            return;
        }
        if (!ProjectStructureUtil.hasJvmKotlinModules(project)) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)firstElement);
        if (module != null && !ProjectStructureUtil.isUsedInKotlinJavaModule(module)) {
            return;
        }
        KotlinSignatureInJavaMarkerProvider.markElements(elements, result2, firstElement.getContainingFile());
    }

    private static void markElements(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result2, @NotNull PsiFile psiFile) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureInJavaMarkerProvider", "markElements"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureInJavaMarkerProvider", "markElements"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureInJavaMarkerProvider", "markElements"));
        }
        try {
            for (PsiElement element : elements) {
                KotlinSignatureInJavaMarkerProvider.markElement(element, result2);
            }
        }
        catch (AssertionError error) {
            LOG.warn("Exception while collecting KotlinSignature markers:\n" + ExceptionUtil.getThrowableText((Throwable)((Object)error)));
        }
    }

    private static void markElement(@NotNull PsiElement element, @NotNull Collection<LineMarkerInfo> result2) {
        boolean hasSignatureAnnotation;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureInJavaMarkerProvider", "markElement"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureInJavaMarkerProvider", "markElement"));
        }
        Project project = element.getProject();
        PsiMember annotationOwner = KotlinSignatureUtil.getAnalyzableAnnotationOwner(element);
        if (annotationOwner == null) {
            return;
        }
        JavaResolveExtension resolveExtension = JavaResolveExtension.INSTANCE$;
        BindingContext bindingContext2 = resolveExtension.getContext(project, (PsiElement)annotationOwner);
        JavaDescriptorResolver javaDescriptorResolver = resolveExtension.getResolver(project, (PsiElement)annotationOwner);
        DeclarationDescriptor memberDescriptor = KotlinSignatureInJavaMarkerProvider.getDescriptorForMember(javaDescriptorResolver, (PsiModifierListOwner)annotationOwner);
        if (memberDescriptor == null) {
            return;
        }
        List<String> errors = bindingContext2.get(JavaBindingContext.LOAD_FROM_JAVA_SIGNATURE_ERRORS, memberDescriptor);
        boolean bl = hasSignatureAnnotation = KotlinSignatureUtil.findKotlinSignatureAnnotation((PsiElement)annotationOwner) != null;
        if (errors != null || hasSignatureAnnotation) {
            result2.add(new MyLineMarkerInfo((PsiModifierListOwner)element, errors, hasSignatureAnnotation));
        }
    }

    @Nullable
    private static DeclarationDescriptor getDescriptorForMember(@NotNull JavaDescriptorResolver javaDescriptorResolver, @NotNull PsiModifierListOwner member) {
        if (javaDescriptorResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaDescriptorResolver", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureInJavaMarkerProvider", "getDescriptorForMember"));
        }
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureInJavaMarkerProvider", "getDescriptorForMember"));
        }
        if (member instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)member;
            if (method.isConstructor()) {
                return ResolvePackage.resolveConstructor(javaDescriptorResolver, new JavaConstructorImpl(method));
            }
            return ResolvePackage.resolveMethod(javaDescriptorResolver, new JavaMethodImpl(method));
        }
        if (member instanceof PsiField) {
            return ResolvePackage.resolveField(javaDescriptorResolver, new JavaFieldImpl((PsiField)member));
        }
        return null;
    }

    public static boolean isMarkersEnabled(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureInJavaMarkerProvider", "isMarkersEnabled"));
        }
        return PropertiesComponent.getInstance((Project)project).getBoolean(SHOW_MARKERS_PROPERTY, true);
    }

    public static void setMarkersEnabled(@NotNull Project project, boolean value2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureInJavaMarkerProvider", "setMarkersEnabled"));
        }
        PropertiesComponent.getInstance((Project)project).setValue(SHOW_MARKERS_PROPERTY, Boolean.toString(value2));
        KotlinSignatureUtil.refreshMarkers(project);
    }

    private static class TooltipProvider
    implements Function<PsiElement, String> {
        @Nullable
        private final List<String> errors;

        private TooltipProvider(@Nullable List<String> errors) {
            this.errors = errors;
        }

        @Nullable
        public String fun(PsiElement element) {
            PsiAnnotation annotation2 = KotlinSignatureUtil.findKotlinSignatureAnnotation(element);
            if (annotation2 == null) {
                return this.errorsString();
            }
            String signature = KotlinSignatureUtil.getKotlinSignature(annotation2);
            String text = "Alternative Kotlin signature is available for this method:\n" + StringUtil.escapeXml((String)signature);
            if (this.errors == null) {
                return text;
            }
            return text + "\nIt has the following " + StringUtil.pluralize((String)"error", (int)this.errors.size()) + ":\n" + this.errorsString();
        }

        @NotNull
        private String errorsString() {
            assert (this.errors != null);
            String string = StringUtil.escapeXml((String)StringUtil.join(this.errors, (String)"\n"));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureInJavaMarkerProvider$TooltipProvider", "errorsString"));
            }
            return string;
        }
    }

    private static class MyLineMarkerInfo
    extends LineMarkerInfo<PsiModifierListOwner> {
        public MyLineMarkerInfo(PsiModifierListOwner element, @Nullable List<String> errors, boolean hasAnnotation) {
            super((PsiElement)element, element.getTextOffset(), errors != null ? AllIcons.Ide.Error : JetIcons.SMALL_LOGO, 6, (Function)new TooltipProvider(errors), (GutterIconNavigationHandler)(hasAnnotation ? NAVIGATION_HANDLER : null));
        }

        @Nullable
        public GutterIconRenderer createGutterRenderer() {
            return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiModifierListOwner>((LineMarkerInfo)this){

                @Nullable
                public ActionGroup getPopupMenuActions() {
                    if (MyLineMarkerInfo.this.getNavigationHandler() == null) {
                        return null;
                    }
                    PsiModifierListOwner element = (PsiModifierListOwner)MyLineMarkerInfo.this.getElement();
                    assert (element != null);
                    return new DefaultActionGroup(new AnAction[]{new EditSignatureAction(element), new DeleteSignatureAction(element)});
                }
            };
        }
    }
}

