/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.liveTemplates.macro;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.core.IterableTypesDetector;
import org.jetbrains.kotlin.idea.liveTemplates.macro.JetPsiElementResult;
import org.jetbrains.kotlin.idea.util.UtilPackage;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilPackage;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.JetScope;

public abstract class BaseJetVariableMacro
extends Macro {
    @Nullable
    private JetNamedDeclaration[] getVariables(Expression[] params2, ExpressionContext context2) {
        if (params2.length != 0) {
            return null;
        }
        Project project = context2.getProject();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(context2.getEditor().getDocument());
        if (!(psiFile instanceof JetFile)) {
            return null;
        }
        JetExpression contextExpression = BaseJetVariableMacro.findContextExpression(psiFile, context2.getStartOffset());
        if (contextExpression == null) {
            return null;
        }
        AnalysisResult analysisResult = ResolvePackage.analyzeAndGetResult(contextExpression);
        BindingContext bindingContext2 = analysisResult.getBindingContext();
        JetScope scope2 = bindingContext2.get(BindingContext.RESOLUTION_SCOPE, contextExpression);
        if (scope2 == null) {
            return null;
        }
        IterableTypesDetector iterableTypesDetector = new IterableTypesDetector(project, analysisResult.getModuleDescriptor(), scope2, null);
        DataFlowInfo dataFlowInfo = BindingContextUtilPackage.getDataFlowInfo(bindingContext2, contextExpression);
        ArrayList<VariableDescriptor> filteredDescriptors = new ArrayList<VariableDescriptor>();
        for (DeclarationDescriptor declarationDescriptor : scope2.getDescriptors(DescriptorKindFilter.VARIABLES, JetScope.ALL_NAME_FILTER)) {
            VariableDescriptor variableDescriptor;
            if (!(declarationDescriptor instanceof VariableDescriptor) || (variableDescriptor = (VariableDescriptor)declarationDescriptor).getExtensionReceiverParameter() != null && UtilPackage.substituteExtensionIfCallableWithImplicitReceiver(variableDescriptor, scope2, bindingContext2, dataFlowInfo).isEmpty() || !this.isSuitable(variableDescriptor, project, iterableTypesDetector)) continue;
            filteredDescriptors.add(variableDescriptor);
        }
        ArrayList<JetNamedDeclaration> declarations2 = new ArrayList<JetNamedDeclaration>();
        for (VariableDescriptor declarationDescriptor : filteredDescriptors) {
            PsiElement declaration = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
            assert (declaration == null || declaration instanceof PsiNamedElement);
            if (!(declaration instanceof JetProperty) && !(declaration instanceof JetParameter)) continue;
            declarations2.add((JetNamedDeclaration)declaration);
        }
        return declarations2.toArray(new JetNamedDeclaration[declarations2.size()]);
    }

    protected abstract boolean isSuitable(@NotNull VariableDescriptor var1, @NotNull Project var2, @NotNull IterableTypesDetector var3);

    @Nullable
    private static JetExpression findContextExpression(PsiFile psiFile, int startOffset) {
        for (PsiElement e = psiFile.findElementAt(startOffset); e != null; e = e.getParent()) {
            if (!(e instanceof JetExpression)) continue;
            return (JetExpression)e;
        }
        return null;
    }

    public Result calculateResult(@NotNull Expression[] params2, ExpressionContext context2) {
        if (params2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "org/jetbrains/kotlin/idea/liveTemplates/macro/BaseJetVariableMacro", "calculateResult"));
        }
        JetNamedDeclaration[] vars = this.getVariables(params2, context2);
        if (vars == null || vars.length == 0) {
            return null;
        }
        return new JetPsiElementResult((PsiNamedElement)vars[0]);
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params2, ExpressionContext context2) {
        if (params2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "org/jetbrains/kotlin/idea/liveTemplates/macro/BaseJetVariableMacro", "calculateLookupItems"));
        }
        JetNamedDeclaration[] vars = this.getVariables(params2, context2);
        if (vars == null || vars.length < 2) {
            return null;
        }
        LinkedHashSet<LookupElementBuilder> set = new LinkedHashSet<LookupElementBuilder>();
        for (JetNamedDeclaration var : vars) {
            set.add(LookupElementBuilder.create((PsiNamedElement)var));
        }
        return set.toArray(new LookupElement[set.size()]);
    }
}

