/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.ChangeFunctionLiteralReturnTypeFix;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetMultiDeclaration;
import org.jetbrains.kotlin.psi.JetMultiDeclarationEntry;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.dataClassUtils.DataClassUtilsPackage;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

public class ChangeFunctionReturnTypeFix
extends JetIntentionAction<JetFunction> {
    private final JetType type;
    private final ChangeFunctionLiteralReturnTypeFix changeFunctionLiteralReturnTypeFix;

    public ChangeFunctionReturnTypeFix(@NotNull JetFunction element, @NotNull JetType type2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix", "<init>"));
        }
        super(element);
        this.type = type2;
        if (element instanceof JetFunctionLiteral) {
            JetFunctionLiteralExpression functionLiteralExpression = (JetFunctionLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JetFunctionLiteralExpression.class);
            assert (functionLiteralExpression != null) : "FunctionLiteral outside any FunctionLiteralExpression: " + PsiUtilPackage.getElementTextWithContext(element);
            this.changeFunctionLiteralReturnTypeFix = new ChangeFunctionLiteralReturnTypeFix(functionLiteralExpression, type2);
        } else {
            this.changeFunctionLiteralReturnTypeFix = null;
        }
    }

    @NotNull
    public String getText() {
        if (this.changeFunctionLiteralReturnTypeFix != null) {
            String string = this.changeFunctionLiteralReturnTypeFix.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix", "getText"));
            }
            return string;
        }
        String functionName = ((JetFunction)this.element).getName();
        FqName fqName2 = ((JetFunction)this.element).getFqName();
        if (fqName2 != null) {
            functionName = fqName2.asString();
        }
        if (KotlinBuiltIns.isUnit(this.type) && ((JetFunction)this.element).hasBlockBody()) {
            String string = functionName == null ? JetBundle.message("remove.no.name.function.return.type", new Object[0]) : JetBundle.message("remove.function.return.type", functionName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix", "getText"));
            }
            return string;
        }
        String renderedType = IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.renderType(this.type);
        String string = functionName == null ? JetBundle.message("change.no.name.function.return.type", renderedType) : JetBundle.message("change.function.return.type", functionName, renderedType);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("change.type.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix", "isAvailable"));
        }
        return super.isAvailable(project, editor, file) && !ErrorUtils.containsErrorType(this.type);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor, JetFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix", "invoke"));
        }
        if (this.changeFunctionLiteralReturnTypeFix != null) {
            this.changeFunctionLiteralReturnTypeFix.invoke(project, editor, file);
        } else if (!KotlinBuiltIns.isUnit(this.type) || !((JetFunction)this.element).hasBlockBody()) {
            JetTypeReference newTypeRef = PsiPackage.JetPsiFactory(project).createType(IdeDescriptorRenderers.SOURCE_CODE.renderType(this.type));
            newTypeRef = ((JetFunction)this.element).setTypeReference(newTypeRef);
            assert (newTypeRef != null);
            ShortenReferences.DEFAULT.process(newTypeRef);
        } else {
            ((JetFunction)this.element).setTypeReference(null);
        }
    }

    @NotNull
    public static JetMultiDeclarationEntry getMultiDeclarationEntryThatTypeMismatchComponentFunction(Diagnostic diagnostic) {
        Name componentName = (Name)((DiagnosticWithParameters3)Errors.COMPONENT_FUNCTION_RETURN_TYPE_MISMATCH.cast(diagnostic)).getA();
        int componentIndex = DataClassUtilsPackage.getComponentIndex(componentName);
        JetMultiDeclaration multiDeclaration = QuickFixUtil.getParentElementOfType(diagnostic, JetMultiDeclaration.class);
        assert (multiDeclaration != null) : "COMPONENT_FUNCTION_RETURN_TYPE_MISMATCH reported on expression that is not within any multi declaration";
        JetMultiDeclarationEntry jetMultiDeclarationEntry = multiDeclaration.getEntries().get(componentIndex - 1);
        if (jetMultiDeclarationEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix", "getMultiDeclarationEntryThatTypeMismatchComponentFunction"));
        }
        return jetMultiDeclarationEntry;
    }

    @NotNull
    public static JetSingleIntentionActionFactory createFactoryForComponentFunctionReturnTypeMismatch() {
        JetSingleIntentionActionFactory jetSingleIntentionActionFactory = new JetSingleIntentionActionFactory(){

            @Override
            @Nullable
            public IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix$1", "createAction"));
                }
                JetMultiDeclarationEntry entry = ChangeFunctionReturnTypeFix.getMultiDeclarationEntryThatTypeMismatchComponentFunction(diagnostic);
                BindingContext context2 = ResolvePackage.analyzeFully((JetFile)entry.getContainingFile().getContainingFile());
                ResolvedCall<FunctionDescriptor> resolvedCall = context2.get(BindingContext.COMPONENT_RESOLVED_CALL, entry);
                if (resolvedCall == null) {
                    return null;
                }
                JetFunction componentFunction = (JetFunction)DescriptorToSourceUtils.descriptorToDeclaration(resolvedCall.getCandidateDescriptor());
                JetType expectedType = context2.get(BindingContext.TYPE, entry.getTypeReference());
                if (componentFunction != null && expectedType != null) {
                    return new ChangeFunctionReturnTypeFix(componentFunction, expectedType);
                }
                return null;
            }
        };
        if (jetSingleIntentionActionFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix", "createFactoryForComponentFunctionReturnTypeMismatch"));
        }
        return jetSingleIntentionActionFactory;
    }

    @NotNull
    public static JetSingleIntentionActionFactory createFactoryForHasNextFunctionTypeMismatch() {
        JetSingleIntentionActionFactory jetSingleIntentionActionFactory = new JetSingleIntentionActionFactory(){

            @Override
            @Nullable
            public IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix$2", "createAction"));
                }
                JetExpression expression2 = QuickFixUtil.getParentElementOfType(diagnostic, JetExpression.class);
                assert (expression2 != null) : "HAS_NEXT_FUNCTION_TYPE_MISMATCH reported on element that is not within any expression";
                BindingContext context2 = ResolvePackage.analyzeFully(expression2.getContainingJetFile());
                ResolvedCall<FunctionDescriptor> resolvedCall = context2.get(BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL, expression2);
                if (resolvedCall == null) {
                    return null;
                }
                JetFunction hasNextFunction = (JetFunction)DescriptorToSourceUtils.descriptorToDeclaration(resolvedCall.getCandidateDescriptor());
                if (hasNextFunction != null) {
                    return new ChangeFunctionReturnTypeFix(hasNextFunction, KotlinBuiltIns.getInstance().getBooleanType());
                }
                return null;
            }
        };
        if (jetSingleIntentionActionFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix", "createFactoryForHasNextFunctionTypeMismatch"));
        }
        return jetSingleIntentionActionFactory;
    }

    @NotNull
    public static JetSingleIntentionActionFactory createFactoryForCompareToTypeMismatch() {
        JetSingleIntentionActionFactory jetSingleIntentionActionFactory = new JetSingleIntentionActionFactory(){

            @Override
            @Nullable
            public IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix$3", "createAction"));
                }
                JetBinaryExpression expression2 = QuickFixUtil.getParentElementOfType(diagnostic, JetBinaryExpression.class);
                assert (expression2 != null) : "COMPARE_TO_TYPE_MISMATCH reported on element that is not within any expression";
                BindingContext context2 = ResolvePackage.analyzeFully(expression2.getContainingJetFile());
                ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(expression2, context2);
                if (resolvedCall == null) {
                    return null;
                }
                PsiElement compareTo = DescriptorToSourceUtils.descriptorToDeclaration(resolvedCall.getCandidateDescriptor());
                if (!(compareTo instanceof JetFunction)) {
                    return null;
                }
                return new ChangeFunctionReturnTypeFix((JetFunction)compareTo, KotlinBuiltIns.getInstance().getIntType());
            }
        };
        if (jetSingleIntentionActionFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix", "createFactoryForCompareToTypeMismatch"));
        }
        return jetSingleIntentionActionFactory;
    }

    @NotNull
    public static JetIntentionActionsFactory createFactoryForReturnTypeMismatchOnOverride() {
        JetIntentionActionsFactory jetIntentionActionsFactory = new JetIntentionActionsFactory(){

            @Override
            @NotNull
            protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix$4", "doCreateActions"));
                }
                LinkedList<IntentionAction> actions = new LinkedList<IntentionAction>();
                JetFunction function2 = QuickFixUtil.getParentElementOfType(diagnostic, JetFunction.class);
                if (function2 != null) {
                    PsiElement overriddenFunction;
                    SimpleFunctionDescriptor descriptor2;
                    BindingContext context2 = ResolvePackage.analyzeFully(function2);
                    JetType matchingReturnType = QuickFixUtil.findLowerBoundOfOverriddenCallablesReturnTypes(context2, function2);
                    if (matchingReturnType != null) {
                        actions.add(new ChangeFunctionReturnTypeFix(function2, matchingReturnType));
                    }
                    if ((descriptor2 = context2.get(BindingContext.FUNCTION, function2)) == null) {
                        LinkedList<IntentionAction> linkedList = actions;
                        if (linkedList == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix$4", "doCreateActions"));
                        }
                        return linkedList;
                    }
                    JetType functionType = descriptor2.getReturnType();
                    if (functionType == null) {
                        LinkedList<IntentionAction> linkedList = actions;
                        if (linkedList == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix$4", "doCreateActions"));
                        }
                        return linkedList;
                    }
                    LinkedList<FunctionDescriptor> overriddenMismatchingFunctions = new LinkedList<FunctionDescriptor>();
                    for (FunctionDescriptor functionDescriptor : descriptor2.getOverriddenDescriptors()) {
                        JetType overriddenFunctionType = functionDescriptor.getReturnType();
                        if (overriddenFunctionType == null || JetTypeChecker.DEFAULT.isSubtypeOf(functionType, overriddenFunctionType)) continue;
                        overriddenMismatchingFunctions.add(functionDescriptor);
                    }
                    if (overriddenMismatchingFunctions.size() == 1 && (overriddenFunction = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)overriddenMismatchingFunctions.get(0))) instanceof JetFunction) {
                        actions.add(new ChangeFunctionReturnTypeFix((JetFunction)overriddenFunction, functionType));
                    }
                }
                LinkedList<IntentionAction> linkedList = actions;
                if (linkedList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix$4", "doCreateActions"));
                }
                return linkedList;
            }
        };
        if (jetIntentionActionsFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix", "createFactoryForReturnTypeMismatchOnOverride"));
        }
        return jetIntentionActionsFactory;
    }

    @NotNull
    public static JetSingleIntentionActionFactory createFactoryForChangingReturnTypeToUnit() {
        JetSingleIntentionActionFactory jetSingleIntentionActionFactory = new JetSingleIntentionActionFactory(){

            @Override
            @Nullable
            public IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix$5", "createAction"));
                }
                JetFunction function2 = QuickFixUtil.getParentElementOfType(diagnostic, JetFunction.class);
                return function2 == null ? null : new ChangeFunctionReturnTypeFix(function2, KotlinBuiltIns.getInstance().getUnitType());
            }
        };
        if (jetSingleIntentionActionFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionReturnTypeFix", "createFactoryForChangingReturnTypeToUnit"));
        }
        return jetSingleIntentionActionFactory;
    }
}

