/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.changeSignature;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.changeSignature.ChangeSignatureUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.AsJavaPackage;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringBundle;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ChangeSignaturePackage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetChangeSignatureConfiguration;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetMethodDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.psi.JetCallElement;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.JetConstructorDelegationCall;
import org.jetbrains.kotlin.psi.JetConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.JetDelegatorToSuperCall;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetParameterList;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetTypeParameterList;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.tasks.TasksPackage;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

public class JetChangeSignatureHandler
implements ChangeSignatureHandler {
    @Nullable
    public static PsiElement findTargetForRefactoring(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureHandler", "findTargetForRefactoring"));
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, JetParameterList.class) != null) {
            return PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JetFunction.class, JetClass.class});
        }
        JetTypeParameterList typeParameterList = (JetTypeParameterList)PsiTreeUtil.getParentOfType((PsiElement)element, JetTypeParameterList.class);
        if (typeParameterList != null) {
            return PsiTreeUtil.getParentOfType((PsiElement)typeParameterList, (Class[])new Class[]{JetFunction.class, JetClass.class});
        }
        PsiElement elementParent = element.getParent();
        if (elementParent instanceof JetNamedFunction && ((JetNamedFunction)elementParent).getNameIdentifier() == element) {
            return elementParent;
        }
        if (elementParent instanceof JetClass && ((JetClass)elementParent).getNameIdentifier() == element) {
            return elementParent;
        }
        if (elementParent instanceof JetSecondaryConstructor && ((JetSecondaryConstructor)elementParent).getConstructorKeyword() == element) {
            return elementParent;
        }
        JetCallElement call = (JetCallElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JetCallExpression.class, JetDelegatorToSuperCall.class, JetConstructorDelegationCall.class});
        if (call == null) {
            return null;
        }
        JetExpression receiverExpr = call.getCalleeExpression();
        if (receiverExpr instanceof JetConstructorCalleeExpression) {
            receiverExpr = ((JetConstructorCalleeExpression)receiverExpr).getConstructorReferenceExpression();
        }
        if (receiverExpr instanceof JetSimpleNameExpression || receiverExpr instanceof JetConstructorDelegationReferenceExpression) {
            JetElement jetElement = (JetElement)PsiTreeUtil.getParentOfType((PsiElement)element, JetElement.class);
            if (jetElement == null) {
                return null;
            }
            BindingContext bindingContext2 = ResolvePackage.analyze(jetElement, BodyResolveMode.FULL);
            DeclarationDescriptor descriptor2 = bindingContext2.get(BindingContext.REFERENCE_TARGET, (JetReferenceExpression)receiverExpr);
            if (descriptor2 instanceof ClassDescriptor || descriptor2 instanceof FunctionDescriptor) {
                return receiverExpr;
            }
        }
        return null;
    }

    public static void invokeChangeSignature(@NotNull JetElement element, @NotNull PsiElement context2, @NotNull Project project, @Nullable Editor editor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureHandler", "invokeChangeSignature"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureHandler", "invokeChangeSignature"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureHandler", "invokeChangeSignature"));
        }
        BindingContext bindingContext2 = ResolvePackage.analyze(element, BodyResolveMode.FULL);
        FunctionDescriptor functionDescriptor = JetChangeSignatureHandler.findDescriptor((PsiElement)element, project, editor, bindingContext2);
        if (functionDescriptor == null) {
            return;
        }
        if (functionDescriptor instanceof JavaCallableMemberDescriptor) {
            PsiElement declaration = DescriptorToSourceUtilsIde.INSTANCE$.getAnyDeclaration(project, functionDescriptor);
            assert (declaration instanceof PsiMethod) : "PsiMethod expected: " + functionDescriptor;
            ChangeSignatureUtil.invokeChangeSignatureOn((PsiMethod)((PsiMethod)declaration), (Project)project);
            return;
        }
        if (TasksPackage.isDynamic(functionDescriptor)) {
            if (editor != null) {
                CodeInsightUtils.showErrorHint(project, editor, "Change signature is not applicable to dynamically invoked functions", "Change Signature", null);
            }
            return;
        }
        ChangeSignaturePackage.runChangeSignature(project, functionDescriptor, JetChangeSignatureHandler.emptyConfiguration(), bindingContext2, context2, null);
    }

    public static JetChangeSignatureConfiguration getConfiguration() {
        return JetChangeSignatureHandler.emptyConfiguration();
    }

    private static JetChangeSignatureConfiguration emptyConfiguration() {
        return new JetChangeSignatureConfiguration(){

            @Override
            @NotNull
            public JetMethodDescriptor configure(@NotNull JetMethodDescriptor originalDescriptor, @NotNull BindingContext bindingContext2) {
                if (originalDescriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalDescriptor", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureHandler$1", "configure"));
                }
                if (bindingContext2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureHandler$1", "configure"));
                }
                JetMethodDescriptor jetMethodDescriptor = originalDescriptor;
                if (jetMethodDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureHandler$1", "configure"));
                }
                return jetMethodDescriptor;
            }

            @Override
            public boolean performSilently(@NotNull Collection<? extends PsiElement> elements) {
                if (elements == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureHandler$1", "performSilently"));
                }
                return false;
            }

            @Override
            public boolean forcePerformForSelectedFunctionOnly() {
                return false;
            }
        };
    }

    @Nullable
    public PsiElement findTargetMember(PsiFile file, Editor editor) {
        return this.findTargetMember(file.findElementAt(editor.getCaretModel().getOffset()));
    }

    @Nullable
    public PsiElement findTargetMember(PsiElement element) {
        return JetChangeSignatureHandler.findTargetForRefactoring(element);
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureHandler", "invoke"));
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = this.findTargetMember(file, editor);
        if (element == null) {
            element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        }
        PsiElement elementAtCaret = file.findElementAt(editor.getCaretModel().getOffset());
        if (element != null && elementAtCaret != null) {
            assert (element instanceof JetElement) : "This handler must be invoked for elements of JetLanguage : " + element.getText();
            JetChangeSignatureHandler.invokeChangeSignature((JetElement)element, elementAtCaret, project, editor);
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @Nullable DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureHandler", "invoke"));
        }
        if (elements.length != 1) {
            return;
        }
        Editor editor = dataContext != null ? (Editor)CommonDataKeys.EDITOR.getData(dataContext) : null;
        PsiElement element = AsJavaPackage.getUnwrapped(elements[0]);
        assert (element instanceof JetElement) : "This handler must be invoked for elements of JetLanguage : " + element.getText();
        JetChangeSignatureHandler.invokeChangeSignature((JetElement)element, element, project, editor);
    }

    @Nullable
    public String getTargetNotFoundMessage() {
        return JetRefactoringBundle.message("error.wrong.caret.position.function.or.constructor.name", new Object[0]);
    }

    @Nullable
    public static FunctionDescriptor findDescriptor(@NotNull PsiElement element, @NotNull Project project, @Nullable Editor editor, BindingContext bindingContext2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureHandler", "findDescriptor"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureHandler", "findDescriptor"));
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)element)) {
            return null;
        }
        DeclarationDescriptor descriptor2 = element instanceof JetReferenceExpression ? bindingContext2.get(BindingContext.REFERENCE_TARGET, (JetReferenceExpression)element) : bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
        if (descriptor2 instanceof ClassDescriptor) {
            descriptor2 = ((ClassDescriptor)descriptor2).getUnsubstitutedPrimaryConstructor();
        }
        if (descriptor2 instanceof FunctionDescriptor) {
            for (ValueParameterDescriptor parameter : ((FunctionDescriptor)descriptor2).getValueParameters()) {
                if (parameter.getVarargElementType() == null) continue;
                String message = JetRefactoringBundle.message("error.cant.refactor.vararg.functions", new Object[0]);
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.changeSignature");
                return null;
            }
            if (((FunctionDescriptor)descriptor2).getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED) {
                String message = JetRefactoringBundle.message("cannot.refactor.synthesized.function", descriptor2.getName());
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.changeSignature");
                return null;
            }
            return (FunctionDescriptor)descriptor2;
        }
        String message = RefactoringBundle.getCannotRefactorMessage((String)JetRefactoringBundle.message("error.wrong.caret.position.function.or.constructor.name", new Object[0]));
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.changeSignature");
        return null;
    }
}

