/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.RuntimeConfigurationProducer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.idea.project.ProjectStructureUtil;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetNamedFunction;

public class JetJUnitConfigurationProducer
extends RuntimeConfigurationProducer {
    private JetElement myElement;

    public JetJUnitConfigurationProducer() {
        super((ConfigurationType)JUnitConfigurationType.getInstance());
    }

    public PsiElement getSourceElement() {
        return this.myElement;
    }

    protected RunnerAndConfigurationSettings createConfigurationByElement(Location location, ConfigurationContext context2) {
        JetClass jetClass;
        PsiClass delegate2;
        if (DumbService.getInstance((Project)location.getProject()).isDumb()) {
            return null;
        }
        PsiElement leaf = location.getPsiElement();
        if (!ProjectRootsUtil.isInProjectOrLibSource(leaf)) {
            return null;
        }
        if (!(leaf.getContainingFile() instanceof JetFile)) {
            return null;
        }
        JetFile jetFile = (JetFile)leaf.getContainingFile();
        if (ProjectStructureUtil.isJsKotlinModule(jetFile)) {
            return null;
        }
        JetNamedFunction function2 = (JetNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)leaf, JetNamedFunction.class, (boolean)false);
        if (function2 != null) {
            this.myElement = function2;
            JetElement owner = (JetElement)PsiTreeUtil.getParentOfType((PsiElement)function2, (Class[])new Class[]{JetFunction.class, JetClass.class});
            if (owner instanceof JetClass && (delegate2 = LightClassUtil.getPsiClass((JetClass)owner)) != null) {
                for (PsiMethod method : delegate2.getMethods()) {
                    if (method.getNavigationElement() != function2) continue;
                    Location methodLocation = PsiLocation.fromPsiElement((PsiElement)method);
                    if (!JUnitUtil.isTestMethod((Location)methodLocation, (boolean)false)) break;
                    RunnerAndConfigurationSettings settings = this.cloneTemplateConfiguration(context2.getProject(), context2);
                    JUnitConfiguration configuration = (JUnitConfiguration)settings.getConfiguration();
                    Module originalModule = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
                    configuration.beMethodConfiguration(methodLocation);
                    configuration.restoreOriginalModule(originalModule);
                    JavaRunConfigurationExtensionManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration, location);
                    return settings;
                }
            }
        }
        if ((jetClass = (JetClass)PsiTreeUtil.getParentOfType((PsiElement)leaf, JetClass.class, (boolean)false)) == null) {
            jetClass = JetJUnitConfigurationProducer.getClassDeclarationInFile(jetFile);
        }
        if (jetClass != null) {
            this.myElement = jetClass;
            delegate2 = LightClassUtil.getPsiClass(jetClass);
            if (delegate2 != null && JUnitUtil.isTestClass((PsiClass)delegate2)) {
                RunnerAndConfigurationSettings settings = this.cloneTemplateConfiguration(context2.getProject(), context2);
                JUnitConfiguration configuration = (JUnitConfiguration)settings.getConfiguration();
                Module originalModule = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
                configuration.beClassConfiguration(delegate2);
                configuration.restoreOriginalModule(originalModule);
                JavaRunConfigurationExtensionManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration, location);
                return settings;
            }
        }
        return null;
    }

    @Nullable
    static JetClass getClassDeclarationInFile(JetFile jetFile) {
        JetClass tempSingleDeclaration = null;
        for (JetDeclaration jetDeclaration : jetFile.getDeclarations()) {
            if (!(jetDeclaration instanceof JetClass)) continue;
            JetClass declaration = (JetClass)jetDeclaration;
            if (tempSingleDeclaration == null) {
                tempSingleDeclaration = declaration;
                continue;
            }
            return null;
        }
        return tempSingleDeclaration;
    }

    public int compareTo(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "org/jetbrains/kotlin/idea/run/JetJUnitConfigurationProducer", "compareTo"));
        }
        return 0;
    }
}

