/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

public final class PackageClassUtils {
    public static final String PACKAGE_CLASS_NAME_SUFFIX = "Package";
    private static final String DEFAULT_PACKAGE_CLASS_NAME = "_DefaultPackage";

    private PackageClassUtils() {
    }

    @NotNull
    public static String getPackageClassName(@NotNull FqName packageFQN) {
        if (packageFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFQN", "org/jetbrains/kotlin/load/kotlin/PackageClassUtils", "getPackageClassName"));
        }
        if (packageFQN.isRoot()) {
            if (DEFAULT_PACKAGE_CLASS_NAME == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/PackageClassUtils", "getPackageClassName"));
            }
            return DEFAULT_PACKAGE_CLASS_NAME;
        }
        String string = PackageClassUtils.capitalizeNonEmptyString(packageFQN.shortName().asString()) + PACKAGE_CLASS_NAME_SUFFIX;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/PackageClassUtils", "getPackageClassName"));
        }
        return string;
    }

    @NotNull
    private static String capitalizeNonEmptyString(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/jetbrains/kotlin/load/kotlin/PackageClassUtils", "capitalizeNonEmptyString"));
        }
        String string = Character.isUpperCase(s.charAt(0)) ? s : Character.toUpperCase(s.charAt(0)) + s.substring(1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/PackageClassUtils", "capitalizeNonEmptyString"));
        }
        return string;
    }

    @NotNull
    public static FqName getPackageClassFqName(@NotNull FqName packageFQN) {
        if (packageFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFQN", "org/jetbrains/kotlin/load/kotlin/PackageClassUtils", "getPackageClassFqName"));
        }
        FqName fqName2 = packageFQN.child(Name.identifier(PackageClassUtils.getPackageClassName(packageFQN)));
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/PackageClassUtils", "getPackageClassFqName"));
        }
        return fqName2;
    }

    @NotNull
    public static ClassId getPackageClassId(@NotNull FqName packageFQN) {
        if (packageFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFQN", "org/jetbrains/kotlin/load/kotlin/PackageClassUtils", "getPackageClassId"));
        }
        ClassId classId = new ClassId(packageFQN, Name.identifier(PackageClassUtils.getPackageClassName(packageFQN)));
        if (classId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/PackageClassUtils", "getPackageClassId"));
        }
        return classId;
    }

    @NotNull
    public static String getPackageClassInternalName(@NotNull FqName packageFQN) {
        if (packageFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFQN", "org/jetbrains/kotlin/load/kotlin/PackageClassUtils", "getPackageClassInternalName"));
        }
        String string = JvmClassName.byFqNameWithoutInnerClasses(PackageClassUtils.getPackageClassFqName(packageFQN)).getInternalName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/PackageClassUtils", "getPackageClassInternalName"));
        }
        return string;
    }

    public static boolean isPackageClassFqName(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/load/kotlin/PackageClassUtils", "isPackageClassFqName"));
        }
        return !fqName2.isRoot() && PackageClassUtils.getPackageClassFqName(fqName2.parent()).equals(fqName2);
    }
}

