/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilPackage;
import org.jetbrains.kotlin.types.JetType;

public class EnumValue
extends CompileTimeConstant<ClassDescriptor> {
    public EnumValue(@NotNull ClassDescriptor value2, boolean usesVariableAsConstant) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/resolve/constants/EnumValue", "<init>"));
        }
        super(value2, true, false, usesVariableAsConstant);
    }

    @Override
    @NotNull
    public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
        if (kotlinBuiltIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinBuiltIns", "org/jetbrains/kotlin/resolve/constants/EnumValue", "getType"));
        }
        JetType jetType = this.getType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/constants/EnumValue", "getType"));
        }
        return jetType;
    }

    @NotNull
    private JetType getType() {
        JetType type2 = DescriptorUtilPackage.getClassObjectType((ClassDescriptor)this.value);
        assert (type2 != null) : "Enum entry must have a class object type: " + this.value;
        JetType jetType = type2;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/constants/EnumValue", "getType"));
        }
        return jetType;
    }

    @Override
    @NotNull
    public ClassDescriptor getValue() {
        ClassDescriptor value2 = (ClassDescriptor)super.getValue();
        assert (value2 != null) : "Guaranteed by constructor";
        ClassDescriptor classDescriptor = value2;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/constants/EnumValue", "getValue"));
        }
        return classDescriptor;
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor2, D data2) {
        return visitor2.visitEnumValue(this, data2);
    }

    public String toString() {
        return this.getType() + "." + ((ClassDescriptor)this.value).getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return ((ClassDescriptor)this.value).equals(((EnumValue)o).value);
    }

    public int hashCode() {
        return ((ClassDescriptor)this.value).hashCode();
    }
}

