/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.kotlinSignature;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.jvm.kotlinSignature.SignaturesPropagationData;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.JetTypeImpl;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

class PropagationHeuristics {
    static void checkArrayInReturnType(@NotNull SignaturesPropagationData data2, @NotNull JetType type2, @NotNull List<SignaturesPropagationData.TypeAndVariance> typesFromSuper) {
        if (data2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/PropagationHeuristics", "checkArrayInReturnType"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/PropagationHeuristics", "checkArrayInReturnType"));
        }
        if (typesFromSuper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typesFromSuper", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/PropagationHeuristics", "checkArrayInReturnType"));
        }
        List arrayTypesFromSuper = ContainerUtil.filter(typesFromSuper, (Condition)new Condition<SignaturesPropagationData.TypeAndVariance>(){

            public boolean value(SignaturesPropagationData.TypeAndVariance typeAndVariance) {
                return typeAndVariance.type.getConstructor().getDeclarationDescriptor() == KotlinBuiltIns.getInstance().getArray();
            }
        });
        if (KotlinBuiltIns.getInstance().getArray() == type2.getConstructor().getDeclarationDescriptor() && !arrayTypesFromSuper.isEmpty()) {
            assert (type2.getArguments().size() == 1);
            if (type2.getArguments().get(0).getProjectionKind() == Variance.INVARIANT) {
                for (SignaturesPropagationData.TypeAndVariance typeAndVariance : arrayTypesFromSuper) {
                    JetType arrayTypeFromSuper = typeAndVariance.type;
                    assert (arrayTypeFromSuper.getArguments().size() == 1);
                    JetType elementTypeInSuper = arrayTypeFromSuper.getArguments().get(0).getType();
                    JetType elementType = type2.getArguments().get(0).getType();
                    if (!JetTypeChecker.DEFAULT.isSubtypeOf(elementType, elementTypeInSuper) || JetTypeChecker.DEFAULT.equalTypes(elementType, elementTypeInSuper)) continue;
                    JetTypeImpl betterTypeInSuper = new JetTypeImpl(arrayTypeFromSuper.getAnnotations(), arrayTypeFromSuper.getConstructor(), arrayTypeFromSuper.isMarkedNullable(), Arrays.asList(new TypeProjectionImpl(Variance.OUT_VARIANCE, elementTypeInSuper)), JetScope.Empty.INSTANCE$);
                    data2.reportError("Return type is not a subtype of overridden method. To fix it, add annotation with Kotlin signature to super method with type " + DescriptorRenderer.SHORT_NAMES_IN_TYPES.renderType(arrayTypeFromSuper) + " replaced with " + DescriptorRenderer.SHORT_NAMES_IN_TYPES.renderType(betterTypeInSuper) + " in return type");
                }
            }
        }
    }

    @Nullable
    static ClassifierDescriptor tryToFixOverridingTWithRawType(@NotNull SignaturesPropagationData data2, @NotNull List<SignaturesPropagationData.TypeAndVariance> typesFromSuper) {
        if (data2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/PropagationHeuristics", "tryToFixOverridingTWithRawType"));
        }
        if (typesFromSuper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typesFromSuper", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/PropagationHeuristics", "tryToFixOverridingTWithRawType"));
        }
        ArrayList typeParameterClassifiersFromSuper = Lists.newArrayList();
        for (SignaturesPropagationData.TypeAndVariance typeFromSuper : typesFromSuper) {
            ClassifierDescriptor classifierFromSuper = typeFromSuper.type.getConstructor().getDeclarationDescriptor();
            if (!(classifierFromSuper instanceof TypeParameterDescriptor)) continue;
            typeParameterClassifiersFromSuper.add((TypeParameterDescriptor)classifierFromSuper);
        }
        if (!typeParameterClassifiersFromSuper.isEmpty() && typeParameterClassifiersFromSuper.size() == typesFromSuper.size()) {
            for (TypeParameterDescriptor typeParameter : typeParameterClassifiersFromSuper) {
                if (typeParameter.getContainingDeclaration() != data2.containingClass) continue;
                return typeParameter;
            }
        }
        return null;
    }

    private PropagationHeuristics() {
    }
}

