/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.AbstractScopeAdapter;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.RedeclarationHandler;
import org.jetbrains.kotlin.resolve.scopes.WritableScope;
import org.jetbrains.kotlin.utils.Printer;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"V\u000e)ArK]5uC\ndWmU2pa\u0016<\u0016\u000e\u001e5J[B|'\u000f^:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:TqA]3t_24XM\u0003\u0004tG>\u0004Xm\u001d\u0006\u0015\u0003\n\u001cHO]1diN\u001bw\u000e]3BI\u0006\u0004H/\u001a:\u000b\u001b]\u0013\u0018\u000e^1cY\u0016\u001c6m\u001c9f\u0015\u0019a\u0014N\\5u})Yqo\u001c:lKJ\u001c6m\u001c9f\u0015!QU\r^*d_B,'\u0002\u0006:fI\u0016\u001cG.\u0019:bi&|g\u000eS1oI2,'O\u0003\u000bSK\u0012,7\r\\1sCRLwN\u001c%b]\u0012dWM\u001d\u0006\nI\u0016\u0014Wo\u001a(b[\u0016Taa\u0015;sS:<'\u0002\u00026bm\u0006TA\u0001\\1oO*a2-\u001e:sK:$\u0018J\u001c3jm&$W/\u00197J[B|'\u000f^*d_B,'\"G5na2L7-\u001b;SK\u000e,\u0017N^3s\u0011&,'/\u0019:dQfTA\u0001T5ti*Y\"+Z2fSZ,'\u000fU1sC6,G/\u001a:EKN\u001c'/\u001b9u_JT1\u0002Z3tGJL\u0007\u000f^8sg*!Q\u000f^5m\u0015\u001dIW\u000e]8siNT1\"T;uC\ndW\rT5ti*IAn\\2l\u0019\u00164X\r\u001c\u0006\n\u0019>\u001c7\u000eT3wK2Tqc\u0016:ji\u0006\u0014G.Z*d_B,G\u0005T8dW2+g/\u001a7\u000b/\u001d,GOU3eK\u000ed\u0017M]1uS>t\u0007*\u00198eY\u0016\u0014(BD4fi^{'o[3s'\u000e|\u0007/\u001a\u0006\u0010G\"\fgnZ3M_\u000e\\G*\u001a<fY*a1\r[3dW6\u000b\u0017PU3bI*!QK\\5u\u00155\u0019\u0007.Z2l\u001b\u0006LxK]5uK*\t3m\\7qkR,\u0017*\u001c9mS\u000eLGOU3dK&4XM]:IS\u0016\u0014\u0018M]2is*iq-\u001a;DY\u0006\u001c8/\u001b4jKJTAA\\1nK*!a*Y7f\u0015Q\u0019E.Y:tS\u001aLWM\u001d#fg\u000e\u0014\u0018\u000e\u001d;pe*aq-\u001a;Gk:\u001cG/[8og*Q1i\u001c7mK\u000e$\u0018n\u001c8\u000b%\u0019+hn\u0019;j_:$Um]2sSB$xN\u001d\u0006\u001eO\u0016$\u0018*\u001c9mS\u000eLGOU3dK&4XM]:IS\u0016\u0014\u0018M]2is*Qq-\u001a;J[B|'\u000f^:\u000b!\u001d,G\u000fT8dC24\u0016M]5bE2,'B\u0005,be&\f'\r\\3EKN\u001c'/\u001b9u_JT!bZ3u!\u0006\u001c7.Y4f\u0015U\u0001\u0016mY6bO\u00164\u0016.Z<EKN\u001c'/\u001b9u_JTQbZ3u!J|\u0007/\u001a:uS\u0016\u001c(bA*fi*Y\u0011.\u001c9peR\u001c6m\u001c9f\u0015!IW\u000e]8si\u0016$'\"\b9sS:$\u0018\t\u001a3ji&|g.\u00197TG>\u0004Xm\u0015;sk\u000e$XO]3\u000b\u0003ATq\u0001\u0015:j]R,'OC\u0003vi&d7OC\nqe&tGoU2pa\u0016\u001cFO];diV\u0014XM\u0003\u0005u_N#(/\u001b8hQ\u000bQ!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!\u0002\u0002\u0005\u0004!\u0015Qa\u0001\u0003\u0003\u0011\u0001a\u0001!B\u0002\u0005\u0005!\u0019A\u0002A\u0003\u0004\t\tA9\u0001\u0004\u0001\u0006\u0007\u0011\u0011\u0001\"\u0002\u0007\u0001\u000b\r!!\u0001\u0003\u0004\r\u0001\u0015\t\u00012A\u0003\u0004\t\u0015Aq\u0001\u0004\u0001\u0006\u0005\u0011\u0011\u0001\"B\u0003\u0003\t\tAa!B\u0001\t\u0010\u0015\u0011Aa\u0002\u0005\t\u000b\t!y\u0001C\u0004\u0006\u0005\u0011\u0011\u0001rA\u0003\u0004\t\u0015A\u0019\u0002\u0004\u0001\u0006\u0005\u0011\t\u0001RC\u0003\u0004\t'A!\u0002\u0004\u0001\u0006\u0005\u00119\u0001bC\u0003\u0003\t+A\u0019\"B\u0002\u0005\u000b!aA\u0002A\u0003\u0004\t\u000fAQ\u0002\u0004\u0001\u0006\u0005\u0011\u0011\u00012D\u0003\u0004\t\u0015A\u0001\u0003\u0004\u0001\u0006\u0005\u0011\t\u0001BE\u0003\u0004\t7A)\u0003\u0004\u0001\u0006\u0007\u0011M\u0001b\u0005\u0007\u0001\u000b\t!\u0019\u0002C\n\u0006\u0005\u0011m\u0001RE\u0003\u0004\t\u0015AA\u0003\u0004\u0001\u0006\u0007\u0011M\u0001\u0012\u0006\u0007\u0001\u000b\t!)\u0002\u0003\u000b\u0006\u0007\u0011M\u0001R\u0006\u0007\u0001\u000b\t!\u0019\u0002#\f\u0006\u0007\u0011M\u0001r\u0006\u0007\u0001\u000b\t!\u0019\u0002c\f\u0006\u0007\u0011)\u0001\u0012\u0007\u0007\u0001\u000b\t!)\u0002#\r\u0006\u0005\u0011\t\u0001rG\u0003\u0004\tSA1\u0004\u0004\u0001\u0006\u0005\u0011%\u0002b\u0007\u0003\u0014\u0019\u000bI\"!B\u0001\t\u0007e\u0011Q!\u0001E\u0004[1!\u0011\u0019\u0004M\tC\r)\u0011\u0001c\u0002\r\u0002U\u001bA!B\u0002\u0005\u0012%\t\u0001\u0012C\u0017\f\t\u0005$\u0001TB\u0011\u0003\u000b\u0005AY!V\u0002\u0005\u000b\r!i!C\u0001\t\u00115\u0002B!1\u0007\u0019\u0013\u0005:Q!\u0001\u0005\n\u0013\rI!!B\u0001\t\u00151\u0005Qk\u0001\u0003\u0006\u0007\u0011I\u0011\"\u0001\u0005\f[A!\u0011\u0019\u0004M\fC\u001d)\u0011\u0001c\u0006\n\u0007%\u0011Q!\u0001\u0005\u0005\u0019\u0003)6\u0001B\u0003\u0004\t/I\u0011\u0001C\u0006.\u0017\u0011\tM\u0002'\u0007\"\u0005\u0015\t\u0001\u0002D+\u0004\t\u0015\u0019A\u0011D\u0005\u0002\u00113is\u0002\u00022\u00051\u0017\t#!B\u0001\t\nU\u001b\u0001\"B\u0002\u0005\f%\t\u0001RB\u0007\u0004\t9I\u0011\u0001#\u0004.\u001f\u0011QG\u0001'\u0003\"\u0005\u0015\t\u0001\u0002B+\u0004\u0011\u0015\u0019A\u0011B\u0005\u0002\u0011\u0019i1\u0001\"\b\n\u0003!1Qf\u0005\u0003\f1=ij\u0001\u0002\u0001\t\u001a5\u0011Q!\u0001\u0005\r!\u000e\u0001\u0011EA\u0003\u0002\u0011\u000f\t6!\u0002\u0003\u0010\u0013\u0005A\t\"D\u0001\t\u001a5NAA\u0001M\u0010C\t)\u0011\u0001C\u0007R\u0007\r!y\"C\u0001\u0005\u00015NAA\u0001M\u0011C\t)\u0011\u0001C\u0007R\u0007\r!\t#C\u0001\u0005\u00015nAA\u0003\r\u0012C\u0019)\u0011\u0001C\u0005\n\u0007%\u0011Q!\u0001\u0005\u000b#\u000e\u0019A!E\u0005\u0002\u0011-iC\u0003B\u0006\u0019$u5A\u0001\u0001\u0005\u0013\u001b\t)\u0011\u0001\u0003\bQ\u0007\u0001\t3!B\u0001\t\u001e1\u0005\u0011kA\u0003\u0005$%\t\u0001bD\u0007\u0002\u0011?is\u0003B\u0006\u0019(u5A\u0001\u0001\u0005\u0013\u001b\t)\u0011\u0001\u0003\bQ\u0007\u0001\tc!B\u0001\t!%\u0019\u0011BA\u0003\u0002\u0011C\t6!\u0002C\u0014\u0013\u0005A\u0011#D\u0001\t 5nAa\u0003\r\u0016C\u0019)\u0011\u0001C\u0005\n\u0007%\u0011Q!\u0001\u0005\u000b#\u000e\u0019A!F\u0005\u0002\u0011-i[\u0002\u0002\u0002\u0019,\u00052Q!\u0001E\f\u0013\rI!!B\u0001\t\tE\u001b1\u0001b\u000b\n\u0003!YQ\u0006\u0006\u0003\f1Yij\u0001\u0002\u0001\t%5\u0011Q!\u0001\u0005\u000f!\u000e\u0001\u0011eA\u0003\u0002\u0011Ga\t!U\u0002\u0006\tYI\u0011\u0001\u0003\n\u000e\u0003!}Q\u0006\u0006\u0003\f1]ij\u0001\u0002\u0001\t%5\u0011Q!\u0001\u0005\u000f!\u000e\u0001\u0011eA\u0003\u0002\u0011Ka\t!U\u0002\u0006\t]I\u0011\u0001C\n\u000e\u0003!}Qf\u0006\u0003\f1aij\u0001\u0002\u0001\t%5\u0011Q!\u0001\u0005\u000f!\u000e\u0001\u0011EB\u0003\u0002\u0011OI1!\u0003\u0002\u0006\u0003!\r\u0012kA\u0003\u00051%\t\u0001\u0002F\u0007\u0002\u0011?i3\u0003B\u0006\u00193u5A\u0001\u0001E\u001a\u001b\t)\u0011\u0001\u0003\u0003Q\u0007\u0001\t#!B\u0001\t\u001bE\u001bQ\u0001B\r\n\u0003\u0011\u0001Q\"\u0001\u0005\u0007[M!!\u0003\u0007\u000e\u001e\u000e\u0011\u0001\u0001RG\u0007\u0003\u000b\u0005AQ\u0003U\u0002\u0001C\t)\u0011\u0001C\u0007R\u0007\u0015!!$C\u0001\u0005\u00015\t\u00012F\u0017\u0014\t-AB$(\u0004\u0005\u0001!URBA\u0003\u0002\u0011U\u00016\u0001A\u0011\u0003\u000b\u0005AQ\"U\u0002\u0006\tqI\u0011\u0001\u0002\u0001\u000e\u0003!-R6\u0003\u0003\f1s\t#!B\u0001\t\fE\u001b1\u0001\"\u000f\n\u0003!AQwJC'\t\r\b\u0001\u0004BO\u0007\t\u0001AI!\u0004\u0002\u0006\u0003!!\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u00012B\u0007\u0003\u000b\u0005AI\u0001UB\u0001;\u001b!\u0001\u0001#\u0004\u000e\u0005\u0015\t\u00012\u0002)\u0004\u0003\u0005\u0012Q!\u0001E\u0003#\u000eIA\u0001B\u0005\u0002\t\u0001i\u0011\u0001\u0003\u0004\u000e\u0003!5Q\"\u0001\u0005\t"})
public abstract class WritableScopeWithImports
extends AbstractScopeAdapter
implements WritableScope {
    public static final /* synthetic */ KClass $kotlinClass;
    private List<JetScope> imports;
    private WritableScope currentIndividualImportScope;
    private List<? extends ReceiverParameterDescriptor> implicitReceiverHierarchy;
    private WritableScope.LockLevel lockLevel;
    @NotNull
    private final JetScope workerScope;
    @NotNull
    private final RedeclarationHandler redeclarationHandler;
    private final String debugName;

    static {
        $kotlinClass = Reflection.createKotlinClass(WritableScopeWithImports.class);
    }

    @Override
    @NotNull
    public WritableScope changeLockLevel(@JetValueParameter(name="lockLevel") @NotNull WritableScope.LockLevel lockLevel) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)lockLevel), (String)"lockLevel");
        if (lockLevel.ordinal() < this.lockLevel.ordinal()) {
            throw (Throwable)new IllegalStateException("cannot lower lock level from " + (Object)((Object)this.lockLevel) + " to " + (Object)((Object)lockLevel) + " at " + this.toString());
        }
        this.lockLevel = lockLevel;
        return this;
    }

    protected final void checkMayRead() {
        if (Intrinsics.areEqual((Object)((Object)this.lockLevel), (Object)((Object)WritableScope.LockLevel.READING)) ^ true && Intrinsics.areEqual((Object)((Object)this.lockLevel), (Object)((Object)WritableScope.LockLevel.BOTH)) ^ true) {
            throw (Throwable)new IllegalStateException("cannot read with lock level " + (Object)((Object)this.lockLevel) + " at " + this.toString());
        }
    }

    protected final void checkMayWrite() {
        if (Intrinsics.areEqual((Object)((Object)this.lockLevel), (Object)((Object)WritableScope.LockLevel.WRITING)) ^ true && Intrinsics.areEqual((Object)((Object)this.lockLevel), (Object)((Object)WritableScope.LockLevel.BOTH)) ^ true) {
            throw (Throwable)new IllegalStateException("cannot write with lock level " + (Object)((Object)this.lockLevel) + " at " + this.toString());
        }
    }

    @NotNull
    protected final List<JetScope> getImports() {
        if (this.imports == null) {
            this.imports = new ArrayList();
        }
        List<JetScope> list = this.imports;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        return list;
    }

    @Override
    public void importScope(@JetValueParameter(name="imported") @NotNull JetScope imported) {
        Intrinsics.checkParameterIsNotNull((Object)imported, (String)"imported");
        if (Intrinsics.areEqual((Object)imported, (Object)this)) {
            throw (Throwable)new IllegalStateException("cannot import scope into self");
        }
        this.checkMayWrite();
        this.getImports().add(0, imported);
        this.currentIndividualImportScope = null;
    }

    @Override
    @NotNull
    public List<ReceiverParameterDescriptor> getImplicitReceiversHierarchy() {
        this.checkMayRead();
        if (this.implicitReceiverHierarchy == null) {
            this.implicitReceiverHierarchy = this.computeImplicitReceiversHierarchy();
        }
        List<ReceiverParameterDescriptor> list = this.implicitReceiverHierarchy;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        return list;
    }

    @NotNull
    protected List<ReceiverParameterDescriptor> computeImplicitReceiversHierarchy() {
        ArrayList implicitReceiverHierarchy = Lists.newArrayList();
        for (JetScope scope2 : this.getImports()) {
            implicitReceiverHierarchy.addAll((Collection)scope2.getImplicitReceiversHierarchy());
        }
        implicitReceiverHierarchy.addAll((Collection)super.getImplicitReceiversHierarchy());
        List list = implicitReceiverHierarchy;
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"implicitReceiverHierarchy");
        return list;
    }

    @NotNull
    public Set<VariableDescriptor> getProperties(@JetValueParameter(name="name") @NotNull Name name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        this.checkMayRead();
        LinkedHashSet properties2 = Sets.newLinkedHashSet();
        for (JetScope imported : this.getImports()) {
            properties2.addAll(imported.getProperties(name2));
        }
        Set set = properties2;
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"properties");
        return set;
    }

    @Override
    @Nullable
    public VariableDescriptor getLocalVariable(@JetValueParameter(name="name") @NotNull Name name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        this.checkMayRead();
        for (JetScope imported : this.getImports()) {
            VariableDescriptor importedDescriptor = imported.getLocalVariable(name2);
            if (importedDescriptor == null) continue;
            return importedDescriptor;
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<FunctionDescriptor> getFunctions(@JetValueParameter(name="name") @NotNull Name name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        this.checkMayRead();
        if (this.getImports().isEmpty()) {
            return KotlinPackage.setOf();
        }
        LinkedHashSet result2 = Sets.newLinkedHashSet();
        for (JetScope imported : this.getImports()) {
            result2.addAll(imported.getFunctions(name2));
        }
        Collection collection = result2;
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"result");
        return collection;
    }

    @Override
    @Nullable
    public ClassifierDescriptor getClassifier(@JetValueParameter(name="name") @NotNull Name name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        this.checkMayRead();
        for (JetScope imported : this.getImports()) {
            ClassifierDescriptor importedClassifier = imported.getClassifier(name2);
            if (importedClassifier == null) continue;
            return importedClassifier;
        }
        return null;
    }

    @Override
    @Nullable
    public PackageViewDescriptor getPackage(@JetValueParameter(name="name") @NotNull Name name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        this.checkMayRead();
        for (JetScope imported : this.getImports()) {
            PackageViewDescriptor importedDescriptor = imported.getPackage(name2);
            if (importedDescriptor == null) continue;
            return importedDescriptor;
        }
        return null;
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + " " + this.debugName + " for " + this.getContainingDeclaration();
    }

    @Override
    public void printScopeStructure(@JetValueParameter(name="p") @NotNull Printer p) {
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        p.println(this.getClass().getSimpleName(), ": ", this.debugName, " for ", this.getContainingDeclaration(), " {");
        p.pushIndent();
        p.println(new Object[]{"lockLevel = ", this.lockLevel});
        this.printAdditionalScopeStructure(p);
        p.print("worker = ");
        JetScope jetScope = this.getWorkerScope();
        Printer printer = p.withholdIndentOnce();
        Intrinsics.checkExpressionValueIsNotNull((Object)printer, (String)"p.withholdIndentOnce()");
        jetScope.printScopeStructure(printer);
        if (this.getImports().isEmpty()) {
            p.println("imports = {}");
        } else {
            p.println("imports = {");
            p.pushIndent();
            for (JetScope anImport : this.getImports()) {
                anImport.printScopeStructure(p);
            }
            p.popIndent();
            p.println("}");
        }
        p.popIndent();
        p.println("}");
    }

    protected abstract void printAdditionalScopeStructure(@JetValueParameter(name="p") @NotNull Printer var1);

    @Override
    @NotNull
    protected JetScope getWorkerScope() {
        return this.workerScope;
    }

    @NotNull
    protected final RedeclarationHandler getRedeclarationHandler() {
        return this.redeclarationHandler;
    }

    public WritableScopeWithImports(@JetValueParameter(name="workerScope") @NotNull JetScope workerScope, @JetValueParameter(name="redeclarationHandler") @NotNull RedeclarationHandler redeclarationHandler, @JetValueParameter(name="debugName") @NotNull String debugName) {
        Intrinsics.checkParameterIsNotNull((Object)workerScope, (String)"workerScope");
        Intrinsics.checkParameterIsNotNull((Object)redeclarationHandler, (String)"redeclarationHandler");
        Intrinsics.checkParameterIsNotNull((Object)debugName, (String)"debugName");
        this.workerScope = workerScope;
        this.redeclarationHandler = redeclarationHandler;
        this.debugName = debugName;
        this.lockLevel = WritableScope.LockLevel.WRITING;
    }
}

