/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import com.intellij.openapi.diagnostic.Logger;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Stack;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.PrintingLogger;

public class Profiler {
    private static final ThreadLocal<Stack<Profiler>> PROFILERS = new ThreadLocal<Stack<Profiler>>(){

        @Override
        protected Stack<Profiler> initialValue() {
            return new Stack<Profiler>();
        }
    };
    private static final ReentrantLock OUT_LOCK = new ReentrantLock();
    private final String name;
    private final Logger log;
    private long start;
    private long cumulative;
    private boolean paused;
    private StackTraceElement[] stackTrace;
    private boolean mute;

    @NotNull
    public static Profiler create(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/utils/Profiler", "create"));
        }
        Profiler profiler = Profiler.create(name2, System.out);
        if (profiler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/Profiler", "create"));
        }
        return profiler;
    }

    @NotNull
    public static Profiler create(@NotNull String name2, @NotNull PrintStream out) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/utils/Profiler", "create"));
        }
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/kotlin/utils/Profiler", "create"));
        }
        Profiler profiler = Profiler.create(name2, new PrintingLogger(out));
        if (profiler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/Profiler", "create"));
        }
        return profiler;
    }

    @NotNull
    public static Profiler create(@NotNull String name2, @NotNull Logger log) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/utils/Profiler", "create"));
        }
        if (log == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "log", "org/jetbrains/kotlin/utils/Profiler", "create"));
        }
        Profiler profiler = new Profiler(name2, log);
        PROFILERS.get().push(profiler);
        Profiler profiler2 = profiler;
        if (profiler2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/Profiler", "create"));
        }
        return profiler2;
    }

    public static Profiler getFromContext() {
        Stack<Profiler> profilers = PROFILERS.get();
        if (profilers.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        return profilers.peek();
    }

    private Profiler(@NotNull String name2, @NotNull Logger log) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/utils/Profiler", "<init>"));
        }
        if (log == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "log", "org/jetbrains/kotlin/utils/Profiler", "<init>"));
        }
        this.start = Long.MAX_VALUE;
        this.cumulative = 0L;
        this.paused = true;
        this.name = name2;
        this.log = log;
    }

    public Profiler recordStackTrace(int depth2) {
        return this.recordStackTrace(1, depth2);
    }

    public Profiler recordStackTrace(int skip2, int depth2) {
        int from = 1 + skip2;
        StackTraceElement[] trace = new Throwable().getStackTrace();
        if (from >= trace.length) {
            return this;
        }
        int to = depth2 == -1 ? trace.length : Math.min(skip2 + depth2 + 1, trace.length);
        this.stackTrace = Arrays.copyOfRange(trace, from, to);
        return this;
    }

    public Profiler resetStackTrace() {
        this.stackTrace = null;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profiler printStackTrace() {
        if (this.stackTrace != null && this.log.isDebugEnabled()) {
            OUT_LOCK.lock();
            try {
                for (StackTraceElement element : this.stackTrace) {
                    this.println("\tat ", element);
                }
            }
            finally {
                OUT_LOCK.unlock();
            }
        }
        return this;
    }

    public Profiler printEntering() {
        this.println("Entering ", this.name);
        return this;
    }

    public Profiler start() {
        if (this.paused) {
            this.start = System.nanoTime();
            this.paused = false;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profiler end() {
        long result2 = this.cumulative;
        if (!this.paused) {
            result2 += System.nanoTime() - this.start;
        }
        this.paused = true;
        this.cumulative = 0L;
        if (this.log.isDebugEnabled()) {
            OUT_LOCK.lock();
            try {
                this.println(this.name, " took ", Profiler.format(result2));
                this.printStackTrace();
            }
            finally {
                OUT_LOCK.unlock();
            }
        }
        return this;
    }

    public Profiler pause() {
        if (!this.paused) {
            this.cumulative += System.nanoTime() - this.start;
            this.paused = true;
        }
        return this;
    }

    public Profiler mute() {
        this.mute = true;
        return this;
    }

    public Profiler unmute() {
        this.mute = false;
        return this;
    }

    public Profiler println(Object message) {
        if (!this.mute && this.log.isDebugEnabled()) {
            this.log.debug(String.valueOf(message));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profiler println(Object a, Object b) {
        if (!this.mute && this.log.isDebugEnabled()) {
            OUT_LOCK.lock();
            try {
                this.log.debug(String.valueOf(a) + b);
            }
            finally {
                OUT_LOCK.unlock();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profiler println(Object a, Object b, Object c) {
        if (!this.mute && this.log.isDebugEnabled()) {
            OUT_LOCK.lock();
            try {
                this.log.debug(String.valueOf(a) + b + c);
            }
            finally {
                OUT_LOCK.unlock();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profiler println(Object a, Object b, Object c, Object ... rest) {
        if (!this.mute && this.log.isDebugEnabled()) {
            OUT_LOCK.lock();
            try {
                StringBuilder sb = new StringBuilder();
                sb.append(a);
                sb.append(b);
                sb.append(c);
                for (Object o : rest) {
                    sb.append(o);
                }
                this.log.debug(sb.toString());
            }
            finally {
                OUT_LOCK.unlock();
            }
        }
        return this;
    }

    private static String format(long delta) {
        return String.format("%.3fs", (double)delta / 1.0E9);
    }
}

