/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.tasks;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.keymap.KeymapExtension;
import com.intellij.openapi.keymap.KeymapGroup;
import com.intellij.openapi.keymap.KeymapGroupFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import icons.MavenIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.model.MavenConstants;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.tasks.MavenShortcutsManager;
import org.jetbrains.idea.maven.tasks.TasksBundle;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;
import org.jetbrains.idea.maven.utils.MavenPluginInfo;
import org.jetbrains.idea.maven.utils.actions.MavenAction;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

public class MavenKeymapExtension
implements KeymapExtension {
    public KeymapGroup createGroup(Condition<AnAction> condition, Project project) {
        KeymapGroup result = KeymapGroupFactory.getInstance().createGroup(TasksBundle.message("maven.tasks.action.group.name", new Object[0]), MavenIcons.PhasesClosed);
        if (project == null) {
            return result;
        }
        Comparator<MavenProject> projectComparator = new Comparator<MavenProject>(){

            @Override
            public int compare(MavenProject o1, MavenProject o2) {
                return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
            }
        };
        TreeMap<MavenProject, TreeSet<Pair<String, String>>> projectToActionsMapping = new TreeMap<MavenProject, TreeSet<Pair<String, String>>>(projectComparator);
        ActionManager actionManager = ActionManager.getInstance();
        for (String eachId : actionManager.getActionIds(MavenKeymapExtension.getActionPrefix(project, null))) {
            AnAction eachAction = actionManager.getAction(eachId);
            if (!(eachAction instanceof MavenGoalAction) || condition != null && !condition.value((Object)actionManager.getActionOrStub(eachId))) continue;
            MavenGoalAction mavenAction = (MavenGoalAction)eachAction;
            MavenProject mavenProject = mavenAction.getMavenProject();
            TreeSet<Pair<String, String>> actions = (TreeSet<Pair<String, String>>)projectToActionsMapping.get(mavenProject);
            if (actions == null) {
                final List<String> projectGoals = MavenKeymapExtension.collectGoals(mavenProject);
                actions = new TreeSet<Pair<String, String>>(new Comparator<Pair<String, String>>(){

                    @Override
                    public int compare(Pair<String, String> o1, Pair<String, String> o2) {
                        int index2;
                        String goal1 = (String)o1.getFirst();
                        String goal2 = (String)o2.getFirst();
                        int index1 = projectGoals.indexOf(goal1);
                        if (index1 == (index2 = projectGoals.indexOf(goal2))) {
                            return goal1.compareToIgnoreCase(goal2);
                        }
                        return index1 < index2 ? -1 : 1;
                    }
                });
                projectToActionsMapping.put(mavenProject, actions);
            }
            actions.add(Pair.create((Object)mavenAction.getGoal(), (Object)eachId));
        }
        for (Map.Entry entry : projectToActionsMapping.entrySet()) {
            MavenProject mavenProject = (MavenProject)entry.getKey();
            Set goalsToActionIds = (Set)entry.getValue();
            if (goalsToActionIds.isEmpty()) continue;
            KeymapGroup group = KeymapGroupFactory.getInstance().createGroup(mavenProject.getDisplayName(), MavenIcons.PhasesClosed);
            result.addGroup(group);
            for (Pair eachGoalToActionId : goalsToActionIds) {
                group.addActionId((String)eachGoalToActionId.getSecond());
            }
        }
        return result;
    }

    public static void updateActions(Project project, List<MavenProject> mavenProjects) {
        MavenKeymapExtension.clearActions(project, mavenProjects);
        MavenKeymapExtension.createActions(project, mavenProjects);
    }

    private static void createActions(Project project, List<MavenProject> mavenProjects) {
        ActionManager manager = ActionManager.getInstance();
        for (MavenProject eachProject : mavenProjects) {
            String actionIdPrefix = MavenKeymapExtension.getActionPrefix(project, eachProject);
            for (MavenGoalAction eachAction : MavenKeymapExtension.collectActions(eachProject)) {
                String id = actionIdPrefix + eachAction.getGoal();
                manager.unregisterAction(id);
                manager.registerAction(id, (AnAction)eachAction);
            }
        }
    }

    private static List<MavenGoalAction> collectActions(MavenProject mavenProject) {
        ArrayList<MavenGoalAction> result = new ArrayList<MavenGoalAction>();
        for (String eachGoal : MavenKeymapExtension.collectGoals(mavenProject)) {
            result.add(new MavenGoalAction(mavenProject, eachGoal));
        }
        return result;
    }

    public static void clearActions(Project project) {
        ActionManager manager = ActionManager.getInstance();
        for (String each : manager.getActionIds(MavenKeymapExtension.getActionPrefix(project, null))) {
            manager.unregisterAction(each);
        }
    }

    public static void clearActions(Project project, List<MavenProject> mavenProjects) {
        ActionManager manager = ActionManager.getInstance();
        for (MavenProject eachProject : mavenProjects) {
            for (String eachAction : manager.getActionIds(MavenKeymapExtension.getActionPrefix(project, eachProject))) {
                manager.unregisterAction(eachAction);
            }
        }
    }

    private static List<String> collectGoals(MavenProject project) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.addAll(MavenConstants.PHASES);
        for (MavenPlugin each : project.getDeclaredPlugins()) {
            MavenKeymapExtension.collectGoals(project.getLocalRepository(), each, result);
        }
        return new ArrayList<String>(result);
    }

    private static void collectGoals(File repository, MavenPlugin plugin, LinkedHashSet<String> list) {
        MavenPluginInfo info = MavenArtifactUtil.readPluginInfo(repository, plugin.getMavenId());
        if (info == null) {
            return;
        }
        for (MavenPluginInfo.Mojo m : info.getMojos()) {
            list.add(m.getQualifiedGoal());
        }
    }

    public static String getActionPrefix(Project project, MavenProject mavenProject) {
        String pomPath = mavenProject == null ? null : mavenProject.getPath();
        return MavenShortcutsManager.getInstance(project).getActionId(pomPath, null);
    }

    private static class MavenGoalAction
    extends MavenAction {
        private final MavenProject myMavenProject;
        private final String myGoal;

        public MavenGoalAction(MavenProject mavenProject, String goal) {
            this.myMavenProject = mavenProject;
            this.myGoal = goal;
            Presentation template = this.getTemplatePresentation();
            template.setText(goal, false);
            template.setIcon(MavenIcons.Phase);
        }

        public void actionPerformed(AnActionEvent e) {
            DataContext context = e.getDataContext();
            Project project = MavenActionUtil.getProject(context);
            if (project == null) {
                return;
            }
            MavenProjectsManager projectsManager = MavenActionUtil.getProjectsManager(context);
            if (projectsManager == null) {
                return;
            }
            MavenExplicitProfiles explicitProfiles = projectsManager.getExplicitProfiles();
            MavenRunnerParameters params = new MavenRunnerParameters(true, this.myMavenProject.getDirectory(), Arrays.asList(this.myGoal), explicitProfiles.getEnabledProfiles(), explicitProfiles.getDisabledProfiles());
            MavenRunConfigurationType.runConfiguration(project, params, null);
        }

        public MavenProject getMavenProject() {
            return this.myMavenProject;
        }

        public String getGoal() {
            return this.myGoal;
        }

        public String toString() {
            return this.myMavenProject + ":" + this.myGoal;
        }
    }
}

