/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SyntaxHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.reference.SoftReference;
import com.intellij.usageView.UsageTreeColors;
import com.intellij.usageView.UsageTreeColorsScheme;
import com.intellij.usages.TextChunk;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.impl.SyntaxHighlighterOverEditorHighlighter;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.util.Processor;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.StringFactory;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkExtractor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.usages.ChunkExtractor");
    public static final int MAX_LINE_LENGTH_TO_SHOW = 200;
    public static final int OFFSET_BEFORE_TO_SHOW_WHEN_LONG_LINE = 1;
    public static final int OFFSET_AFTER_TO_SHOW_WHEN_LONG_LINE = 1;
    private final EditorColorsScheme myColorsScheme;
    private final Document myDocument;
    private long myDocumentStamp;
    private final SyntaxHighlighterOverEditorHighlighter myHighlighter;
    private static final ThreadLocal<WeakFactory<Map<PsiFile, ChunkExtractor>>> ourExtractors = new ThreadLocal<WeakFactory<Map<PsiFile, ChunkExtractor>>>(){

        @Override
        protected WeakFactory<Map<PsiFile, ChunkExtractor>> initialValue() {
            return new WeakFactory<Map<PsiFile, ChunkExtractor>>(){

                @Override
                @NotNull
                protected Map<PsiFile, ChunkExtractor> create() {
                    FactoryMap<PsiFile, ChunkExtractor> factoryMap = new FactoryMap<PsiFile, ChunkExtractor>(){

                        protected ChunkExtractor create(PsiFile psiFile) {
                            return new ChunkExtractor(psiFile);
                        }
                    };
                    if (factoryMap == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/ChunkExtractor$1$1", "create"));
                    }
                    return factoryMap;
                }
            };
        }
    };

    @NotNull
    public static TextChunk[] extractChunks(@NotNull PsiFile file, @NotNull UsageInfo2UsageAdapter usageAdapter) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/usages/ChunkExtractor", "extractChunks"));
        }
        if (usageAdapter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageAdapter", "com/intellij/usages/ChunkExtractor", "extractChunks"));
        }
        TextChunk[] textChunkArray = ChunkExtractor.getExtractor(file).extractChunks(usageAdapter, file);
        if (textChunkArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/ChunkExtractor", "extractChunks"));
        }
        return textChunkArray;
    }

    @NotNull
    public static ChunkExtractor getExtractor(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/usages/ChunkExtractor", "getExtractor"));
        }
        ChunkExtractor chunkExtractor = ourExtractors.get().getValue().get(file);
        if (chunkExtractor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/ChunkExtractor", "getExtractor"));
        }
        return chunkExtractor;
    }

    private ChunkExtractor(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/usages/ChunkExtractor", "<init>"));
        }
        this.myColorsScheme = UsageTreeColorsScheme.getInstance().getScheme();
        Project project = file.getProject();
        this.myDocument = PsiDocumentManager.getInstance(project).getDocument(file);
        LOG.assertTrue(this.myDocument != null);
        FileType fileType = file.getFileType();
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter(fileType, project, file.getVirtualFile());
        highlighter = highlighter == null ? new PlainSyntaxHighlighter() : highlighter;
        this.myHighlighter = new SyntaxHighlighterOverEditorHighlighter(highlighter, file.getVirtualFile(), project);
        this.myDocumentStamp = -1L;
    }

    public static int getStartOffset(List<RangeMarker> rangeMarkers) {
        LOG.assertTrue(!rangeMarkers.isEmpty());
        int minStart = Integer.MAX_VALUE;
        for (RangeMarker rangeMarker : rangeMarkers) {
            int startOffset;
            if (!rangeMarker.isValid() || (startOffset = rangeMarker.getStartOffset()) >= minStart) continue;
            minStart = startOffset;
        }
        return minStart == Integer.MAX_VALUE ? -1 : minStart;
    }

    @NotNull
    private TextChunk[] extractChunks(@NotNull UsageInfo2UsageAdapter usageInfo2UsageAdapter, @NotNull PsiFile file) {
        int fragmentToShowEnd;
        if (usageInfo2UsageAdapter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfo2UsageAdapter", "com/intellij/usages/ChunkExtractor", "extractChunks"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/usages/ChunkExtractor", "extractChunks"));
        }
        int absoluteStartOffset = usageInfo2UsageAdapter.getNavigationOffset();
        if (absoluteStartOffset == -1) {
            if (TextChunk.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/ChunkExtractor", "extractChunks"));
            }
            return TextChunk.EMPTY_ARRAY;
        }
        Document visibleDocument = this.myDocument instanceof DocumentWindow ? ((DocumentWindow)this.myDocument).getDelegate() : this.myDocument;
        int visibleStartOffset = this.myDocument instanceof DocumentWindow ? ((DocumentWindow)this.myDocument).injectedToHost(absoluteStartOffset) : absoluteStartOffset;
        int lineNumber = this.myDocument.getLineNumber(absoluteStartOffset);
        int visibleLineNumber = visibleDocument.getLineNumber(visibleStartOffset);
        int visibleColumnNumber = visibleStartOffset - visibleDocument.getLineStartOffset(visibleLineNumber);
        ArrayList<TextChunk> result = new ArrayList<TextChunk>();
        this.appendPrefix(result, visibleLineNumber, visibleColumnNumber);
        int fragmentToShowStart = this.myDocument.getLineStartOffset(lineNumber);
        int n = fragmentToShowEnd = fragmentToShowStart < this.myDocument.getTextLength() ? this.myDocument.getLineEndOffset(lineNumber) : 0;
        if (fragmentToShowStart > fragmentToShowEnd) {
            if (TextChunk.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/ChunkExtractor", "extractChunks"));
            }
            return TextChunk.EMPTY_ARRAY;
        }
        CharSequence chars = this.myDocument.getCharsSequence();
        if (fragmentToShowEnd - fragmentToShowStart > 200) {
            int lineStartOffset = fragmentToShowStart;
            fragmentToShowStart = Math.max(lineStartOffset, absoluteStartOffset - 1);
            int lineEndOffset = fragmentToShowEnd;
            Segment segment = usageInfo2UsageAdapter.getUsageInfo().getSegment();
            int usage_length = segment != null ? segment.getEndOffset() - segment.getStartOffset() : 0;
            if (usage_length > 0 && StringUtil.isJavaIdentifierStart((char)chars.charAt(absoluteStartOffset)) && StringUtil.isJavaIdentifierStart((char)chars.charAt(absoluteStartOffset + usage_length - 1))) {
                for (fragmentToShowEnd = Math.min(lineEndOffset, absoluteStartOffset + usage_length + 1); fragmentToShowEnd < lineEndOffset && StringUtil.isJavaIdentifierStart((char)chars.charAt(fragmentToShowEnd - 1)); ++fragmentToShowEnd) {
                }
                while (fragmentToShowStart > lineStartOffset && StringUtil.isJavaIdentifierStart((char)chars.charAt(fragmentToShowStart))) {
                    --fragmentToShowStart;
                }
                if (fragmentToShowStart != lineStartOffset) {
                    ++fragmentToShowStart;
                }
                if (fragmentToShowEnd != lineEndOffset) {
                    --fragmentToShowEnd;
                }
            }
        }
        if (this.myDocument instanceof DocumentWindow) {
            List<TextRange> editable = InjectedLanguageManager.getInstance(file.getProject()).intersectWithAllEditableFragments(file, new TextRange(fragmentToShowStart, fragmentToShowEnd));
            for (TextRange range : editable) {
                this.createTextChunks(usageInfo2UsageAdapter, chars, range.getStartOffset(), range.getEndOffset(), true, result);
            }
            TextChunk[] textChunkArray = result.toArray(new TextChunk[result.size()]);
            if (textChunkArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/ChunkExtractor", "extractChunks"));
            }
            return textChunkArray;
        }
        TextChunk[] textChunkArray = this.createTextChunks(usageInfo2UsageAdapter, chars, fragmentToShowStart, fragmentToShowEnd, true, result);
        if (textChunkArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/ChunkExtractor", "extractChunks"));
        }
        return textChunkArray;
    }

    @NotNull
    public TextChunk[] createTextChunks(@NotNull UsageInfo2UsageAdapter usageInfo2UsageAdapter, @NotNull CharSequence chars, int start, int end, boolean selectUsageWithBold, @NotNull List<TextChunk> result) {
        if (usageInfo2UsageAdapter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfo2UsageAdapter", "com/intellij/usages/ChunkExtractor", "createTextChunks"));
        }
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/usages/ChunkExtractor", "createTextChunks"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/usages/ChunkExtractor", "createTextChunks"));
        }
        Lexer lexer = this.myHighlighter.getHighlightingLexer();
        SyntaxHighlighterOverEditorHighlighter highlighter = this.myHighlighter;
        LOG.assertTrue(start <= end);
        int i = StringUtil.indexOf((CharSequence)chars, (char)'\n', (int)start, (int)end);
        if (i != -1) {
            end = i;
        }
        if (this.myDocumentStamp != this.myDocument.getModificationStamp()) {
            highlighter.restart(chars);
            this.myDocumentStamp = this.myDocument.getModificationStamp();
        } else if (lexer.getTokenType() == null || lexer.getTokenStart() > start) {
            highlighter.resetPosition(0);
        }
        boolean isBeginning = true;
        while (lexer.getTokenType() != null) {
            String text;
            int hiStart = lexer.getTokenStart();
            int hiEnd = lexer.getTokenEnd();
            if (hiStart >= end) break;
            if (!((hiStart = Math.max(hiStart, start)) >= (hiEnd = Math.min(hiEnd, end)) || isBeginning && (text = chars.subSequence(hiStart, hiEnd).toString()).trim().isEmpty())) {
                isBeginning = false;
                IElementType tokenType = lexer.getTokenType();
                TextAttributesKey[] tokenHighlights = highlighter.getTokenHighlights(tokenType);
                this.processIntersectingRange(usageInfo2UsageAdapter, chars, hiStart, hiEnd, tokenHighlights, selectUsageWithBold, result);
            }
            lexer.advance();
        }
        TextChunk[] textChunkArray = result.toArray(new TextChunk[result.size()]);
        if (textChunkArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/ChunkExtractor", "createTextChunks"));
        }
        return textChunkArray;
    }

    private void processIntersectingRange(@NotNull UsageInfo2UsageAdapter usageInfo2UsageAdapter, final @NotNull CharSequence chars, int hiStart, final int hiEnd, final @NotNull TextAttributesKey[] tokenHighlights, final boolean selectUsageWithBold, final @NotNull List<TextChunk> result) {
        if (usageInfo2UsageAdapter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfo2UsageAdapter", "com/intellij/usages/ChunkExtractor", "processIntersectingRange"));
        }
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/usages/ChunkExtractor", "processIntersectingRange"));
        }
        if (tokenHighlights == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenHighlights", "com/intellij/usages/ChunkExtractor", "processIntersectingRange"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/usages/ChunkExtractor", "processIntersectingRange"));
        }
        final TextAttributes originalAttrs = this.convertAttributes(tokenHighlights);
        if (selectUsageWithBold) {
            originalAttrs.setFontType(0);
        }
        final int[] lastOffset = new int[]{hiStart};
        usageInfo2UsageAdapter.processRangeMarkers(new Processor<Segment>(){

            public boolean process(Segment segment) {
                int usageEnd;
                int usageStart = segment.getStartOffset();
                if (ChunkExtractor.rangeIntersect(lastOffset[0], hiEnd, usageStart, usageEnd = segment.getEndOffset())) {
                    ChunkExtractor.addChunk(chars, lastOffset[0], Math.max(lastOffset[0], usageStart), originalAttrs, false, null, result);
                    UsageType usageType = ChunkExtractor.isHighlightedAsString(tokenHighlights) ? UsageType.LITERAL_USAGE : (ChunkExtractor.isHighlightedAsComment(tokenHighlights) ? UsageType.COMMENT_USAGE : null);
                    ChunkExtractor.addChunk(chars, Math.max(lastOffset[0], usageStart), Math.min(hiEnd, usageEnd), originalAttrs, selectUsageWithBold, usageType, result);
                    lastOffset[0] = usageEnd;
                    if (usageEnd > hiEnd) {
                        return false;
                    }
                }
                return true;
            }
        });
        if (lastOffset[0] < hiEnd) {
            ChunkExtractor.addChunk(chars, lastOffset[0], hiEnd, originalAttrs, false, null, result);
        }
    }

    public static boolean isHighlightedAsComment(TextAttributesKey ... keys) {
        for (TextAttributesKey key : keys) {
            TextAttributesKey fallbackAttributeKey;
            if (key == DefaultLanguageHighlighterColors.DOC_COMMENT || key == SyntaxHighlighterColors.DOC_COMMENT || key == DefaultLanguageHighlighterColors.LINE_COMMENT || key == SyntaxHighlighterColors.LINE_COMMENT || key == DefaultLanguageHighlighterColors.BLOCK_COMMENT || key == SyntaxHighlighterColors.JAVA_BLOCK_COMMENT) {
                return true;
            }
            if (key == null || (fallbackAttributeKey = key.getFallbackAttributeKey()) == null || !ChunkExtractor.isHighlightedAsComment(fallbackAttributeKey)) continue;
            return true;
        }
        return false;
    }

    public static boolean isHighlightedAsString(TextAttributesKey ... keys) {
        for (TextAttributesKey key : keys) {
            TextAttributesKey fallbackAttributeKey;
            if (key == DefaultLanguageHighlighterColors.STRING || key == SyntaxHighlighterColors.STRING) {
                return true;
            }
            if (key == null || (fallbackAttributeKey = key.getFallbackAttributeKey()) == null || !ChunkExtractor.isHighlightedAsString(fallbackAttributeKey)) continue;
            return true;
        }
        return false;
    }

    private static void addChunk(@NotNull CharSequence chars, int start, int end, @NotNull TextAttributes originalAttrs, boolean bold, @Nullable UsageType usageType, @NotNull List<TextChunk> result) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/usages/ChunkExtractor", "addChunk"));
        }
        if (originalAttrs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalAttrs", "com/intellij/usages/ChunkExtractor", "addChunk"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/usages/ChunkExtractor", "addChunk"));
        }
        if (start >= end) {
            return;
        }
        TextAttributes attrs = bold ? TextAttributes.merge(originalAttrs, new TextAttributes(null, null, null, null, 1)) : originalAttrs;
        result.add(new TextChunk(attrs, StringFactory.createShared((char[])CharArrayUtil.fromSequence((CharSequence)chars, (int)start, (int)end)), usageType));
    }

    private static boolean rangeIntersect(int s1, int e1, int s2, int e2) {
        return s2 < s1 && s1 < e2 || s2 < e1 && e1 < e2 || s1 < s2 && s2 < e1 || s1 < e2 && e2 < e1 || s1 == s2 && e1 == e2;
    }

    @NotNull
    private TextAttributes convertAttributes(@NotNull TextAttributesKey[] keys) {
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/usages/ChunkExtractor", "convertAttributes"));
        }
        TextAttributes attrs = this.myColorsScheme.getAttributes(HighlighterColors.TEXT);
        for (TextAttributesKey key : keys) {
            TextAttributes attrs2 = this.myColorsScheme.getAttributes(key);
            if (attrs2 == null) continue;
            attrs = TextAttributes.merge(attrs, attrs2);
        }
        TextAttributes textAttributes = attrs = attrs.clone();
        if (textAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/ChunkExtractor", "convertAttributes"));
        }
        return textAttributes;
    }

    private void appendPrefix(@NotNull List<TextChunk> result, int lineNumber, int columnNumber) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/usages/ChunkExtractor", "appendPrefix"));
        }
        String prefix = "(" + (lineNumber + 1) + ": " + (columnNumber + 1) + ") ";
        TextChunk prefixChunk = new TextChunk(this.myColorsScheme.getAttributes(UsageTreeColors.USAGE_LOCATION), prefix);
        result.add(prefixChunk);
    }

    private static abstract class WeakFactory<T> {
        private WeakReference<T> myRef;

        private WeakFactory() {
        }

        @NotNull
        protected abstract T create();

        @NotNull
        public T getValue() {
            Object cur = SoftReference.dereference(this.myRef);
            if (cur != null) {
                Object object = cur;
                if (object == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/ChunkExtractor$WeakFactory", "getValue"));
                }
                return (T)object;
            }
            T result = this.create();
            this.myRef = new WeakReference<T>(result);
            T t = result;
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/ChunkExtractor$WeakFactory", "getValue"));
            }
            return t;
        }
    }
}

