/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.find.FindManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.ui.RangeBlinker;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SearchForUsagesRunnable
implements Runnable {
    @NonNls
    private static final String FIND_OPTIONS_HREF_TARGET = "FindOptions";
    @NonNls
    private static final String SEARCH_IN_PROJECT_HREF_TARGET = "SearchInProject";
    @NonNls
    private static final String LARGE_FILES_HREF_TARGET = "LargeFiles";
    @NonNls
    private static final String SHOW_PROJECT_FILE_OCCURRENCES_HREF_TARGET = "SHOW_PROJECT_FILE_OCCURRENCES";
    private final AtomicInteger myUsageCountWithoutDefinition;
    private final AtomicReference<Usage> myFirstUsage;
    @NotNull
    private final Project myProject;
    private final AtomicReference<UsageViewImpl> myUsageViewRef;
    private final UsageViewPresentation myPresentation;
    private final UsageTarget[] mySearchFor;
    private final Factory<UsageSearcher> mySearcherFactory;
    private final FindUsagesProcessPresentation myProcessPresentation;
    @NotNull
    private final SearchScope mySearchScopeToWarnOfFallingOutOf;
    private final UsageViewManager.UsageViewStateListener myListener;
    private final UsageViewManagerImpl myUsageViewManager;
    private final AtomicInteger myOutOfScopeUsages;

    SearchForUsagesRunnable(@NotNull UsageViewManagerImpl usageViewManager, @NotNull Project project, @NotNull AtomicReference<UsageViewImpl> usageViewRef, @NotNull UsageViewPresentation presentation, @NotNull UsageTarget[] searchFor, @NotNull Factory<UsageSearcher> searcherFactory, @NotNull FindUsagesProcessPresentation processPresentation, @NotNull SearchScope searchScopeToWarnOfFallingOutOf, @Nullable UsageViewManager.UsageViewStateListener listener) {
        if (usageViewManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageViewManager", "com/intellij/usages/impl/SearchForUsagesRunnable", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/usages/impl/SearchForUsagesRunnable", "<init>"));
        }
        if (usageViewRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageViewRef", "com/intellij/usages/impl/SearchForUsagesRunnable", "<init>"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/usages/impl/SearchForUsagesRunnable", "<init>"));
        }
        if (searchFor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchFor", "com/intellij/usages/impl/SearchForUsagesRunnable", "<init>"));
        }
        if (searcherFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searcherFactory", "com/intellij/usages/impl/SearchForUsagesRunnable", "<init>"));
        }
        if (processPresentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processPresentation", "com/intellij/usages/impl/SearchForUsagesRunnable", "<init>"));
        }
        if (searchScopeToWarnOfFallingOutOf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScopeToWarnOfFallingOutOf", "com/intellij/usages/impl/SearchForUsagesRunnable", "<init>"));
        }
        this.myUsageCountWithoutDefinition = new AtomicInteger(0);
        this.myFirstUsage = new AtomicReference();
        this.myOutOfScopeUsages = new AtomicInteger();
        this.myProject = project;
        this.myUsageViewRef = usageViewRef;
        this.myPresentation = presentation;
        this.mySearchFor = searchFor;
        this.mySearcherFactory = searcherFactory;
        this.myProcessPresentation = processPresentation;
        this.mySearchScopeToWarnOfFallingOutOf = searchScopeToWarnOfFallingOutOf;
        this.myListener = listener;
        this.myUsageViewManager = usageViewManager;
    }

    @NotNull
    private static String createOptionsHtml(@NonNls UsageTarget[] searchFor) {
        KeyboardShortcut shortcut = UsageViewImpl.getShowUsagesWithSettingsShortcut(searchFor);
        String shortcutText = "";
        if (shortcut != null) {
            shortcutText = "&nbsp;(" + KeymapUtil.getShortcutText(shortcut) + ")";
        }
        String string = "<a href='FindOptions'>Find Options...</a>" + shortcutText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/SearchForUsagesRunnable", "createOptionsHtml"));
        }
        return string;
    }

    @NotNull
    private static String createSearchInProjectHtml() {
        if ("<a href='SearchInProject'>Search in Project</a>" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/SearchForUsagesRunnable", "createSearchInProjectHtml"));
        }
        return "<a href='SearchInProject'>Search in Project</a>";
    }

    private static void notifyByFindBalloon(final @Nullable HyperlinkListener listener, final @NotNull MessageType info, @NotNull FindUsagesProcessPresentation processPresentation, final @NotNull Project project, final @NotNull List<String> lines) {
        Runnable searchIncludingProjectFileUsages;
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/usages/impl/SearchForUsagesRunnable", "notifyByFindBalloon"));
        }
        if (processPresentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processPresentation", "com/intellij/usages/impl/SearchForUsagesRunnable", "notifyByFindBalloon"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/usages/impl/SearchForUsagesRunnable", "notifyByFindBalloon"));
        }
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/usages/impl/SearchForUsagesRunnable", "notifyByFindBalloon"));
        }
        com.intellij.usageView.UsageViewManager.getInstance(project);
        final Collection<VirtualFile> largeFiles = processPresentation.getLargeFiles();
        ArrayList<String> resultLines = new ArrayList<String>(lines);
        HyperlinkListener resultListener = listener;
        if (!largeFiles.isEmpty()) {
            String shortMessage = "(<a href='LargeFiles'>" + UsageViewBundle.message("large.files.were.ignored", largeFiles.size()) + "</a>)";
            resultLines.add(shortMessage);
            resultListener = SearchForUsagesRunnable.addHrefHandling(resultListener, LARGE_FILES_HREF_TARGET, new Runnable(){

                @Override
                public void run() {
                    String detailedMessage = SearchForUsagesRunnable.detailedLargeFilesMessage(largeFiles);
                    ArrayList<String> strings = new ArrayList<String>(lines);
                    strings.add(detailedMessage);
                    ToolWindowManager.getInstance(project).notifyByBalloon(ToolWindowId.FIND, info, SearchForUsagesRunnable.wrapInHtml(strings), AllIcons.Actions.Find, listener);
                }
            });
        }
        if ((searchIncludingProjectFileUsages = processPresentation.searchIncludingProjectFileUsages()) != null) {
            resultLines.add("Occurrences in " + ApplicationNamesInfo.getInstance().getProductName() + " project files are skipped. " + "<a href='" + SHOW_PROJECT_FILE_OCCURRENCES_HREF_TARGET + "'>Include them</a>");
            resultListener = SearchForUsagesRunnable.addHrefHandling(resultListener, SHOW_PROJECT_FILE_OCCURRENCES_HREF_TARGET, searchIncludingProjectFileUsages);
        }
        ToolWindowManager.getInstance(project).notifyByBalloon(ToolWindowId.FIND, info, SearchForUsagesRunnable.wrapInHtml(resultLines), AllIcons.Actions.Find, resultListener);
    }

    private static HyperlinkListener addHrefHandling(final @Nullable HyperlinkListener listener, final @NotNull String hrefTarget, final @NotNull Runnable handler) {
        if (hrefTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hrefTarget", "com/intellij/usages/impl/SearchForUsagesRunnable", "addHrefHandling"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/usages/impl/SearchForUsagesRunnable", "addHrefHandling"));
        }
        return new HyperlinkAdapter(){

            @Override
            protected void hyperlinkActivated(HyperlinkEvent e) {
                if (e.getDescription().equals(hrefTarget)) {
                    handler.run();
                } else if (listener != null) {
                    listener.hyperlinkUpdate(e);
                }
            }
        };
    }

    @NotNull
    private static String wrapInHtml(@NotNull List<String> strings) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/usages/impl/SearchForUsagesRunnable", "wrapInHtml"));
        }
        String string = XmlStringUtil.wrapInHtml((CharSequence)StringUtil.join(strings, (String)"<br>"));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/SearchForUsagesRunnable", "wrapInHtml"));
        }
        return string;
    }

    @NotNull
    private static String detailedLargeFilesMessage(@NotNull Collection<VirtualFile> largeFiles) {
        if (largeFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "largeFiles", "com/intellij/usages/impl/SearchForUsagesRunnable", "detailedLargeFilesMessage"));
        }
        String message = "";
        if (largeFiles.size() == 1) {
            VirtualFile vFile = largeFiles.iterator().next();
            message = message + "File " + SearchForUsagesRunnable.presentableFileInfo(vFile) + " is ";
        } else {
            message = message + "Files<br> ";
            int counter = 0;
            for (VirtualFile vFile : largeFiles) {
                message = message + SearchForUsagesRunnable.presentableFileInfo(vFile) + "<br> ";
                if (counter++ <= 10) continue;
                break;
            }
            message = message + "are ";
        }
        String string = message = message + "too large and cannot be scanned";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/SearchForUsagesRunnable", "detailedLargeFilesMessage"));
        }
        return string;
    }

    @NotNull
    private static String presentableFileInfo(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/usages/impl/SearchForUsagesRunnable", "presentableFileInfo"));
        }
        String string = SearchForUsagesRunnable.getPresentablePath(vFile) + "&nbsp;(" + UsageViewManagerImpl.presentableSize(UsageViewManagerImpl.getFileLength(vFile)) + ")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/SearchForUsagesRunnable", "presentableFileInfo"));
        }
        return string;
    }

    @NotNull
    private static String getPresentablePath(final @NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/usages/impl/SearchForUsagesRunnable", "getPresentablePath"));
        }
        String string = "'" + ApplicationManager.getApplication().runReadAction(new Computable<String>(){

            public String compute() {
                return virtualFile.getPresentableUrl();
            }
        }) + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/SearchForUsagesRunnable", "getPresentablePath"));
        }
        return string;
    }

    @NotNull
    private HyperlinkListener createGotToOptionsListener(final @NotNull UsageTarget[] targets) {
        if (targets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/intellij/usages/impl/SearchForUsagesRunnable", "createGotToOptionsListener"));
        }
        HyperlinkAdapter hyperlinkAdapter = new HyperlinkAdapter(){

            @Override
            protected void hyperlinkActivated(HyperlinkEvent e) {
                if (e.getDescription().equals(SearchForUsagesRunnable.FIND_OPTIONS_HREF_TARGET)) {
                    FindManager.getInstance(SearchForUsagesRunnable.this.myProject).showSettingsAndFindUsages(targets);
                }
            }
        };
        if (hyperlinkAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/SearchForUsagesRunnable", "createGotToOptionsListener"));
        }
        return hyperlinkAdapter;
    }

    @NotNull
    private HyperlinkListener createSearchInProjectListener() {
        HyperlinkAdapter hyperlinkAdapter = new HyperlinkAdapter(){

            @Override
            protected void hyperlinkActivated(HyperlinkEvent e) {
                PsiElement psiElement;
                if (e.getDescription().equals(SearchForUsagesRunnable.SEARCH_IN_PROJECT_HREF_TARGET) && (psiElement = SearchForUsagesRunnable.getPsiElement(SearchForUsagesRunnable.this.mySearchFor)) != null) {
                    FindManager.getInstance(SearchForUsagesRunnable.this.myProject).findUsagesInScope(psiElement, GlobalSearchScope.projectScope(SearchForUsagesRunnable.this.myProject));
                }
            }
        };
        if (hyperlinkAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/SearchForUsagesRunnable", "createSearchInProjectListener"));
        }
        return hyperlinkAdapter;
    }

    private static PsiElement getPsiElement(@NotNull UsageTarget[] searchFor) {
        if (searchFor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchFor", "com/intellij/usages/impl/SearchForUsagesRunnable", "getPsiElement"));
        }
        final UsageTarget target = searchFor[0];
        if (!(target instanceof PsiElementUsageTarget)) {
            return null;
        }
        return ApplicationManager.getApplication().runReadAction(new Computable<PsiElement>(){

            public PsiElement compute() {
                return ((PsiElementUsageTarget)target).getElement();
            }
        });
    }

    private static void flashUsageScriptaculously(@NotNull Usage usage) {
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/usages/impl/SearchForUsagesRunnable", "flashUsageScriptaculously"));
        }
        if (!(usage instanceof UsageInfo2UsageAdapter)) {
            return;
        }
        UsageInfo2UsageAdapter usageInfo = (UsageInfo2UsageAdapter)usage;
        Editor editor = usageInfo.openTextEditor(true);
        if (editor == null) {
            return;
        }
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.BLINKING_HIGHLIGHTS_ATTRIBUTES);
        RangeBlinker rangeBlinker = new RangeBlinker(editor, attributes, 6);
        ArrayList<Segment> segments = new ArrayList<Segment>();
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor(segments);
        usageInfo.processRangeMarkers((Processor<Segment>)processor);
        rangeBlinker.resetMarkers(segments);
        rangeBlinker.startBlinking();
    }

    private UsageViewImpl getUsageView(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/usages/impl/SearchForUsagesRunnable", "getUsageView"));
        }
        UsageViewImpl usageView = this.myUsageViewRef.get();
        if (usageView != null) {
            return usageView;
        }
        int usageCount = this.myUsageCountWithoutDefinition.get();
        if (usageCount >= 2 || usageCount == 1 && this.myProcessPresentation.isShowPanelIfOnlyOneUsage()) {
            usageView = new UsageViewImpl(this.myProject, this.myPresentation, this.mySearchFor, this.mySearcherFactory);
            usageView.associateProgress(indicator);
            if (this.myUsageViewRef.compareAndSet(null, usageView)) {
                this.openView(usageView);
                final Usage firstUsage = this.myFirstUsage.get();
                if (firstUsage != null) {
                    final UsageViewImpl finalUsageView = usageView;
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            finalUsageView.appendUsage(firstUsage);
                        }
                    });
                }
            } else {
                Disposer.dispose((Disposable)usageView);
            }
            return this.myUsageViewRef.get();
        }
        return null;
    }

    private void openView(final @NotNull UsageViewImpl usageView) {
        if (usageView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/usages/impl/SearchForUsagesRunnable", "openView"));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SearchForUsagesRunnable.this.myProject.isDisposed()) {
                    return;
                }
                SearchForUsagesRunnable.this.myUsageViewManager.addContent(usageView, SearchForUsagesRunnable.this.myPresentation);
                if (SearchForUsagesRunnable.this.myListener != null) {
                    SearchForUsagesRunnable.this.myListener.usageViewCreated(usageView);
                }
                SearchForUsagesRunnable.this.myUsageViewManager.showToolWindow(false);
            }
        });
    }

    @Override
    public void run() {
        PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
        AtomicBoolean findUsagesStartedShown = new AtomicBoolean();
        this.searchUsages(findUsagesStartedShown);
        this.endSearchForUsages(findUsagesStartedShown);
        snapshot.logResponsivenessSinceCreation("Find Usages");
    }

    private void searchUsages(final @NotNull AtomicBoolean findStartedBalloonShown) {
        if (findStartedBalloonShown == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findStartedBalloonShown", "com/intellij/usages/impl/SearchForUsagesRunnable", "searchUsages"));
        }
        ProgressIndicator indicator = ProgressWrapper.unwrap((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator());
        assert (indicator != null) : "must run find usages under progress";
        TooManyUsagesStatus.createFor((ProgressIndicator)indicator);
        Alarm findUsagesStartedBalloon = new Alarm();
        findUsagesStartedBalloon.addRequest(new Runnable(){

            @Override
            public void run() {
                SearchForUsagesRunnable.notifyByFindBalloon(null, MessageType.WARNING, SearchForUsagesRunnable.this.myProcessPresentation, SearchForUsagesRunnable.this.myProject, Collections.singletonList(StringUtil.escapeXml((String)UsageViewManagerImpl.getProgressTitle(SearchForUsagesRunnable.this.myPresentation))));
                findStartedBalloonShown.set(true);
            }
        }, 300, ModalityState.NON_MODAL);
        UsageSearcher usageSearcher = (UsageSearcher)this.mySearcherFactory.create();
        usageSearcher.generate(new Processor<Usage>(){

            public boolean process(final Usage usage) {
                boolean incrementCounter;
                ProgressIndicator indicator = ProgressWrapper.unwrap((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator());
                assert (indicator != null) : "must run find usages under progress";
                if (indicator.isCanceled()) {
                    return false;
                }
                if (!UsageViewManagerImpl.isInScope(usage, SearchForUsagesRunnable.this.mySearchScopeToWarnOfFallingOutOf)) {
                    SearchForUsagesRunnable.this.myOutOfScopeUsages.incrementAndGet();
                    return true;
                }
                boolean bl = incrementCounter = !UsageViewManager.isSelfUsage(usage, SearchForUsagesRunnable.this.mySearchFor);
                if (incrementCounter) {
                    TooManyUsagesStatus tooManyUsagesStatus;
                    int usageCount = SearchForUsagesRunnable.this.myUsageCountWithoutDefinition.incrementAndGet();
                    if (usageCount == 1 && !SearchForUsagesRunnable.this.myProcessPresentation.isShowPanelIfOnlyOneUsage()) {
                        SearchForUsagesRunnable.this.myFirstUsage.compareAndSet(null, usage);
                    }
                    final UsageViewImpl usageView = SearchForUsagesRunnable.this.getUsageView(indicator);
                    if (usageCount > 1000 && (tooManyUsagesStatus = TooManyUsagesStatus.getFrom((ProgressIndicator)indicator)).switchTooManyUsagesStatus()) {
                        UsageViewManagerImpl.showTooManyUsagesWarning(SearchForUsagesRunnable.this.myProject, tooManyUsagesStatus, indicator, SearchForUsagesRunnable.this.myPresentation, usageCount, usageView);
                    }
                    if (usageView != null) {
                        ApplicationManager.getApplication().runReadAction(new Runnable(){

                            @Override
                            public void run() {
                                usageView.appendUsage(usage);
                            }
                        });
                    }
                }
                return !indicator.isCanceled();
            }
        });
        if (this.getUsageView(indicator) != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    SearchForUsagesRunnable.this.myUsageViewManager.showToolWindow(true);
                }
            }, this.myProject.getDisposed());
        }
        Disposer.dispose((Disposable)findUsagesStartedBalloon);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                Balloon balloon;
                if (findStartedBalloonShown.get() && (balloon = ToolWindowManager.getInstance(SearchForUsagesRunnable.this.myProject).getToolWindowBalloon(ToolWindowId.FIND)) != null) {
                    balloon.hide();
                }
            }
        }, this.myProject.getDisposed());
    }

    private void endSearchForUsages(final @NotNull AtomicBoolean findStartedBalloonShown) {
        if (findStartedBalloonShown == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findStartedBalloonShown", "com/intellij/usages/impl/SearchForUsagesRunnable", "endSearchForUsages"));
        }
        assert (!ApplicationManager.getApplication().isDispatchThread()) : Thread.currentThread();
        int usageCount = this.myUsageCountWithoutDefinition.get();
        if (usageCount == 0 && this.myProcessPresentation.isShowNotFoundMessage()) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SearchForUsagesRunnable.this.myProcessPresentation.isCanceled()) {
                        SearchForUsagesRunnable.notifyByFindBalloon(null, MessageType.WARNING, SearchForUsagesRunnable.this.myProcessPresentation, SearchForUsagesRunnable.this.myProject, Arrays.asList("Usage search was canceled"));
                        findStartedBalloonShown.set(false);
                        return;
                    }
                    List<Action> notFoundActions = SearchForUsagesRunnable.this.myProcessPresentation.getNotFoundActions();
                    String message = UsageViewBundle.message("dialog.no.usages.found.in", StringUtil.decapitalize((String)SearchForUsagesRunnable.this.myPresentation.getUsagesString()), SearchForUsagesRunnable.this.myPresentation.getScopeText(), SearchForUsagesRunnable.this.myPresentation.getContextText());
                    if (notFoundActions.isEmpty()) {
                        ArrayList<String> lines = new ArrayList<String>();
                        lines.add(StringUtil.escapeXml((String)message));
                        if (SearchForUsagesRunnable.this.myOutOfScopeUsages.get() != 0) {
                            lines.add(UsageViewManagerImpl.outOfScopeMessage(SearchForUsagesRunnable.this.myOutOfScopeUsages.get(), SearchForUsagesRunnable.this.mySearchScopeToWarnOfFallingOutOf));
                        }
                        if (SearchForUsagesRunnable.this.myProcessPresentation.isShowFindOptionsPrompt()) {
                            lines.add(SearchForUsagesRunnable.createOptionsHtml(SearchForUsagesRunnable.this.mySearchFor));
                        }
                        MessageType type = SearchForUsagesRunnable.this.myOutOfScopeUsages.get() == 0 ? MessageType.INFO : MessageType.WARNING;
                        SearchForUsagesRunnable.notifyByFindBalloon(SearchForUsagesRunnable.this.createGotToOptionsListener(SearchForUsagesRunnable.this.mySearchFor), type, SearchForUsagesRunnable.this.myProcessPresentation, SearchForUsagesRunnable.this.myProject, lines);
                        findStartedBalloonShown.set(false);
                    } else {
                        ArrayList<String> titles = new ArrayList<String>(notFoundActions.size() + 1);
                        titles.add(UsageViewBundle.message("dialog.button.ok", new Object[0]));
                        for (Action action : notFoundActions) {
                            Object value = action.getValue("NameWithMnemonic");
                            if (value == null) {
                                value = action.getValue("Name");
                            }
                            titles.add((String)value);
                        }
                        int option = Messages.showDialog(SearchForUsagesRunnable.this.myProject, message, UsageViewBundle.message("dialog.title.information", new Object[0]), ArrayUtil.toStringArray(titles), 0, Messages.getInformationIcon());
                        if (option > 0) {
                            notFoundActions.get(option - 1).actionPerformed(new ActionEvent(this, 0, (String)titles.get(option)));
                        }
                    }
                }
            }, ModalityState.NON_MODAL, this.myProject.getDisposed());
        } else if (usageCount == 1 && !this.myProcessPresentation.isShowPanelIfOnlyOneUsage()) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Usage usage = (Usage)SearchForUsagesRunnable.this.myFirstUsage.get();
                    if (usage.canNavigate()) {
                        usage.navigate(true);
                        SearchForUsagesRunnable.flashUsageScriptaculously(usage);
                    }
                    ArrayList<String> lines = new ArrayList<String>();
                    lines.add("Only one usage found.");
                    if (SearchForUsagesRunnable.this.myOutOfScopeUsages.get() != 0) {
                        lines.add(UsageViewManagerImpl.outOfScopeMessage(SearchForUsagesRunnable.this.myOutOfScopeUsages.get(), SearchForUsagesRunnable.this.mySearchScopeToWarnOfFallingOutOf));
                    }
                    lines.add(SearchForUsagesRunnable.createOptionsHtml(SearchForUsagesRunnable.this.mySearchFor));
                    MessageType type = SearchForUsagesRunnable.this.myOutOfScopeUsages.get() == 0 ? MessageType.INFO : MessageType.WARNING;
                    SearchForUsagesRunnable.notifyByFindBalloon(SearchForUsagesRunnable.this.createGotToOptionsListener(SearchForUsagesRunnable.this.mySearchFor), type, SearchForUsagesRunnable.this.myProcessPresentation, SearchForUsagesRunnable.this.myProject, lines);
                }
            }, ModalityState.NON_MODAL, this.myProject.getDisposed());
        } else {
            HyperlinkListener hyperlinkListener;
            List<Object> lines;
            UsageViewImpl usageView = this.myUsageViewRef.get();
            if (usageView != null) {
                usageView.drainQueuedUsageNodes();
                usageView.setSearchInProgress(false);
            }
            if (this.myOutOfScopeUsages.get() == 0 || SearchForUsagesRunnable.getPsiElement(this.mySearchFor) == null) {
                lines = Collections.emptyList();
                hyperlinkListener = null;
            } else {
                lines = Arrays.asList(UsageViewManagerImpl.outOfScopeMessage(this.myOutOfScopeUsages.get(), this.mySearchScopeToWarnOfFallingOutOf), SearchForUsagesRunnable.createSearchInProjectHtml());
                hyperlinkListener = this.createSearchInProjectListener();
            }
            if (!this.myProcessPresentation.getLargeFiles().isEmpty() || this.myOutOfScopeUsages.get() != 0 || this.myProcessPresentation.searchIncludingProjectFileUsages() != null) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MessageType type = SearchForUsagesRunnable.this.myOutOfScopeUsages.get() == 0 ? MessageType.INFO : MessageType.WARNING;
                        SearchForUsagesRunnable.notifyByFindBalloon(hyperlinkListener, type, SearchForUsagesRunnable.this.myProcessPresentation, SearchForUsagesRunnable.this.myProject, lines);
                    }
                }, ModalityState.NON_MODAL, this.myProject.getDisposed());
            }
        }
        if (this.myListener != null) {
            this.myListener.findingUsagesFinished(this.myUsageViewRef.get());
        }
    }
}

