/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net.ssl;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.net.ssl.CertificateWrapper;
import com.intellij.util.ui.tree.TreeUtil;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CertificateTreeBuilder
extends AbstractTreeBuilder {
    private static final SimpleTextAttributes STRIKEOUT_ATTRIBUTES = new SimpleTextAttributes(4, null);
    private static final RootDescriptor ROOT_DESCRIPTOR = new RootDescriptor();
    private final MultiMap<String, CertificateWrapper> myCertificates;

    public CertificateTreeBuilder(@NotNull Tree tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/util/net/ssl/CertificateTreeBuilder", "<init>"));
        }
        this.myCertificates = new MultiMap();
        this.init(tree, new DefaultTreeModel(new DefaultMutableTreeNode()), new MyTreeStructure(), new Comparator<NodeDescriptor>(){

            @Override
            public int compare(NodeDescriptor o1, NodeDescriptor o2) {
                if (o1 instanceof OrganizationDescriptor && o2 instanceof OrganizationDescriptor) {
                    return ((String)o1.getElement()).compareTo((String)o2.getElement());
                }
                if (o1 instanceof CertificateDescriptor && o2 instanceof CertificateDescriptor) {
                    String cn1 = ((CertificateWrapper)((CertificateDescriptor)o1).getElement()).getSubjectField(CertificateWrapper.CommonField.COMMON_NAME);
                    String cn2 = ((CertificateWrapper)((CertificateDescriptor)o2).getElement()).getSubjectField(CertificateWrapper.CommonField.COMMON_NAME);
                    return cn1.compareTo(cn2);
                }
                return 0;
            }
        }, true);
        this.initRootNode();
    }

    public void reset(@NotNull Collection<X509Certificate> certificates) {
        if (certificates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "certificates", "com/intellij/util/net/ssl/CertificateTreeBuilder", "reset"));
        }
        this.myCertificates.clear();
        for (X509Certificate certificate : certificates) {
            this.addCertificate(certificate);
        }
        this.queueUpdateFrom(RootDescriptor.ROOT, true).doWhenDone(new Runnable(){

            @Override
            public void run() {
                CertificateTreeBuilder.this.expandAll(null);
            }
        });
    }

    public void addCertificate(@NotNull X509Certificate certificate) {
        if (certificate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "certificate", "com/intellij/util/net/ssl/CertificateTreeBuilder", "addCertificate"));
        }
        CertificateWrapper wrapper = new CertificateWrapper(certificate);
        this.myCertificates.putValue((Object)wrapper.getSubjectField(CertificateWrapper.CommonField.ORGANIZATION), (Object)wrapper);
        this.queueUpdateFrom(RootDescriptor.ROOT, true);
    }

    public void removeCertificate(@NotNull X509Certificate certificate) {
        if (certificate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "certificate", "com/intellij/util/net/ssl/CertificateTreeBuilder", "removeCertificate"));
        }
        CertificateWrapper wrapper = new CertificateWrapper(certificate);
        this.myCertificates.remove((Object)wrapper.getSubjectField(CertificateWrapper.CommonField.ORGANIZATION), (Object)wrapper);
        this.queueUpdateFrom(RootDescriptor.ROOT, true);
    }

    public List<X509Certificate> getCertificates() {
        return ContainerUtil.map((Collection)this.myCertificates.values(), (Function)new Function<CertificateWrapper, X509Certificate>(){

            public X509Certificate fun(CertificateWrapper wrapper) {
                return wrapper.getCertificate();
            }
        });
    }

    public boolean isEmpty() {
        return this.myCertificates.isEmpty();
    }

    public void selectCertificate(@NotNull X509Certificate certificate) {
        if (certificate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "certificate", "com/intellij/util/net/ssl/CertificateTreeBuilder", "selectCertificate"));
        }
        this.select(new CertificateWrapper(certificate));
    }

    public void selectFirstCertificate() {
        if (!this.isEmpty()) {
            Tree tree = (Tree)this.getTree();
            TreePath path = TreeUtil.getFirstLeafNodePath(tree);
            tree.addSelectionPath(path);
        }
    }

    @NotNull
    public Set<X509Certificate> getSelectedCertificates(boolean addFromOrganization) {
        Set<X509Certificate> selected = this.getSelectedElements(X509Certificate.class);
        if (addFromOrganization) {
            for (String s : this.getSelectedElements(String.class)) {
                selected.addAll(this.getCertificatesByOrganization(s));
            }
        }
        Set<X509Certificate> set = selected;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/ssl/CertificateTreeBuilder", "getSelectedCertificates"));
        }
        return set;
    }

    @Nullable
    public X509Certificate getFirstSelectedCertificate(boolean addFromOrganization) {
        Set<X509Certificate> certificates = this.getSelectedCertificates(addFromOrganization);
        return certificates.isEmpty() ? null : certificates.iterator().next();
    }

    @NotNull
    public List<X509Certificate> getCertificatesByOrganization(@NotNull String organizationName) {
        if (organizationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "organizationName", "com/intellij/util/net/ssl/CertificateTreeBuilder", "getCertificatesByOrganization"));
        }
        Collection wrappers = this.myCertificates.get((Object)organizationName);
        List<X509Certificate> list = CertificateTreeBuilder.extract(wrappers);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/ssl/CertificateTreeBuilder", "getCertificatesByOrganization"));
        }
        return list;
    }

    private static List<X509Certificate> extract(Collection<CertificateWrapper> wrappers) {
        return ContainerUtil.map(wrappers, (Function)new Function<CertificateWrapper, X509Certificate>(){

            public X509Certificate fun(CertificateWrapper wrapper) {
                return wrapper.getCertificate();
            }
        });
    }

    @Override
    protected Object transformElement(Object object) {
        if (object instanceof CertificateWrapper) {
            return ((CertificateWrapper)object).getCertificate();
        }
        return object;
    }

    @Override
    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        return super.isAutoExpandNode(nodeDescriptor) || nodeDescriptor instanceof OrganizationDescriptor;
    }

    static class CertificateDescriptor
    extends MyNodeDescriptor<CertificateWrapper> {
        private CertificateDescriptor(@Nullable NodeDescriptor parentDescriptor, @NotNull CertificateWrapper object) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/util/net/ssl/CertificateTreeBuilder$CertificateDescriptor", "<init>"));
            }
            super(parentDescriptor, object);
        }

        @Override
        protected void update(PresentationData presentation) {
            CertificateWrapper wrapper = (CertificateWrapper)this.getElement();
            SimpleTextAttributes attr = wrapper.isValid() ? SimpleTextAttributes.REGULAR_ATTRIBUTES : STRIKEOUT_ATTRIBUTES;
            presentation.addText(wrapper.getSubjectField(CertificateWrapper.CommonField.COMMON_NAME), attr);
        }
    }

    static class OrganizationDescriptor
    extends MyNodeDescriptor<String> {
        private OrganizationDescriptor(@Nullable NodeDescriptor parentDescriptor, @NotNull String object) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/util/net/ssl/CertificateTreeBuilder$OrganizationDescriptor", "<init>"));
            }
            super(parentDescriptor, object);
        }

        @Override
        protected void update(PresentationData presentation) {
            presentation.addText((String)this.getElement(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
    }

    static class RootDescriptor
    extends MyNodeDescriptor<Object> {
        public static final Object ROOT = new Object();

        private RootDescriptor() {
            super(null, ROOT);
        }

        @Override
        protected void update(PresentationData presentation) {
            presentation.addText("<root>", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    static abstract class MyNodeDescriptor<T>
    extends PresentableNodeDescriptor<T> {
        private final T myObject;

        MyNodeDescriptor(@Nullable NodeDescriptor parentDescriptor, @NotNull T object) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/util/net/ssl/CertificateTreeBuilder$MyNodeDescriptor", "<init>"));
            }
            super(null, parentDescriptor);
            this.myObject = object;
        }

        @Override
        public T getElement() {
            return this.myObject;
        }
    }

    class MyTreeStructure
    extends AbstractTreeStructure {
        MyTreeStructure() {
        }

        @Override
        public Object getRootElement() {
            return RootDescriptor.ROOT;
        }

        @Override
        public Object[] getChildElements(Object element) {
            if (element == RootDescriptor.ROOT) {
                return ArrayUtil.toStringArray((Collection)CertificateTreeBuilder.this.myCertificates.keySet());
            }
            if (element instanceof String) {
                return ArrayUtil.toObjectArray((Collection)CertificateTreeBuilder.this.myCertificates.get((Object)((String)element)));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        @Override
        @Nullable
        public Object getParentElement(Object element) {
            if (element == RootDescriptor.ROOT) {
                return null;
            }
            if (element instanceof String) {
                return RootDescriptor.ROOT;
            }
            return ((CertificateWrapper)element).getSubjectField(CertificateWrapper.CommonField.ORGANIZATION);
        }

        @Override
        @NotNull
        public NodeDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
            if (element == RootDescriptor.ROOT) {
                RootDescriptor rootDescriptor = ROOT_DESCRIPTOR;
                if (rootDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/ssl/CertificateTreeBuilder$MyTreeStructure", "createDescriptor"));
                }
                return rootDescriptor;
            }
            if (element instanceof String) {
                OrganizationDescriptor organizationDescriptor = new OrganizationDescriptor(parentDescriptor, (String)element);
                if (organizationDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/ssl/CertificateTreeBuilder$MyTreeStructure", "createDescriptor"));
                }
                return organizationDescriptor;
            }
            CertificateDescriptor certificateDescriptor = new CertificateDescriptor(parentDescriptor, (CertificateWrapper)element);
            if (certificateDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/ssl/CertificateTreeBuilder$MyTreeStructure", "createDescriptor"));
            }
            return certificateDescriptor;
        }

        @Override
        public void commit() {
        }

        @Override
        public boolean hasSomethingToCommit() {
            return false;
        }
    }
}

