/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.frame;

import com.intellij.util.ThreeState;
import com.intellij.xdebugger.evaluation.XInstanceEvaluator;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XReferrersProvider;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public abstract class XValue
extends XValueContainer {
    public abstract void computePresentation(@NotNull XValueNode var1, @NotNull XValuePlace var2);

    @Nullable
    public String getEvaluationExpression() {
        return null;
    }

    @NotNull
    public Promise<String> calculateEvaluationExpression() {
        Promise<String> promise = Promise.resolve(this.getEvaluationExpression());
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/frame/XValue", "calculateEvaluationExpression"));
        }
        return promise;
    }

    @Nullable
    public XInstanceEvaluator getInstanceEvaluator() {
        return null;
    }

    @Nullable
    public XValueModifier getModifier() {
        return null;
    }

    public void computeSourcePosition(@NotNull XNavigatable navigatable) {
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/intellij/xdebugger/frame/XValue", "computeSourcePosition"));
        }
        navigatable.setSourcePosition(null);
    }

    @NotNull
    public ThreeState computeInlineDebuggerData(@NotNull XInlineDebuggerDataCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/xdebugger/frame/XValue", "computeInlineDebuggerData"));
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/frame/XValue", "computeInlineDebuggerData"));
        }
        return threeState;
    }

    public boolean canNavigateToSource() {
        return true;
    }

    public boolean canNavigateToTypeSource() {
        return false;
    }

    public void computeTypeSourcePosition(@NotNull XNavigatable navigatable) {
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/intellij/xdebugger/frame/XValue", "computeTypeSourcePosition"));
        }
        navigatable.setSourcePosition(null);
    }

    @Nullable
    public XReferrersProvider getReferrersProvider() {
        return null;
    }
}

