/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetElementImplStub;

public final class JetStubbedPsiUtil {
    @Nullable
    public static JetDeclaration getContainingDeclaration(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/JetStubbedPsiUtil", "getContainingDeclaration"));
        }
        return JetStubbedPsiUtil.getPsiOrStubParent(element, JetDeclaration.class, true);
    }

    @Nullable
    public static <T extends JetDeclaration> T getContainingDeclaration(@NotNull PsiElement element, @NotNull Class<T> declarationClass) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/JetStubbedPsiUtil", "getContainingDeclaration"));
        }
        if (declarationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationClass", "org/jetbrains/kotlin/psi/JetStubbedPsiUtil", "getContainingDeclaration"));
        }
        return (T)((JetDeclaration)JetStubbedPsiUtil.getPsiOrStubParent(element, declarationClass, true));
    }

    @Nullable
    public static <T extends JetElement> T getPsiOrStubParent(@NotNull PsiElement element, @NotNull Class<T> declarationClass, boolean strict) {
        Object stub;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/JetStubbedPsiUtil", "getPsiOrStubParent"));
        }
        if (declarationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationClass", "org/jetbrains/kotlin/psi/JetStubbedPsiUtil", "getPsiOrStubParent"));
        }
        if (!strict && declarationClass.isInstance(element)) {
            return (T)((JetElement)element);
        }
        if (element instanceof JetElementImplStub && (stub = ((JetElementImplStub)element).getStub()) != null) {
            return (T)((JetElement)stub.getParentStubOfType(declarationClass));
        }
        return (T)((JetElement)PsiTreeUtil.getParentOfType(element, declarationClass, strict));
    }

    @Nullable
    public static <T extends JetElement> T getStubOrPsiChild(@NotNull JetElementImplStub<?> element, @NotNull TokenSet types, @NotNull ArrayFactory<T> factory) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/JetStubbedPsiUtil", "getStubOrPsiChild"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/psi/JetStubbedPsiUtil", "getStubOrPsiChild"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/psi/JetStubbedPsiUtil", "getStubOrPsiChild"));
        }
        JetElement[] typeElements = (JetElement[])element.getStubOrPsiChildren(types, factory);
        if (typeElements.length == 0) {
            return null;
        }
        return (T)typeElements[0];
    }

    private JetStubbedPsiUtil() {
    }
}

