/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import java.io.InputStream;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.SerializedResourcePaths;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.DeserializedPackageFragment;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"]\u0006)q\"+Z:pkJ\u001cW\rT8bI&twm\u00117bgN$\u0015\r^1GS:$WM\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*i1/\u001a:jC2L'0\u0019;j_:Tq\u0002Z3tKJL\u0017\r\\5{CRLwN\u001c\u0006\u0010\u00072\f7o\u001d#bi\u00064\u0015N\u001c3fe*1A(\u001b8jizRq\u0003]1dW\u0006<WM\u0012:bO6,g\u000e\u001e)s_ZLG-\u001a:\u000b/A\u000b7m[1hK\u001a\u0013\u0018mZ7f]R\u0004&o\u001c<jI\u0016\u0014(b\u00033fg\u000e\u0014\u0018\u000e\u001d;peNTqc]3sS\u0006d\u0017N_3e%\u0016\u001cx.\u001e:dKB\u000bG\u000f[:\u000b/M+'/[1mSj,GMU3t_V\u00148-\u001a)bi\"\u001c(\u0002\u00047pC\u0012\u0014Vm]8ve\u000e,'\"\u0003$v]\u000e$\u0018n\u001c82\u0015\u0019\u0019FO]5oO*Y\u0011J\u001c9viN#(/Z1n\u0015\u0011Q\u0017M^1\u000b\u0005%|'b\u00016w[*Ia-\u001e8di&|gn\u001d\u0006\u000eM&tGm\u00117bgN$\u0015\r^1\u000b\u000f\rd\u0017m]:JI*91\t\\1tg&#'\u0002\u00028b[\u0016T\u0011b\u00117bgN$\u0015\r^1)\u0004)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011QA\u0001C\u0002\u0011\u000b)1\u0001\u0002\u0002\t\u00011\u0001Qa\u0001\u0003\u0003\u0011\ra\u0001!\u0002\u0002\u0005\u0003!)Qa\u0001C\u0004\u0011\u0013a\u0001!B\u0002\u0005\u0004!1A\u0002A\u0003\u0002\u0011\u0007)1\u0001B\u0003\t\u000f1\u0001Qa\u0001\u0003\u0006\u0011\u001fa\u0001!B\u0001\t\u0012\u0015\u0011AQ\u0002\u0005\n\u000b\r!q\u0001\u0003\u0005\r\u0001\u0015\u0011Aq\u0001E\u0005\u000b\t!\u0019\u0001\u0003\u0004\u0006\u0005\u0011)\u00012C\u0003\u0003\t%A!\"\u0002\u0002\u0005\u0014!9QA\u0001\u0003\u0002\u00111)1\u0001\"\u0006\t\u00181\u0001Qa\u0001C\u0002\u00113a\u0001!\u0002\u0002\u0005\u0004!eQA\u0001C\u000b\u0011/!1\u0002$\u0002\u001a\u0005\u0015\t\u0001bA\u0017\u0015\t\u0005$\u0001TB\u0011\f\u000b\u0005AY!C\u0002\n\u0005\u0015\t\u0001BB\u0005\u0005\u0013\r)\u0011\u0001c\u0004\r\u0002U\u001bA!B\u0002\u0005\u000e%\t\u0001BC\u0017\f\t\u0005$\u0001\u0004B\u0011\u0003\u000b\u0005AA!V\u0002\u0005\u000b\r!A!C\u0001\t\u00115ZA!\u0019\u0003\u0019\f\u0005\u0012Q!\u0001E\u0005+\u000e!Qa\u0001C\u0006\u0013\u0005A\t\"\f\u000b\u0005\u0017aUQT\u0002\u0003\u0001\u0011-i!!B\u0001\t\u0017A\u001b\u0001!I\u0002\u0006\u0003!]A\u0012A)\u0004\u000b\u0011U\u0011\"\u0001\u0005\r\u001b\u0005AI\".\u0019\u0006`\u0011\u0019\u000f\u0001g\u0002\u001e\u000e\u0011\u0001\u0001\u0002B\u0007\u0003\u000b\u0005AA\u0001U\u0002\u0001;\u001b!\u0001\u0001c\u0003\u000e\u0005\u0015\t\u0001\u0012\u0002)\u0004\u0002u}A\u0001\u0001E\u0007\u001b-)\u0011\u0001c\u0003\n\u0007%\u0011Q!\u0001\u0005\u0007\u0013\u0011I1!B\u0001\t\u00101\u0005\u0001kA\u0001\"\u0005\u0015\t\u0001RA)\u0004\u0013\u0011\u001d\u0011\"\u0001\u0003\u0001\u001b\u0005A\u0001\"D\u0001\t\u00125\t\u0001B\u0003"})
public class ResourceLoadingClassDataFinder
implements ClassDataFinder {
    public static final /* synthetic */ KClass $kotlinClass;
    private final PackageFragmentProvider packageFragmentProvider;
    private final SerializedResourcePaths serializedResourcePaths;
    private final Function1<? super String, ? extends InputStream> loadResource;

    static {
        $kotlinClass = Reflection.createKotlinClass(ResourceLoadingClassDataFinder.class);
    }

    @Override
    @Nullable
    public ClassData findClassData(@JetValueParameter(name="classId") @NotNull ClassId classId) {
        DeserializedPackageFragment deserializedPackageFragment;
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "classId.getPackageFqName()");
        PackageFragmentDescriptor packageFragmentDescriptor = KotlinPackage.singleOrNull(this.packageFragmentProvider.getPackageFragments(fqName2));
        if (packageFragmentDescriptor == null) {
            return null;
        }
        PackageFragmentDescriptor packageFragment = packageFragmentDescriptor;
        InputStream inputStream = this.loadResource.invoke(this.serializedResourcePaths.getClassMetadataPath(classId));
        if (inputStream == null) {
            return null;
        }
        InputStream stream = inputStream;
        ProtoBuf.Class classProto = ProtoBuf.Class.parseFrom(stream, this.serializedResourcePaths.getEXTENSION_REGISTRY());
        PackageFragmentDescriptor packageFragmentDescriptor2 = packageFragment;
        if (!(packageFragmentDescriptor2 instanceof DeserializedPackageFragment)) {
            packageFragmentDescriptor2 = null;
        }
        if ((deserializedPackageFragment = (DeserializedPackageFragment)packageFragmentDescriptor2) == null) {
            deserializedPackageFragment = (DeserializedPackageFragment)((Object)KotlinPackage.error("Not a deserialized package fragment: " + packageFragment));
        }
        NameResolver nameResolver = deserializedPackageFragment.getNameResolver();
        Name expectedShortName = classId.getShortClassName();
        Name actualShortName = nameResolver.getClassId(classProto.getFqName()).getShortClassName();
        if (!actualShortName.isSpecial() && Intrinsics.areEqual(actualShortName, expectedShortName) ^ true) {
            return null;
        }
        return new ClassData(nameResolver, classProto);
    }

    public ResourceLoadingClassDataFinder(@JetValueParameter(name="packageFragmentProvider") @NotNull PackageFragmentProvider packageFragmentProvider, @JetValueParameter(name="serializedResourcePaths") @NotNull SerializedResourcePaths serializedResourcePaths, @JetValueParameter(name="loadResource") @NotNull Function1<? super String, ? extends InputStream> loadResource) {
        Intrinsics.checkParameterIsNotNull(packageFragmentProvider, "packageFragmentProvider");
        Intrinsics.checkParameterIsNotNull(serializedResourcePaths, "serializedResourcePaths");
        Intrinsics.checkParameterIsNotNull(loadResource, "loadResource");
        this.packageFragmentProvider = packageFragmentProvider;
        this.serializedResourcePaths = serializedResourcePaths;
        this.loadResource = loadResource;
    }
}

