/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit4;

import com.intellij.junit4.ExpectedPatterns;
import com.intellij.junit4.JUnit4ReflectionUtil;
import com.intellij.rt.execution.junit.ComparisonFailureData;
import com.intellij.rt.execution.junit.MapSerializerUtil;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class JUnit4TestListener
extends RunListener {
    private static final String MESSAGE_LENGTH_FOR_PATTERN_MATCHING = "idea.junit.message.length.threshold";
    private static final String JUNIT_FRAMEWORK_COMPARISON_NAME = (class$junit$framework$ComparisonFailure == null ? (class$junit$framework$ComparisonFailure = JUnit4TestListener.class$("junit.framework.ComparisonFailure")) : class$junit$framework$ComparisonFailure).getName();
    private static final String ORG_JUNIT_COMPARISON_NAME = "org.junit.ComparisonFailure";
    public static final String EMPTY_SUITE_NAME = "junit.framework.TestSuite$1";
    public static final String EMPTY_SUITE_WARNING = "warning";
    private List myStartedSuites = new ArrayList();
    private Map myParents = new HashMap();
    private Map myMethodNames = new HashMap();
    private final PrintStream myPrintStream;
    private String myRootName;
    private long myCurrentTestStart;
    static /* synthetic */ Class class$junit$framework$ComparisonFailure;
    static /* synthetic */ Class class$org$junit$Ignore;

    public JUnit4TestListener() {
        this.myPrintStream = System.out;
    }

    public JUnit4TestListener(PrintStream printStream) {
        this.myPrintStream = printStream;
    }

    private static String escapeName(String str) {
        return MapSerializerUtil.escapeStr(str, MapSerializerUtil.STD_ESCAPER);
    }

    public void testRunStarted(Description description) throws Exception {
        this.myPrintStream.println("##teamcity[enteredTheMatrix]");
        if (this.myRootName != null && !this.myRootName.startsWith("[")) {
            int lastPointIdx = this.myRootName.lastIndexOf(46);
            String name = this.myRootName;
            String comment = null;
            if (lastPointIdx >= 0) {
                name = this.myRootName.substring(lastPointIdx + 1);
                comment = this.myRootName.substring(0, lastPointIdx);
            }
            this.myPrintStream.println("##teamcity[rootName name = '" + JUnit4TestListener.escapeName(name) + (comment != null ? "' comment = '" + JUnit4TestListener.escapeName(comment) : "") + "'" + " location = 'java:suite://" + JUnit4TestListener.escapeName(this.myRootName) + "']");
            this.myRootName = JUnit4TestListener.getShortName(this.myRootName);
        }
    }

    public void testRunFinished(Result result) throws Exception {
        for (int i = this.myStartedSuites.size() - 1; i >= 0; --i) {
            String parent = JUnit4ReflectionUtil.getClassName((Description)this.myStartedSuites.get(i));
            this.myPrintStream.println("##teamcity[testSuiteFinished name='" + JUnit4TestListener.escapeName(JUnit4TestListener.getShortName(parent)) + "']");
        }
        this.myStartedSuites.clear();
    }

    public void testStarted(Description description) throws Exception {
        int i;
        Description currentClass;
        int idx;
        String classFQN = JUnit4ReflectionUtil.getClassName(description);
        List parents = (List)this.myParents.get(description);
        List parentsHierarchy = parents != null && !parents.isEmpty() ? (List)parents.remove(0) : Collections.singletonList(description);
        String methodName = this.getFullMethodName(description, parentsHierarchy.isEmpty() ? null : (Description)parentsHierarchy.get(parentsHierarchy.size() - 1));
        if (methodName == null) {
            return;
        }
        for (idx = 0; idx < this.myStartedSuites.size() && idx < parentsHierarchy.size(); ++idx) {
            currentClass = (Description)this.myStartedSuites.get(idx);
            Description currentParent = (Description)parentsHierarchy.get(parentsHierarchy.size() - 1 - idx);
            if (System.identityHashCode(currentClass) != System.identityHashCode(currentParent)) break;
        }
        for (i = this.myStartedSuites.size() - 1; i >= idx; --i) {
            currentClass = (Description)this.myStartedSuites.remove(i);
            this.myPrintStream.println("##teamcity[testSuiteFinished name='" + JUnit4TestListener.escapeName(JUnit4TestListener.getShortName(JUnit4ReflectionUtil.getClassName(currentClass))) + "']");
        }
        for (i = idx; i < parentsHierarchy.size(); ++i) {
            Description descriptionFromHistory = (Description)parentsHierarchy.get(parentsHierarchy.size() - 1 - i);
            String fqName = JUnit4ReflectionUtil.getClassName(descriptionFromHistory);
            String className = JUnit4TestListener.getShortName(fqName);
            if (className.equals(this.myRootName)) continue;
            this.myPrintStream.println("##teamcity[testSuiteStarted name='" + JUnit4TestListener.escapeName(className) + "'" + (parents == null ? " locationHint='java:suite://" + JUnit4TestListener.escapeName(fqName) + "'" : "") + "]");
            this.myStartedSuites.add(descriptionFromHistory);
        }
        this.myPrintStream.println("##teamcity[testStarted name='" + JUnit4TestListener.escapeName(methodName) + "' " + JUnit4TestListener.getTestMethodLocation(methodName, classFQN) + "]");
        this.myCurrentTestStart = this.currentTime();
    }

    protected long currentTime() {
        return System.currentTimeMillis();
    }

    public void testFinished(Description description) throws Exception {
        String methodName = this.getFullMethodName(description);
        if (methodName != null) {
            long duration = this.currentTime() - this.myCurrentTestStart;
            this.myPrintStream.println("\n##teamcity[testFinished name='" + JUnit4TestListener.escapeName(methodName) + (duration > 0L ? "' duration='" + Long.toString(duration) : "") + "']");
        }
    }

    public void testFailure(Failure failure) throws Exception {
        this.testFailure(failure, failure.getDescription(), "testFailed", true);
    }

    private void testFailure(Failure failure, Description description, String messageName, boolean local) throws Exception {
        String methodName = this.getFullMethodName(description);
        if (methodName == null) {
            Iterator iterator = description.getChildren().iterator();
            while (iterator.hasNext()) {
                this.testFailure(failure, (Description)iterator.next(), messageName, false);
            }
        } else {
            if (!local) {
                this.testStarted(description);
            }
            this.testFailure(failure, messageName, methodName);
            if (!local) {
                this.testFinished(description);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFailure(Failure failure, String messageName, String methodName) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("name", methodName);
        long duration = this.currentTime() - this.myCurrentTestStart;
        if (duration > 0L) {
            attrs.put("duration", Long.toString(duration));
        }
        try {
            String trace = this.getTrace(failure);
            Throwable ex = failure.getException();
            ComparisonFailureData notification = JUnit4TestListener.createExceptionNotification(ex);
            ComparisonFailureData.registerSMAttributes((ComparisonFailureData)notification, (String)trace, (String)failure.getMessage(), attrs, (Throwable)ex);
        }
        catch (Throwable e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(stringWriter);
            e.printStackTrace(writer);
            ComparisonFailureData.registerSMAttributes(null, (String)stringWriter.toString(), (String)e.getMessage(), attrs, (Throwable)e);
        }
        finally {
            this.myPrintStream.println("\n" + MapSerializerUtil.asString(messageName, attrs));
        }
    }

    protected String getTrace(Failure failure) {
        return failure.getTrace();
    }

    public void testAssumptionFailure(Failure failure) {
        Description description = failure.getDescription();
        try {
            this.testFailure(failure, description, "testIgnored", true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getFullMethodName(Description description) {
        return this.getFullMethodName(description, null);
    }

    private String getFullMethodName(Description description, Description parent) {
        String methodName = (String)this.myMethodNames.get(description);
        if (methodName == null) {
            methodName = JUnit4ReflectionUtil.getMethodName(description);
            if (!(methodName == null || parent != null && JUnit4TestListener.isParameter(parent))) {
                methodName = JUnit4TestListener.getShortName(JUnit4ReflectionUtil.getClassName(description)) + "." + methodName;
            }
            this.myMethodNames.put(description, methodName);
        }
        return methodName;
    }

    public synchronized void testIgnored(Description description) throws Exception {
        String methodName = this.getFullMethodName(description);
        if (methodName == null) {
            Iterator iterator = description.getChildren().iterator();
            while (iterator.hasNext()) {
                Description testDescription = (Description)iterator.next();
                this.testIgnored(testDescription, this.getFullMethodName(testDescription));
            }
        } else {
            this.testIgnored(description, methodName);
        }
    }

    private void testIgnored(Description description, String methodName) throws Exception {
        this.testStarted(description);
        HashMap<String, String> attrs = new HashMap<String, String>();
        try {
            String val;
            Ignore ignoredAnnotation = (Ignore)description.getAnnotation(class$org$junit$Ignore == null ? (class$org$junit$Ignore = JUnit4TestListener.class$("org.junit.Ignore")) : class$org$junit$Ignore);
            if (ignoredAnnotation != null && (val = ignoredAnnotation.value()) != null) {
                attrs.put("message", val);
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        attrs.put("name", methodName);
        this.myPrintStream.println(MapSerializerUtil.asString("testIgnored", attrs));
        this.testFinished(description);
    }

    private static boolean isComparisonFailure(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        return JUnit4TestListener.isComparisonFailure(throwable.getClass());
    }

    private static boolean isComparisonFailure(Class aClass) {
        if (aClass == null) {
            return false;
        }
        String throwableClassName = aClass.getName();
        if (throwableClassName.equals(JUNIT_FRAMEWORK_COMPARISON_NAME) || throwableClassName.equals(ORG_JUNIT_COMPARISON_NAME)) {
            return true;
        }
        return JUnit4TestListener.isComparisonFailure(aClass.getSuperclass());
    }

    static ComparisonFailureData createExceptionNotification(Throwable assertion) {
        if (JUnit4TestListener.isComparisonFailure(assertion)) {
            return ComparisonFailureData.create((Throwable)assertion);
        }
        try {
            Throwable cause = assertion.getCause();
            if (JUnit4TestListener.isComparisonFailure(cause)) {
                return ComparisonFailureData.create((Throwable)cause);
            }
        }
        catch (Throwable cause) {
            // empty catch block
        }
        String message = assertion.getMessage();
        if (message != null && JUnit4TestListener.acceptedByThreshold(message.length())) {
            try {
                return ExpectedPatterns.createExceptionNotification(message);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean acceptedByThreshold(int messageLength) {
        int threshold = 10000;
        try {
            String property = System.getProperty(MESSAGE_LENGTH_FOR_PATTERN_MATCHING);
            if (property != null) {
                try {
                    threshold = Integer.parseInt(property);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return messageLength < threshold;
    }

    private void sendTree(Description description, Description parent, List currentParents) {
        String parentClassName;
        ArrayList<Description> pParents = new ArrayList<Description>(3);
        pParents.addAll(currentParents);
        if (parent != null && !this.myRootName.equals(parentClassName = JUnit4ReflectionUtil.getClassName(parent))) {
            pParents.add(0, parent);
        }
        String className = JUnit4ReflectionUtil.getClassName(description);
        if (description.getChildren().isEmpty()) {
            String methodName = this.getFullMethodName(description, parent);
            if (methodName != null) {
                if (parent != null) {
                    ArrayList parents = (ArrayList)this.myParents.get(description);
                    if (parents == null) {
                        parents = new ArrayList(1);
                        this.myParents.put(description, parents);
                    }
                    parents.add(pParents);
                }
                if (JUnit4TestListener.isWarning(methodName, className)) {
                    className = JUnit4ReflectionUtil.getClassName(parent);
                }
                this.myPrintStream.println("##teamcity[suiteTreeNode name='" + JUnit4TestListener.escapeName(methodName) + "' " + JUnit4TestListener.getTestMethodLocation(methodName, className) + "]");
            }
            return;
        }
        ArrayList tests = description.getChildren();
        boolean pass = false;
        Iterator iterator = tests.iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            Description nextDescription = (Description)next;
            if (!(this.myRootName != null && this.myRootName.equals(className) || pass)) {
                String displayName;
                int paramIdx;
                pass = true;
                String locationHint = className;
                if (JUnit4TestListener.isParameter(description) && (paramIdx = (displayName = nextDescription.getDisplayName()).indexOf(locationHint)) > -1 && (locationHint = displayName.substring(paramIdx + locationHint.length())).startsWith("(") && locationHint.endsWith(")")) {
                    locationHint = locationHint.substring(1, locationHint.length() - 1) + "." + className;
                }
                this.myPrintStream.println("##teamcity[suiteTreeStarted name='" + JUnit4TestListener.escapeName(JUnit4TestListener.getShortName(className)) + "' locationHint='java:suite://" + JUnit4TestListener.escapeName(locationHint) + "']");
            }
            this.sendTree(nextDescription, description, pParents);
        }
        if (pass) {
            this.myPrintStream.println("##teamcity[suiteTreeEnded name='" + JUnit4TestListener.escapeName(JUnit4TestListener.getShortName(JUnit4ReflectionUtil.getClassName(description))) + "']");
        }
    }

    private static boolean isWarning(String methodName, String className) {
        return EMPTY_SUITE_WARNING.equals(methodName) && EMPTY_SUITE_NAME.equals(className);
    }

    private static String getTestMethodLocation(String methodName, String className) {
        return "locationHint='java:test://" + JUnit4TestListener.escapeName(className + "." + JUnit4TestListener.getShortName(methodName)) + "'";
    }

    private static boolean isParameter(Description description) {
        String displayName = description.getDisplayName();
        return displayName.startsWith("[") && displayName.endsWith("]");
    }

    public void sendTree(Description description) {
        this.myRootName = JUnit4ReflectionUtil.getClassName(description);
        this.sendTree(description, null, new ArrayList());
    }

    private static String getShortName(String fqName) {
        if (fqName == null) {
            return null;
        }
        int idx = fqName.indexOf("[");
        if (idx == 0) {
            return fqName;
        }
        int lastPointIdx = fqName.lastIndexOf(46);
        if (idx > 0 && fqName.endsWith("]")) {
            lastPointIdx = fqName.substring(0, idx).lastIndexOf(46);
        }
        if (lastPointIdx >= 0) {
            return fqName.substring(lastPointIdx + 1);
        }
        return fqName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

