/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PreferenceStore {
    private String myFilename;
    private boolean myChanged = false;
    private final Properties myProperties = new Properties();

    public PreferenceStore() {
        this.myFilename = null;
    }

    public PreferenceStore(String filename) {
        this.myFilename = filename;
    }

    public void load() throws IOException {
        if (this.myFilename == null) {
            throw new IOException("No filename specified for PreferenceStore.");
        }
        FileInputStream in = new FileInputStream(this.myFilename);
        try {
            this.myProperties.load(in);
            this.myChanged = false;
        }
        finally {
            in.close();
        }
    }

    public void save() throws IOException {
        if (this.myFilename == null) {
            throw new IOException("No filename specified for PreferenceStore.");
        }
        if (this.myChanged) {
            FileOutputStream out = new FileOutputStream(this.myFilename);
            try {
                this.save(out, null);
                this.myChanged = false;
            }
            finally {
                out.close();
            }
        }
    }

    public void save(FileOutputStream outputStream, @Nullable String header) throws IOException {
        this.myProperties.store(outputStream, header);
    }

    public boolean contains(String key) {
        return this.myProperties.containsKey(key);
    }

    public long getLong(String key) {
        try {
            return Long.parseLong(this.myProperties.getProperty(key));
        }
        catch (Exception ignored) {
            return 0L;
        }
    }

    public boolean getBoolean(String key) {
        try {
            return Boolean.parseBoolean(this.myProperties.getProperty(key));
        }
        catch (Exception ignored) {
            return false;
        }
    }

    @NotNull
    public String getString(String key) {
        String s = this.myProperties.getProperty(key);
        String string = s == null ? "" : s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/stats/PreferenceStore", "getString"));
        }
        return string;
    }

    public void setValue(String key, long value) {
        this.myProperties.setProperty(key, Long.toString(value));
        this.myChanged = true;
    }

    public void setValue(String key, boolean value) {
        this.myProperties.setProperty(key, Boolean.toString(value));
        this.myChanged = true;
    }

    public void setValue(String key, String value) {
        this.myProperties.setProperty(key, value);
        this.myChanged = true;
    }
}

