/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.tools.idea.sdk.DefaultSdks;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.welcome.FirstRunWizardMode;
import com.android.tools.idea.welcome.FirstRunWizardStep;
import com.android.tools.idea.welcome.InstallableComponent;
import com.android.tools.idea.welcome.WelcomeUIUtils;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.android.tools.idea.wizard.WizardUtils;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.Set;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkComponentsStep
extends FirstRunWizardStep {
    public static final String FIELD_SDK_LOCATION = "SDK location";
    private final InstallableComponent[] myInstallableComponents;
    @NotNull
    private final FirstRunWizardMode myMode;
    @NotNull
    private final ScopedStateStore.Key<Boolean> myKeyCustomInstall;
    private JPanel myContents;
    private JBTable myComponentsTable;
    private JTextPane myComponentDescription;
    private JLabel myNeededSpace;
    private JLabel myAvailableSpace;
    private JLabel myErrorMessage;
    private ScopedStateStore.Key<String> mySdkDownloadPathKey;
    private TextFieldWithBrowseButton myPath;
    private JPanel myBody;
    private boolean myUserEditedPath;

    public SdkComponentsStep(@NotNull InstallableComponent[] components, @NotNull ScopedStateStore.Key<Boolean> keyCustomInstall, @NotNull ScopedStateStore.Key<String> sdkDownloadPathKey, @NotNull FirstRunWizardMode mode) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/welcome/SdkComponentsStep", "<init>"));
        }
        if (keyCustomInstall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyCustomInstall", "com/android/tools/idea/welcome/SdkComponentsStep", "<init>"));
        }
        if (sdkDownloadPathKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkDownloadPathKey", "com/android/tools/idea/welcome/SdkComponentsStep", "<init>"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/android/tools/idea/welcome/SdkComponentsStep", "<init>"));
        }
        super("SDK Components Setup");
        this.myUserEditedPath = false;
        this.myMode = mode;
        this.myKeyCustomInstall = keyCustomInstall;
        this.$$$setupUI$$$();
        this.myPath.addBrowseFolderListener("Android SDK", "Select Android SDK install directory", null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.mySdkDownloadPathKey = sdkDownloadPathKey;
        Font labelFont = UIUtil.getLabelFont();
        Font smallLabelFont = labelFont.deriveFont((float)labelFont.getSize() - 1.0f);
        this.myNeededSpace.setFont(smallLabelFont);
        this.myAvailableSpace.setFont(smallLabelFont);
        this.myErrorMessage.setText(null);
        this.myErrorMessage.setForeground((Color)JBColor.red);
        this.myInstallableComponents = components;
        DefaultTableModel model = new DefaultTableModel(0, 1){

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                boolean isSelected = (Boolean)aValue;
                InstallableComponent installableComponent = SdkComponentsStep.this.myInstallableComponents[row];
                if (isSelected) {
                    SdkComponentsStep.this.select(installableComponent);
                } else {
                    SdkComponentsStep.this.deselect(installableComponent);
                }
                this.fireTableRowsUpdated(row, row);
            }
        };
        for (InstallableComponent installableComponent : this.myInstallableComponents) {
            model.addRow(new Object[]{installableComponent});
        }
        this.myComponentsTable.setModel((TableModel)model);
        this.myComponentsTable.setTableHeader(null);
        this.myComponentsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selected = SdkComponentsStep.this.myComponentsTable.getSelectedRow();
                String description = selected >= 0 ? SdkComponentsStep.this.myInstallableComponents[selected].getDescription() : null;
                SdkComponentsStep.this.myComponentDescription.setText(description);
            }
        });
        TableColumn column = this.myComponentsTable.getColumnModel().getColumn(0);
        column.setCellRenderer(new SdkComponentRenderer());
        column.setCellEditor(new SdkComponentRenderer());
        this.setComponent(this.myContents);
    }

    private static boolean isChild(@Nullable InstallableComponent child, @NotNull InstallableComponent installableComponent) {
        if (installableComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installableComponent", "com/android/tools/idea/welcome/SdkComponentsStep", "isChild"));
        }
        return child != null && (child == installableComponent || SdkComponentsStep.isChild(child.getParent(), installableComponent));
    }

    @Nullable
    private static File getExistingParentFile(@Nullable String path) {
        File file;
        if (StringUtil.isEmpty((String)path)) {
            return null;
        }
        for (file = new File(path).getAbsoluteFile(); file != null && !file.exists(); file = file.getParentFile()) {
        }
        return file;
    }

    private static String getDiskSpace(@Nullable String path) {
        File file = SdkComponentsStep.getTargetFilesystem(path);
        if (file == null) {
            return "";
        }
        String available = WelcomeUIUtils.getSizeLabel(file.getFreeSpace());
        if (SystemInfo.isWindows) {
            while (file.getParentFile() != null) {
                file = file.getParentFile();
            }
            return String.format("Disk space available on drive %s: %s", file.getName(), available);
        }
        return String.format("Available disk space: %s", available);
    }

    @Nullable
    private static File getTargetFilesystem(@Nullable String path) {
        File[] files;
        File file = SdkComponentsStep.getExistingParentFile(path);
        if (file == null && (files = File.listRoots()).length != 0) {
            file = files[0];
        }
        return file;
    }

    @Override
    public boolean validate() {
        boolean isOk;
        WizardUtils.ValidationResult error;
        String path = this.myState.get(this.mySdkDownloadPathKey);
        if (!StringUtil.isEmpty((String)path)) {
            this.myUserEditedPath = true;
        }
        String message = (error = WizardUtils.validateLocation(path, FIELD_SDK_LOCATION, false)).isOk() ? null : error.getFormattedMessage();
        boolean bl = isOk = !error.isError();
        if (isOk) {
            File file;
            File filesystem = SdkComponentsStep.getTargetFilesystem(path);
            if (filesystem != null && filesystem.getFreeSpace() <= this.getComponentsSize()) {
                isOk = false;
                message = "Target drive does not have enough free space";
            } else if (SdkComponentsStep.isNonEmptyNonSdk(path)) {
                isOk = true;
                message = "Target folder is neither empty nor does it point to an existing SDK installation.";
            } else if (!StringUtil.isEmptyOrSpaces((String)path) && (file = new File(path)).isDirectory() && DefaultSdks.isValidAndroidSdkPath(file)) {
                isOk = true;
                message = "An existing Android SDK was detected. The setup wizard will only download missing or outdated SDK components.";
            }
        }
        this.setErrorHtml(this.myUserEditedPath ? message : null);
        return isOk;
    }

    private static boolean isNonEmptyNonSdk(@Nullable String path) {
        if (path == null) {
            return false;
        }
        File file = new File(path);
        if (file.exists() && TemplateUtils.listFiles(file).length > 0) {
            return AndroidSdkData.getSdkData(file) == null;
        }
        return false;
    }

    @Override
    public void deriveValues(Set<ScopedStateStore.Key> modified) {
        for (int i = 0; i < this.myInstallableComponents.length; ++i) {
            ScopedStateStore.Key<Boolean> key = this.myInstallableComponents[i].getKey();
            if (!modified.contains(key)) continue;
            this.myComponentsTable.getModel().setValueAt(this.myState.getNotNull(key, true), i, 0);
        }
        this.myAvailableSpace.setText(SdkComponentsStep.getDiskSpace(this.myState.get(this.mySdkDownloadPathKey)));
        long selected = this.getComponentsSize();
        this.myNeededSpace.setText(String.format("Total disk space required: %s", WelcomeUIUtils.getSizeLabel(selected)));
        super.deriveValues(modified);
    }

    private long getComponentsSize() {
        long selected = 0L;
        for (InstallableComponent installableComponent : this.myInstallableComponents) {
            if (!this.isSelected(installableComponent)) continue;
            selected += installableComponent.getSize();
        }
        return selected;
    }

    private void deselect(InstallableComponent installableComponent) {
        for (InstallableComponent child : this.myInstallableComponents) {
            if (child.getSize() <= 0L || !SdkComponentsStep.isChild(child, installableComponent)) continue;
            this.myState.put(child.getKey(), false);
        }
    }

    private Iterable<InstallableComponent> getChildren(final InstallableComponent installableComponent) {
        return Iterables.filter(Arrays.asList(this.myInstallableComponents), (Predicate)new Predicate<InstallableComponent>(){

            public boolean apply(@Nullable InstallableComponent input) {
                assert (input != null);
                InstallableComponent n = input;
                do {
                    if (n != installableComponent) continue;
                    return true;
                } while ((n = n.getParent()) != null);
                return false;
            }
        });
    }

    private void select(InstallableComponent installableComponent) {
        for (InstallableComponent child : this.getChildren(installableComponent)) {
            this.myState.put(child.getKey(), true);
        }
    }

    @Override
    public void init() {
        this.register(this.mySdkDownloadPathKey, this.myPath);
        if (this.myInstallableComponents.length > 0) {
            this.myComponentsTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    @Override
    @NotNull
    public JLabel getMessageLabel() {
        JLabel jLabel = this.myErrorMessage;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/SdkComponentsStep", "getMessageLabel"));
        }
        return jLabel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myComponentsTable;
    }

    private boolean isSelected(InstallableComponent installableComponent) {
        for (InstallableComponent child : this.getChildren(installableComponent)) {
            if (this.myState.getNotNull(child.getKey(), true).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isStepVisible() {
        return !this.myMode.hasValidSdkLocation() && this.myState.getNotNull(this.myKeyCustomInstall, true) != false;
    }

    private void createUIComponents() {
        Splitter splitter = new Splitter(false, 0.5f, 0.2f, 0.8f);
        this.myBody = splitter;
        this.myComponentsTable = new JBTable();
        this.myComponentDescription = new JTextPane();
        splitter.setShowDividerIcon(false);
        splitter.setShowDividerControls(false);
        splitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myComponentsTable, (boolean)false));
        splitter.setSecondComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myComponentDescription, (boolean)false));
        this.myComponentDescription.setFont(UIUtil.getLabelFont());
        this.myComponentDescription.setEditable(false);
        this.myComponentDescription.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.createUIComponents();
        this.myContents = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Check the components you want to update/install. Click Next to continue.");
        jPanel.add((Component)jLabel4, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Android SDK Location:");
        jPanel.add((Component)jLabel5, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 0, 1, 1, 0, 1, 6, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(3, 1, 2, 1, 0, 3, 0, 3, null, null, null));
        this.myNeededSpace = jLabel3 = new JLabel();
        jLabel3.setText("Total disk space required: 5.1Gb");
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myAvailableSpace = jLabel2 = new JLabel();
        jLabel2.setText("Available disk space: 23.0Gb");
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myErrorMessage = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(5, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        JPanel jPanel3 = this.myBody;
        jPanel.add((Component)jPanel3, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContents;
    }

    private final class SdkComponentRenderer
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor {
        private final JPanel myPanel = new JPanel((LayoutManager)new GridLayoutManager(1, 1));
        private final JCheckBox myCheckBox = new JCheckBox();
        private Border myEmptyBorder;

        public SdkComponentRenderer() {
            this.myCheckBox.setOpaque(false);
            this.myCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SdkComponentRenderer.this.stopCellEditing();
                }
            });
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setupControl(table, value, isSelected, hasFocus);
            return this.myPanel;
        }

        private void setupControl(JTable table, Object value, boolean isSelected, boolean hasFocus) {
            Color foreground;
            Color background;
            this.myPanel.setBorder(this.getCellBorder(table, isSelected && hasFocus));
            if (isSelected) {
                background = table.getSelectionBackground();
                foreground = table.getSelectionForeground();
            } else {
                background = table.getBackground();
                foreground = table.getForeground();
            }
            this.myPanel.setBackground(background);
            this.myCheckBox.setForeground(foreground);
            this.myPanel.remove(this.myCheckBox);
            InstallableComponent installableComponent = (InstallableComponent)value;
            int indent = 0;
            if (installableComponent != null) {
                this.myCheckBox.setEnabled(installableComponent.isOptional());
                this.myCheckBox.setText(installableComponent.getLabel());
                this.myCheckBox.setSelected(SdkComponentsStep.this.isSelected((InstallableComponent)value));
                while (installableComponent.getParent() != null) {
                    ++indent;
                    installableComponent = installableComponent.getParent();
                }
            }
            this.myPanel.add((Component)this.myCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, indent * 2));
        }

        private Border getCellBorder(JTable table, boolean isSelectedFocus) {
            Border border;
            Border focusedBorder = UIUtil.getTableFocusCellHighlightBorder();
            if (isSelectedFocus) {
                border = focusedBorder;
            } else {
                if (this.myEmptyBorder == null) {
                    this.myEmptyBorder = new EmptyBorder(focusedBorder.getBorderInsets(table));
                }
                border = this.myEmptyBorder;
            }
            return border;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.setupControl(table, value, true, true);
            return this.myPanel;
        }

        @Override
        public Object getCellEditorValue() {
            return this.myCheckBox.isSelected();
        }
    }
}

