/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.AreaListener;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.LogProvider;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public class Extensions {
    public static final ExtensionPointName<AreaListener> AREA_LISTENER_EXTENSION_POINT = new ExtensionPointName("com.intellij.arealistener");
    private static LogProvider ourLogger = new SimpleLogProvider();
    private static final Map<AreaInstance, ExtensionsAreaImpl> ourAreaInstance2area = ContainerUtil.newConcurrentMap();
    private static final Map<String, AreaClassConfiguration> ourAreaClass2Configuration = ContainerUtil.newConcurrentMap();
    @NotNull
    private static ExtensionsAreaImpl ourRootArea = Extensions.createRootArea();

    private Extensions() {
    }

    @NotNull
    private static ExtensionsAreaImpl createRootArea() {
        ExtensionsAreaImpl rootArea = new ExtensionsAreaImpl(null, null, null, ourLogger);
        rootArea.registerExtensionPoint(AREA_LISTENER_EXTENSION_POINT.getName(), AreaListener.class.getName());
        ExtensionsAreaImpl extensionsAreaImpl = rootArea;
        if (extensionsAreaImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/Extensions", "createRootArea"));
        }
        return extensionsAreaImpl;
    }

    @NotNull
    public static ExtensionsArea getRootArea() {
        ExtensionsAreaImpl extensionsAreaImpl = ourRootArea;
        if (extensionsAreaImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/Extensions", "getRootArea"));
        }
        return extensionsAreaImpl;
    }

    @NotNull
    public static ExtensionsArea getArea(@Nullable AreaInstance areaInstance) {
        if (areaInstance == null) {
            ExtensionsAreaImpl extensionsAreaImpl = ourRootArea;
            if (extensionsAreaImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/Extensions", "getArea"));
            }
            return extensionsAreaImpl;
        }
        ExtensionsAreaImpl area = ourAreaInstance2area.get(areaInstance);
        if (area == null) {
            throw new IllegalArgumentException("No area instantiated for: " + areaInstance);
        }
        ExtensionsAreaImpl extensionsAreaImpl = area;
        if (extensionsAreaImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/Extensions", "getArea"));
        }
        return extensionsAreaImpl;
    }

    public static void cleanRootArea(@NotNull Disposable parentDisposable) {
        ExtensionsAreaImpl newArea;
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/extensions/Extensions", "cleanRootArea"));
        }
        final ExtensionsAreaImpl oldRootArea = (ExtensionsAreaImpl)Extensions.getRootArea();
        ourRootArea = newArea = Extensions.createRootArea();
        oldRootArea.notifyAreaReplaced();
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ourRootArea = oldRootArea;
                newArea.notifyAreaReplaced();
            }
        });
    }

    @NotNull
    public static Object[] getExtensions(@NonNls String extensionPointName) {
        Object[] objectArray = Extensions.getExtensions(extensionPointName, null);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/Extensions", "getExtensions"));
        }
        return objectArray;
    }

    @NotNull
    public static <T> T[] getExtensions(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointName", "com/intellij/openapi/extensions/Extensions", "getExtensions"));
        }
        T[] TArray = Extensions.getExtensions(extensionPointName.getName(), null);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/Extensions", "getExtensions"));
        }
        return TArray;
    }

    @NotNull
    public static <T> T[] getExtensions(@NotNull ExtensionPointName<T> extensionPointName, AreaInstance areaInstance) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointName", "com/intellij/openapi/extensions/Extensions", "getExtensions"));
        }
        T[] TArray = Extensions.getExtensions(extensionPointName.getName(), areaInstance);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/Extensions", "getExtensions"));
        }
        return TArray;
    }

    @NotNull
    public static <T> T[] getExtensions(String extensionPointName, @Nullable AreaInstance areaInstance) {
        ExtensionsArea area = Extensions.getArea(areaInstance);
        ExtensionPoint extensionPoint = area.getExtensionPoint(extensionPointName);
        T[] TArray = extensionPoint.getExtensions();
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/Extensions", "getExtensions"));
        }
        return TArray;
    }

    @NotNull
    public static <T, U extends T> U findExtension(@NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<U> extClass) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointName", "com/intellij/openapi/extensions/Extensions", "findExtension"));
        }
        if (extClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extClass", "com/intellij/openapi/extensions/Extensions", "findExtension"));
        }
        for (T t : Extensions.getExtensions(extensionPointName)) {
            if (!extClass.isInstance(t)) continue;
            T t2 = t;
            if (t2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/Extensions", "findExtension"));
            }
            return (U)t2;
        }
        throw new IllegalArgumentException("could not find extension implementation " + extClass);
    }

    @NotNull
    public static <T, U extends T> U findExtension(@NotNull ExtensionPointName<T> extensionPointName, AreaInstance areaInstance, @NotNull Class<U> extClass) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointName", "com/intellij/openapi/extensions/Extensions", "findExtension"));
        }
        if (extClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extClass", "com/intellij/openapi/extensions/Extensions", "findExtension"));
        }
        for (T t : Extensions.getExtensions(extensionPointName, areaInstance)) {
            if (!extClass.isInstance(t)) continue;
            T t2 = t;
            if (t2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/Extensions", "findExtension"));
            }
            return (U)t2;
        }
        throw new IllegalArgumentException("could not find extension implementation " + extClass);
    }

    public static void instantiateArea(@NonNls @NotNull String areaClass, @NotNull AreaInstance areaInstance, @Nullable AreaInstance parentAreaInstance) {
        if (areaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "areaClass", "com/intellij/openapi/extensions/Extensions", "instantiateArea"));
        }
        if (areaInstance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "areaInstance", "com/intellij/openapi/extensions/Extensions", "instantiateArea"));
        }
        AreaClassConfiguration configuration = ourAreaClass2Configuration.get(areaClass);
        if (configuration == null) {
            throw new IllegalArgumentException("Area class is not registered: " + areaClass);
        }
        ExtensionsArea parentArea = Extensions.getArea(parentAreaInstance);
        if (!Extensions.equals(parentArea.getAreaClass(), configuration.getParentClassName())) {
            throw new IllegalArgumentException("Wrong parent area. Expected class: " + configuration.getParentClassName() + " actual class: " + parentArea.getAreaClass());
        }
        ExtensionsAreaImpl area = new ExtensionsAreaImpl(areaClass, areaInstance, (PicoContainer)parentArea.getPicoContainer(), ourLogger);
        if (ourAreaInstance2area.put(areaInstance, area) != null) {
            throw new IllegalArgumentException("Area already instantiated for: " + areaInstance);
        }
        for (AreaListener listener : Extensions.getAreaListeners()) {
            listener.areaCreated(areaClass, areaInstance);
        }
    }

    @NotNull
    private static AreaListener[] getAreaListeners() {
        AreaListener[] areaListenerArray = Extensions.getRootArea().getExtensionPoint(AREA_LISTENER_EXTENSION_POINT).getExtensions();
        if (areaListenerArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/Extensions", "getAreaListeners"));
        }
        return areaListenerArray;
    }

    public static void registerAreaClass(@NonNls @NotNull String areaClass, @Nullable @NonNls String parentAreaClass) {
        if (areaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "areaClass", "com/intellij/openapi/extensions/Extensions", "registerAreaClass"));
        }
        if (ourAreaClass2Configuration.containsKey(areaClass)) {
            AreaClassConfiguration configuration = ourAreaClass2Configuration.get(areaClass);
            if (!Extensions.equals(configuration.getParentClassName(), parentAreaClass)) {
                throw new RuntimeException("Area class already registered: " + areaClass + ", " + configuration);
            }
            return;
        }
        AreaClassConfiguration configuration = new AreaClassConfiguration(areaClass, parentAreaClass);
        ourAreaClass2Configuration.put(areaClass, configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeArea(@NotNull AreaInstance areaInstance) {
        if (areaInstance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "areaInstance", "com/intellij/openapi/extensions/Extensions", "disposeArea"));
        }
        assert (ourAreaInstance2area.containsKey(areaInstance));
        String areaClass = ourAreaInstance2area.get(areaInstance).getAreaClass();
        if (areaClass == null) {
            throw new IllegalArgumentException("Area class is null (area never instantiated?). Instance: " + areaInstance);
        }
        try {
            for (AreaListener listener : Extensions.getAreaListeners()) {
                listener.areaDisposing(areaClass, areaInstance);
            }
        }
        finally {
            ourAreaInstance2area.remove(areaInstance);
        }
    }

    private static boolean equals(@Nullable Object object1, @Nullable Object object2) {
        return object1 == object2 || object1 != null && object2 != null && object1.equals(object2);
    }

    public static void setLogProvider(@NotNull LogProvider logProvider) {
        if (logProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logProvider", "com/intellij/openapi/extensions/Extensions", "setLogProvider"));
        }
        ourLogger = logProvider;
    }

    public static class SimpleLogProvider
    implements LogProvider {
        @Override
        public void error(String message) {
            new Throwable(message).printStackTrace();
        }

        @Override
        public void error(String message, @NotNull Throwable t) {
            if (t == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/openapi/extensions/Extensions$SimpleLogProvider", "error"));
            }
            System.err.println(message);
            t.printStackTrace();
        }

        @Override
        public void error(@NotNull Throwable t) {
            if (t == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/openapi/extensions/Extensions$SimpleLogProvider", "error"));
            }
            t.printStackTrace();
        }

        @Override
        public void warn(String message) {
            System.err.println(message);
        }

        @Override
        public void warn(String message, @NotNull Throwable t) {
            if (t == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/openapi/extensions/Extensions$SimpleLogProvider", "warn"));
            }
            System.err.println(message);
            t.printStackTrace();
        }

        @Override
        public void warn(@NotNull Throwable t) {
            if (t == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/openapi/extensions/Extensions$SimpleLogProvider", "warn"));
            }
            t.printStackTrace();
        }
    }

    private static class AreaClassConfiguration {
        private final String myClassName;
        private final String myParentClassName;

        private AreaClassConfiguration(@NotNull String className, String parentClassName) {
            if (className == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/openapi/extensions/Extensions$AreaClassConfiguration", "<init>"));
            }
            this.myClassName = className;
            this.myParentClassName = parentClassName;
        }

        @NotNull
        public String getClassName() {
            String string = this.myClassName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/Extensions$AreaClassConfiguration", "getClassName"));
            }
            return string;
        }

        public String getParentClassName() {
            return this.myParentClassName;
        }

        public String toString() {
            return "AreaClassConfiguration{myClassName='" + this.myClassName + '\'' + ", myParentClassName='" + this.myParentClassName + "'}";
        }
    }
}

