/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.ast.builder;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public abstract class GrBuilderStrategySupport {
    public static final ExtensionPointName<GrBuilderStrategySupport> EP = ExtensionPointName.create((String)"org.intellij.groovy.builderStrategySupport");
    public static final String BUILDER_FQN = "groovy.transform.builder.Builder";
    public static final String ORIGIN_INFO = "by @Builder";

    @NotNull
    public abstract Members process(GrTypeDefinition var1);

    @Nullable
    public static String getStrategy(PsiModifierListOwner annotatedMember) {
        PsiAnnotation annotation = PsiImplUtil.getAnnotation(annotatedMember, BUILDER_FQN);
        if (annotation == null) {
            return null;
        }
        PsiAnnotationMemberValue strategy = annotation.findDeclaredAttributeValue("builderStrategy");
        if (strategy instanceof GrReferenceExpression) {
            PsiElement element = ((GrReferenceExpression)strategy).resolve();
            return element instanceof PsiClass ? ((PsiClass)element).getQualifiedName() : null;
        }
        return "groovy.transform.builder.DefaultStrategy";
    }

    public static class Members {
        public final Collection<PsiMethod> methods = ContainerUtil.newArrayList();
        public final Collection<GrField> fields = ContainerUtil.newArrayList();
        public final Collection<PsiClass> classes = ContainerUtil.newArrayList();

        public void addFrom(Members other) {
            this.methods.addAll(other.methods);
            this.fields.addAll(other.fields);
            this.classes.addAll(other.classes);
        }
    }
}

