/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.tmatesoft.svn.core.internal.util.SVNSSLUtil;

public class ServerSSHDialog
extends DialogWrapper {
    private int myResult;
    private String myFingerprints;
    private JCheckBox myJCheckBox;
    private final boolean myStore;
    private final String myHost;
    private final String myAlgorithm;

    public ServerSSHDialog(Project project, boolean store, @NotNull String host, @Nullable String algorithm, @NotNull byte[] fingerprints) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/idea/svn/dialogs/ServerSSHDialog", "<init>"));
        }
        if (fingerprints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fingerprints", "org/jetbrains/idea/svn/dialogs/ServerSSHDialog", "<init>"));
        }
        this(project, store, host, algorithm, SVNSSLUtil.getFingerprint((byte[])fingerprints, (String)"SHA1"));
    }

    public ServerSSHDialog(Project project, boolean store, @NotNull String host, @Nullable String algorithm, @NotNull String fingerprints) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/idea/svn/dialogs/ServerSSHDialog", "<init>"));
        }
        if (fingerprints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fingerprints", "org/jetbrains/idea/svn/dialogs/ServerSSHDialog", "<init>"));
        }
        super(project, true);
        this.myStore = store;
        this.myHost = host;
        this.myAlgorithm = StringUtil.notNullize((String)algorithm);
        this.myFingerprints = fingerprints;
        this.myResult = 0;
        this.setOKButtonText(SvnBundle.message("button.text.ssh.accept", new Object[0]));
        this.setCancelButtonText(SvnBundle.message("button.text.ssh.reject", new Object[0]));
        this.setTitle(SvnBundle.message("dialog.title.ssh.examine.server.fingerprints", new Object[0]));
        this.init();
        this.setResizable(false);
    }

    public boolean shouldCloseOnCross() {
        return false;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/ServerSSHDialog", "createActions"));
        }
        return actionArray;
    }

    protected void doOKAction() {
        this.myResult = this.myJCheckBox.isSelected() ? 2 : 1;
        super.doOKAction();
    }

    public void doCancelAction() {
        this.myResult = 0;
        super.doCancelAction();
    }

    public int getResult() {
        return this.myResult;
    }

    protected String getDimensionServiceKey() {
        return "org.jetbrains.idea.svn.dialogs.ServerSSHDialog";
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        JPanel wrapper = new JPanel();
        BoxLayout boxLayout = new BoxLayout(wrapper, 1);
        wrapper.setLayout(boxLayout);
        JLabel label = new JLabel(SvnBundle.message("label.ssh.server.provided.fingerprints", this.myHost));
        wrapper.add(label);
        JLabel label2 = new JLabel(SvnBundle.message("label.ssh.server.provided.fingerprints2", this.myAlgorithm));
        wrapper.add(label2);
        JTextField textField = new JTextField(this.myFingerprints);
        textField.setEditable(false);
        textField.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        wrapper.add(textField);
        JLabel label3 = new JLabel(SvnBundle.message("label.ssh.server.provided.fingerprints3", new Object[0]));
        label3.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        wrapper.add(label3);
        panel.add((Component)wrapper, "Center");
        this.myJCheckBox = new JCheckBox(SvnBundle.message("checkbox.svn.ssh.cache.fingerprint", new Object[0]));
        this.myJCheckBox.setSelected(this.myStore);
        this.myJCheckBox.setEnabled(this.myStore);
        panel.add((Component)this.myJCheckBox, "South");
        return panel;
    }
}

