/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.lazy;

import jet.runtime.typeinfo.JetValueParameter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.DeprecatedFunctionClassFqNameParser;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.GlobalJavaResolverContext;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.JavaClassLookupResult;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaResolverContext;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.header.KotlinClassHeader;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LazyPackage$resolvers$c2871a0d {
    @Nullable
    public static final ClassDescriptor lookupBinaryClass(@JetValueParameter(name="$receiver") LazyJavaResolverContext $receiver, @JetValueParameter(name="javaClass") @NotNull JavaClass javaClass) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(javaClass, "javaClass");
        KotlinJvmBinaryClass kotlinJvmBinaryClass = ((GlobalJavaResolverContext)$receiver).getKotlinClassFinder().findKotlinClass(javaClass);
        JavaClassLookupResult javaClassLookupResult = LazyPackage$resolvers$c2871a0d.resolveBinaryClass($receiver, kotlinJvmBinaryClass);
        return javaClassLookupResult != null ? javaClassLookupResult.getkClass() : null;
    }

    @NotNull
    public static final JavaClassLookupResult findClassInJava(@JetValueParameter(name="$receiver") LazyJavaResolverContext $receiver, @JetValueParameter(name="classId") @NotNull ClassId classId) {
        JavaClass javaClass;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        KotlinJvmBinaryClass kotlinClass = ((GlobalJavaResolverContext)$receiver).getKotlinClassFinder().findKotlinClass(classId);
        JavaClassLookupResult binaryClassResult = LazyPackage$resolvers$c2871a0d.resolveBinaryClass($receiver, kotlinClass);
        if (binaryClassResult != null) {
            return binaryClassResult;
        }
        if (!classId.isLocal() && !classId.isNestedClass()) {
            String string = classId.asSingleFqName().asString();
            Intrinsics.checkExpressionValueIsNotNull(string, "classId.asSingleFqName().asString()");
            if (DeprecatedFunctionClassFqNameParser.INSTANCE$.isDeprecatedFunctionClassFqName(string)) {
                return JavaClassLookupResult.Companion.getEMPTY();
            }
        }
        if ((javaClass = ((GlobalJavaResolverContext)$receiver).getFinder().findClass(classId)) != null) {
            return new JavaClassLookupResult(javaClass, null, 2, null);
        }
        return JavaClassLookupResult.Companion.getEMPTY();
    }

    @Nullable
    public static final JavaClassLookupResult resolveBinaryClass(@JetValueParameter(name="$receiver") LazyJavaResolverContext $receiver, @JetValueParameter(name="kotlinClass", type="?") @Nullable KotlinJvmBinaryClass kotlinClass) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (kotlinClass == null) {
            return null;
        }
        KotlinClassHeader header = kotlinClass.getClassHeader();
        if (!header.getIsCompatibleAbiVersion()) {
            ((GlobalJavaResolverContext)$receiver).getErrorReporter().reportIncompatibleAbiVersion(kotlinClass.getClassId(), kotlinClass.getLocation(), header.getVersion());
        } else if (Intrinsics.areEqual((Object)header.getKind(), (Object)KotlinClassHeader.Kind.CLASS)) {
            ClassDescriptor descriptor2 = ((GlobalJavaResolverContext)$receiver).getDeserializedDescriptorResolver().resolveClass(kotlinClass);
            if (descriptor2 != null) {
                return new JavaClassLookupResult(null, descriptor2, 1, null);
            }
        } else {
            return JavaClassLookupResult.Companion.getEMPTY();
        }
        return null;
    }
}

