/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.packages;

import com.android.annotations.NonNull;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.packages.IAndroidVersionProvider;
import com.android.sdklib.internal.repository.packages.IMinApiLevelDependency;
import com.android.sdklib.internal.repository.packages.MinToolsPackage;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.packages.PackageParserUtils;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.io.IFileOp;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgDesc;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.w3c.dom.Node;

public class SamplePackage
extends MinToolsPackage
implements IAndroidVersionProvider,
IMinApiLevelDependency {
    private final AndroidVersion mVersion;
    private final int mMinApiLevel;
    private final IPkgDesc mPkgDesc;

    public SamplePackage(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        super(source, packageNode, nsUri, licenses);
        int apiLevel = PackageParserUtils.getXmlInt(packageNode, "api-level", 0);
        String codeName = PackageParserUtils.getXmlString(packageNode, "codename");
        if (codeName.length() == 0) {
            codeName = null;
        }
        this.mVersion = new AndroidVersion(apiLevel, codeName);
        this.mMinApiLevel = PackageParserUtils.getXmlInt(packageNode, "min-api-level", 0);
        this.mPkgDesc = PkgDesc.Builder.newSample(this.mVersion, (MajorRevision)this.getRevision(), this.getMinToolsRevision()).setDescriptions(this).create();
    }

    public static Package create(IAndroidTarget target, Properties props) {
        return new SamplePackage(target, props);
    }

    private SamplePackage(IAndroidTarget target, Properties props) {
        super(null, props, 0, null, null, null, target.getPath(4));
        this.mVersion = target.getVersion();
        this.mMinApiLevel = SamplePackage.getPropertyInt(props, "Sample.MinApiLevel", 0);
        this.mPkgDesc = PkgDesc.Builder.newSample(this.mVersion, (MajorRevision)this.getRevision(), this.getMinToolsRevision()).setDescriptions(this).create();
    }

    public static Package create(String archiveOsPath, Properties props) throws AndroidVersion.AndroidVersionException {
        return new SamplePackage(archiveOsPath, props);
    }

    private SamplePackage(String archiveOsPath, Properties props) throws AndroidVersion.AndroidVersionException {
        super(null, props, 0, null, null, null, archiveOsPath);
        this.mVersion = new AndroidVersion(props);
        this.mMinApiLevel = SamplePackage.getPropertyInt(props, "Sample.MinApiLevel", 0);
        this.mPkgDesc = PkgDesc.Builder.newSample(this.mVersion, (MajorRevision)this.getRevision(), this.getMinToolsRevision()).setDescriptions(this).create();
    }

    @Override
    @NonNull
    public IPkgDesc getPkgDesc() {
        return this.mPkgDesc;
    }

    @Override
    public void saveProperties(Properties props) {
        super.saveProperties(props);
        this.mVersion.saveProperties(props);
        if (this.getMinApiLevel() != 0) {
            props.setProperty("Sample.MinApiLevel", Integer.toString(this.getMinApiLevel()));
        }
    }

    @Override
    public int getMinApiLevel() {
        return this.mMinApiLevel;
    }

    @Override
    @NonNull
    public AndroidVersion getAndroidVersion() {
        return this.mVersion;
    }

    @Override
    public String installId() {
        return "sample-" + this.mVersion.getApiString();
    }

    @Override
    public String getListDescription() {
        String ld = this.getListDisplay();
        if (!ld.isEmpty()) {
            return String.format("%1$s%2$s", ld, this.isObsolete() ? " (Obsolete)" : "");
        }
        String s = String.format("Samples for SDK API %1$s%2$s%3$s", this.mVersion.getApiString(), this.mVersion.isPreview() ? " Preview" : "", this.isObsolete() ? " (Obsolete)" : "");
        return s;
    }

    @Override
    public String getShortDescription() {
        String ld = this.getListDisplay();
        if (!ld.isEmpty()) {
            return String.format("%1$s, revision %2$s%3$s", ld, this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
        }
        String s = String.format("Samples for SDK API %1$s%2$s, revision %3$s%4$s", this.mVersion.getApiString(), this.mVersion.isPreview() ? " Preview" : "", this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
        return s;
    }

    @Override
    public String getLongDescription() {
        String s = this.getDescription();
        if (s == null || s.length() == 0) {
            s = this.getShortDescription();
        }
        if (s.indexOf("revision") == -1) {
            s = s + String.format("\nRevision %1$s%2$s", this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
        }
        return s;
    }

    @Override
    public File getInstallFolder(String osSdkRoot, SdkManager sdkManager) {
        File samplesRoot = new File(osSdkRoot, "samples");
        for (IAndroidTarget target : sdkManager.getTargets()) {
            String p;
            File f;
            if (!target.isPlatform() || !target.getVersion().equals(this.mVersion) || !(f = new File(p = target.getPath(4))).isDirectory() || !f.getParentFile().equals(samplesRoot)) continue;
            return f;
        }
        File folder = new File(samplesRoot, String.format("android-%s", this.getAndroidVersion().getApiString()));
        int n = 1;
        while (folder.exists()) {
            folder = new File(samplesRoot, String.format("android-%s_%d", this.getAndroidVersion().getApiString(), n));
            ++n;
        }
        return folder;
    }

    @Override
    public boolean sameItemAs(Package pkg) {
        if (pkg instanceof SamplePackage) {
            SamplePackage newPkg = (SamplePackage)pkg;
            return newPkg.getAndroidVersion().equals(this.getAndroidVersion());
        }
        return false;
    }

    @Override
    public boolean preInstallHook(Archive archive, ITaskMonitor monitor, String osSdkRoot, File installFolder) {
        String currentHash;
        String storedHash;
        if (installFolder != null && installFolder.isDirectory() && (storedHash = this.readContentHash(installFolder)) != null && storedHash.length() > 0 && !storedHash.equals(currentHash = this.computeContentHash(installFolder))) {
            String pkgName = archive.getParentPackage().getShortDescription();
            String msg = String.format("-= Warning ! =-\nYou are about to replace the content of the folder:\n   %1$s\nby the new package:\n  %2$s.\n\nHowever it seems that the content of the existing samples has been modified since it was last installed. Are you sure you want to DELETE the existing samples? This cannot be undone.\nPlease select YES to delete the existing sample and replace them by the new ones.\nPlease select NO to skip this package. You can always install it later.", installFolder.getAbsolutePath(), pkgName);
            return monitor.displayPrompt("SDK Manager: overwrite samples?", msg);
        }
        return super.preInstallHook(archive, monitor, osSdkRoot, installFolder);
    }

    @Override
    public void postInstallHook(Archive archive, ITaskMonitor monitor, File installFolder) {
        super.postInstallHook(archive, monitor, installFolder);
        if (installFolder != null) {
            String h = this.computeContentHash(installFolder);
            this.saveContentHash(installFolder, h);
        }
    }

    @Override
    public void postUnzipFileHook(Archive archive, ITaskMonitor monitor, IFileOp fileOp, File unzippedFile, ZipArchiveEntry zipEntry) {
        super.postUnzipFileHook(archive, monitor, fileOp, unzippedFile, zipEntry);
        if (fileOp.isFile(unzippedFile) && !"source.properties".equals(unzippedFile.getName())) {
            fileOp.setReadOnly(unzippedFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readContentHash(File folder) {
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            File f = new File(folder, "content_hash.properties");
            if (f.isFile()) {
                fis = new FileInputStream(f);
                props.load(fis);
                String string = props.getProperty("content-hash", null);
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveContentHash(File folder, String hash) {
        Properties props = new Properties();
        props.setProperty("content-hash", hash == null ? "" : hash);
        FileOutputStream fos = null;
        try {
            File f = new File(folder, "content_hash.properties");
            fos = new FileOutputStream(f);
            props.store(fos, "## Android - hash of this archive.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String computeContentHash(File installFolder) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        if (md != null) {
            this.hashDirectoryContent(installFolder, md);
            return this.getDigestHexString(md);
        }
        return null;
    }

    private void hashDirectoryContent(File folder, MessageDigest md) {
        if (folder == null || md == null || !folder.isDirectory()) {
            return;
        }
        for (File f : folder.listFiles()) {
            if (f.isDirectory()) {
                this.hashDirectoryContent(f, md);
                continue;
            }
            String name = f.getName();
            if (name == null || "content_hash.properties".equals(name)) continue;
            try {
                md.update(name.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            try {
                long len = f.length();
                md.update((byte)(len & 0xFFL));
                md.update((byte)(len >> 8 & 0xFFL));
                md.update((byte)(len >> 16 & 0xFFL));
                md.update((byte)(len >> 24 & 0xFFL));
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    private String getDigestHexString(MessageDigest digester) {
        byte[] digest = digester.digest();
        int n = digest.length;
        String hex = "0123456789abcdef";
        char[] hexDigest = new char[n * 2];
        for (int i = 0; i < n; ++i) {
            int b = digest[i] & 0xFF;
            hexDigest[i * 2 + 0] = hex.charAt(b >>> 4);
            hexDigest[i * 2 + 1] = hex.charAt(b & 0xF);
        }
        return new String(hexDigest);
    }
}

