/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.UISettings;
import java.awt.RenderingHints;
import sun.swing.SwingUtilities2;

public enum LCDRenderingScope {
    IDE,
    EXCLUDING_EDITOR,
    OFF;

    private static final SwingUtilities2.AATextInfo aaEnabled;
    private static final SwingUtilities2.AATextInfo lcdEnabled;
    private static final SwingUtilities2.AATextInfo aaDisabled;

    public static LCDRenderingScope getWithLongestName() {
        return IDE;
    }

    public static Object getAAHintForSwingComponent() {
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings.ANTIALIASING_IN_IDE) {
            if (uiSettings.LCD_RENDERING_SCOPE == OFF) {
                return aaEnabled;
            }
            return lcdEnabled;
        }
        return aaDisabled;
    }

    public static Object getKeyForCurrentScope(boolean inEditor) {
        Object renderingHint = RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings != null && uiSettings.ANTIALIASING_IN_IDE) {
            switch (uiSettings.LCD_RENDERING_SCOPE) {
                case IDE: {
                    renderingHint = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB;
                    break;
                }
                case EXCLUDING_EDITOR: {
                    if (!inEditor) {
                        renderingHint = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB;
                        break;
                    }
                }
                case OFF: {
                    renderingHint = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
                }
            }
        }
        return renderingHint;
    }

    public String toString() {
        String description;
        switch (this) {
            case IDE: {
                description = "LCD Rendering in IDE and Editor";
                break;
            }
            case EXCLUDING_EDITOR: {
                description = "LCD Rendering in IDE";
                break;
            }
            case OFF: {
                description = "Without LCD rendering";
                break;
            }
            default: {
                description = "LCD Rendering in IDE";
            }
        }
        return description;
    }

    public static boolean shouldRenderEditor(LCDRenderingScope scope) {
        if (!UISettings.getInstance().ANTIALIASING_IN_IDE) {
            return false;
        }
        switch (scope) {
            case IDE: {
                return true;
            }
        }
        return false;
    }

    static {
        aaEnabled = new SwingUtilities2.AATextInfo(RenderingHints.VALUE_TEXT_ANTIALIAS_ON, Integer.valueOf(140));
        lcdEnabled = new SwingUtilities2.AATextInfo(RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB, Integer.valueOf(140));
        aaDisabled = null;
    }
}

