/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class BaseRevisionTextPatchEP
implements PatchEP {
    public static final Key<Boolean> ourPutBaseRevisionTextKey = Key.create((String)"com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP.ourPutBaseRevisionTextKey");
    public static final Key<List<FilePath>> ourBaseRevisionPaths = Key.create((String)"com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP.ourBaseRevisionPaths");
    public static final Key<Map<String, String>> ourStoredTexts = Key.create((String)"com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP.ourStoredTexts");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP");
    private final Project myProject;
    private final ChangeListManager myChangeListManager;
    private final String myBaseDir;

    public BaseRevisionTextPatchEP(Project project) {
        this.myProject = project;
        this.myBaseDir = this.myProject.getBaseDir().getPath();
        this.myChangeListManager = ChangeListManager.getInstance(this.myProject);
    }

    @Override
    @NotNull
    public String getName() {
        if ("com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/patch/BaseRevisionTextPatchEP", "getName"));
        }
        return "com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP";
    }

    @Override
    public CharSequence provideContent(@NotNull String path, CommitContext commitContext) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/diff/impl/patch/BaseRevisionTextPatchEP", "provideContent"));
        }
        if (commitContext == null) {
            return null;
        }
        if (Boolean.TRUE.equals(commitContext.getUserData(ourPutBaseRevisionTextKey))) {
            File file = new File(this.myBaseDir, path);
            FilePath filePathOn = VcsContextFactory.SERVICE.getInstance().createFilePathOn(file);
            Change change = this.myChangeListManager.getChange(filePathOn);
            List<FilePath> paths = commitContext.getUserData(ourBaseRevisionPaths);
            if (change == null || change.getBeforeRevision() == null || paths == null || !paths.contains(filePathOn)) {
                return null;
            }
            try {
                String content = change.getBeforeRevision().getContent();
                return content;
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
            }
        } else {
            Map<String, String> map = commitContext.getUserData(ourStoredTexts);
            if (map != null) {
                File file = new File(this.myBaseDir, path);
                return map.get(file.getPath());
            }
        }
        return null;
    }

    @Override
    public void consumeContent(@NotNull String path, @NotNull CharSequence content, CommitContext commitContext) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/diff/impl/patch/BaseRevisionTextPatchEP", "consumeContent"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/diff/impl/patch/BaseRevisionTextPatchEP", "consumeContent"));
        }
    }

    @Override
    public void consumeContentBeforePatchApplied(@NotNull String path, @NotNull CharSequence content, CommitContext commitContext) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/diff/impl/patch/BaseRevisionTextPatchEP", "consumeContentBeforePatchApplied"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/diff/impl/patch/BaseRevisionTextPatchEP", "consumeContentBeforePatchApplied"));
        }
        if (commitContext == null) {
            return;
        }
        Map<String, String> map = commitContext.getUserData(ourStoredTexts);
        if (map == null) {
            map = new HashMap<String, String>();
            commitContext.putUserData(ourStoredTexts, map);
        }
        File file = new File(this.myBaseDir, path);
        map.put(file.getPath(), content.toString());
    }
}

