/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.options.ExternalizableSchemeAdapter;
import com.intellij.openapi.options.SchemeElement;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompoundScheme<T extends SchemeElement>
extends ExternalizableSchemeAdapter {
    private final List<T> myElements = new ArrayList<T>();

    public CompoundScheme(String name) {
        this.myName = name;
    }

    public void addElement(T t) {
        if (!this.contains(t)) {
            this.myElements.add(t);
        }
    }

    public void insertElement(T element, int i) {
        if (!this.contains(element)) {
            this.myElements.add(i, element);
        }
    }

    public List<T> getElements() {
        return Collections.unmodifiableList(new ArrayList<T>(this.myElements));
    }

    @Override
    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/options/CompoundScheme", "setName"));
        }
        this.myName = name;
        for (SchemeElement template : this.myElements) {
            template.setGroupName(name);
        }
    }

    public void removeElement(T template) {
        Iterator<T> templateIterator = this.myElements.iterator();
        while (templateIterator.hasNext()) {
            SchemeElement t = (SchemeElement)templateIterator.next();
            if (t.getKey() == null || !t.getKey().equals(template.getKey())) continue;
            templateIterator.remove();
        }
    }

    public boolean isEmpty() {
        return this.myElements.isEmpty();
    }

    private CompoundScheme createNewInstance(String name) {
        try {
            Constructor<?> constructor = this.getClass().getConstructor(String.class);
            return (CompoundScheme)constructor.newInstance(name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public CompoundScheme<T> copy() {
        CompoundScheme result = this.createNewInstance(this.getName());
        for (SchemeElement element : this.myElements) {
            result.addElement(element.copy());
        }
        CompoundScheme compoundScheme = result;
        if (compoundScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/CompoundScheme", "copy"));
        }
        return compoundScheme;
    }

    public boolean contains(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/options/CompoundScheme", "contains"));
        }
        for (SchemeElement t : this.myElements) {
            if (t.getKey() == null || !t.getKey().equals(element.getKey())) continue;
            return true;
        }
        return false;
    }
}

