/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.vcs.ComparableComparator;
import com.intellij.util.PairProcessor;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AreaMap<Key, Val> {
    protected final List<Key> myKeys;
    protected final Map<Key, Val> myMap;
    protected final PairProcessor<Key, Key> myKeysResemblance;
    private final Comparator<Key> myComparator;

    public static <Key extends Comparable<Key>, Val> AreaMap<Key, Val> create(PairProcessor<Key, Key> keysResemblance) {
        return new AreaMap<Key, Val>(keysResemblance, new ComparableComparator());
    }

    public static <Key, Val> AreaMap<Key, Val> create(PairProcessor<Key, Key> keysResemblance, Comparator<Key> comparator) {
        return new AreaMap<Key, Val>(keysResemblance, comparator);
    }

    protected AreaMap(PairProcessor<Key, Key> keysResemblance, Comparator<Key> comparator) {
        this.myKeysResemblance = keysResemblance;
        this.myComparator = comparator;
        this.myKeys = new LinkedList<Key>();
        this.myMap = new HashMap<Key, Val>();
    }

    public void putAll(AreaMap<Key, Val> other) {
        this.myKeys.addAll(other.myKeys);
        this.myMap.putAll(other.myMap);
    }

    public void put(Key key, Val val) {
        this.putImpl(key, val);
    }

    protected int putIfNoParent(Key key, Val val) {
        if (this.myMap.put(key, val) != null) {
            return -1;
        }
        if (this.myKeys.isEmpty()) {
            this.myKeys.add(key);
            return 0;
        }
        int idx = Collections.binarySearch(this.myKeys, key, this.myComparator);
        if (idx < 0) {
            int insertionIdx = -idx - 1;
            ListIterator<Key> listIterator = this.myKeys.listIterator(insertionIdx);
            while (listIterator.hasPrevious()) {
                Key previous = listIterator.previous();
                if (!this.myKeysResemblance.process(previous, key)) continue;
                this.myMap.remove(key);
                return -1;
            }
            this.myKeys.add(insertionIdx, key);
            return insertionIdx;
        }
        this.myMap.remove(key);
        return -1;
    }

    protected int putImpl(Key key, Val val) {
        this.myMap.put(key, val);
        if (this.myKeys.isEmpty()) {
            this.myKeys.add(key);
            return 0;
        }
        int idx = Collections.binarySearch(this.myKeys, key, this.myComparator);
        if (idx < 0) {
            int insertionIdx = -idx - 1;
            this.myKeys.add(insertionIdx, key);
            return insertionIdx;
        }
        return idx;
    }

    public Collection<Val> values() {
        return Collections.unmodifiableCollection(this.myMap.values());
    }

    public Collection<Key> keySet() {
        return Collections.unmodifiableCollection(this.myKeys);
    }

    @Nullable
    public Val getExact(Key key) {
        return this.myMap.get(key);
    }

    public void removeByValue(@NotNull Val val) {
        if (val == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "val", "com/intellij/openapi/vcs/AreaMap", "removeByValue"));
        }
        Iterator<Key> iterator = this.myKeys.iterator();
        while (iterator.hasNext()) {
            Key key = iterator.next();
            Val current = this.myMap.get(key);
            if (!val.equals(current)) continue;
            iterator.remove();
            this.myMap.remove(key);
            return;
        }
    }

    public void remove(Key key) {
        this.myKeys.remove(key);
        this.myMap.remove(key);
    }

    public boolean contains(Key key) {
        return this.myKeys.contains(key);
    }

    public void getSimiliar(Key key, PairProcessor<Key, Val> consumer) {
        int idx = Collections.binarySearch(this.myKeys, key, this.myComparator);
        if (idx < 0) {
            int insertionIdx = -idx - 1;
            int itemBeforeIdx = insertionIdx - 1;
            if (itemBeforeIdx >= 0) {
                Key candidate;
                ListIterator<Key> iterator = this.myKeys.listIterator(itemBeforeIdx + 1);
                while (!(!iterator.hasPrevious() || this.myKeysResemblance.process(candidate = iterator.previous(), key) && consumer.process(candidate, this.myMap.get(candidate)))) {
                }
            }
        } else {
            consumer.process(key, this.myMap.get(key));
        }
    }

    public boolean isEmpty() {
        return this.myKeys.isEmpty();
    }

    public void clear() {
        this.myKeys.clear();
        this.myMap.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AreaMap areaMap = (AreaMap)o;
        if (!this.myKeys.equals(areaMap.myKeys)) {
            return false;
        }
        return this.myMap.equals(areaMap.myMap);
    }

    public int hashCode() {
        int result = this.myKeys.hashCode();
        result = 31 * result + this.myMap.hashCode();
        return result;
    }
}

