/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.ExpandedItemRendererComponentWrapper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ExpandedItemListCellRendererWrapper
implements ListCellRenderer {
    @NotNull
    private final ListCellRenderer myWrappee;
    @NotNull
    private final ExpandableItemsHandler<Integer> myHandler;

    public ExpandedItemListCellRendererWrapper(@NotNull ListCellRenderer wrappee, @NotNull ExpandableItemsHandler<Integer> handler) {
        if (wrappee == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrappee", "com/intellij/ui/ExpandedItemListCellRendererWrapper", "<init>"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/ui/ExpandedItemListCellRendererWrapper", "<init>"));
        }
        this.myWrappee = wrappee;
        this.myHandler = handler;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JComponent res;
        Component result = this.myWrappee.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (!this.myHandler.getExpandedItems().contains(index)) {
            return result;
        }
        Rectangle bounds = result.getBounds();
        ExpandedItemRendererComponentWrapper wrapper = new ExpandedItemRendererComponentWrapper(result);
        if (UIUtil.getClientProperty((JComponent)list, ExpandableItemsHandler.EXPANDED_RENDERER) == Boolean.TRUE && (res = (JComponent)ObjectUtils.tryCast((Object)result, JComponent.class)) != null && UIUtil.getClientProperty((JComponent)res, ExpandableItemsHandler.USE_RENDERER_BOUNDS) == Boolean.TRUE) {
            Insets insets = wrapper.getInsets();
            bounds.translate(-insets.left, -insets.top);
            bounds.grow(insets.left + insets.right, insets.top + insets.bottom);
            wrapper.setBounds(bounds);
            UIUtil.putClientProperty((JComponent)wrapper, ExpandableItemsHandler.USE_RENDERER_BOUNDS, (Object)true);
        }
        return wrapper;
    }

    @NotNull
    public ListCellRenderer getWrappee() {
        ListCellRenderer listCellRenderer = this.myWrappee;
        if (listCellRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/ExpandedItemListCellRendererWrapper", "getWrappee"));
        }
        return listCellRenderer;
    }
}

