/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jgit.dirCache;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.io.IoPackage;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.Repository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jgit.dirCache.AddLoadedFile;
import org.jetbrains.jgit.dirCache.DeleteDirectory;
import org.jetbrains.jgit.dirCache.DeleteFile;
import org.jetbrains.jgit.dirCache.DirCacheEditor;
import org.jetbrains.jgit.dirCache.DirCachePackage$dirCacheEditor$74a8d23a;
import org.jetbrains.jgit.dirCache.DirCacheTerminator;
import org.jetbrains.jgit.dirCache.PathEdit;
import org.jetbrains.settingsRepository.SettingsRepositoryPackage$BaseRepositoryManager$f78edab6;
import org.jetbrains.settingsRepository.SettingsRepositoryPackage$util$c8ef32c4;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class DirCachePackage$dirCacheEditor$74a8d23a {
    @NotNull
    static final Comparator<PathEdit> EDIT_CMP = new Comparator<PathEdit>(){
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(EDIT_CMP.1.class);
        }

        public int compare(@JetValueParameter(name="o1") @NotNull PathEdit o1, @JetValueParameter(name="o2") @NotNull PathEdit o2) {
            Intrinsics.checkParameterIsNotNull((Object)o1, (String)"o1");
            Intrinsics.checkParameterIsNotNull((Object)o2, (String)"o2");
            byte[] a = o1.getPath();
            byte[] b = o2.getPath();
            return DirCache.cmp((byte[])a, (int)a.length, (byte[])b, (int)b.length);
        }
    };

    @NotNull
    public static final Comparator<PathEdit> getEDIT_CMP() {
        return EDIT_CMP;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] encodePath(@JetValueParameter(name="path") @NotNull String path) {
        int n;
        int n2;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        ByteBuffer byteBuffer = Constants.CHARSET.encode(path);
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"Constants.CHARSET.encode(path)");
        byte[] bytes = SettingsRepositoryPackage$util$c8ef32c4.byteBufferToBytes(byteBuffer);
        if (SystemInfo.isWindows && (n2 = 0) <= (n = bytes.length - 1)) {
            while (true) {
                void i;
                if ((char)bytes[i] == '\\') {
                    bytes[i] = (byte)47;
                }
                if (i == n) break;
                ++i;
            }
        }
        return bytes;
    }

    @NotNull
    public static final DeleteFile DeleteFile(@JetValueParameter(name="path") @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return new DeleteFile(DirCachePackage$dirCacheEditor$74a8d23a.encodePath(path));
    }

    public static final void edit(@JetValueParameter(name="$receiver") Repository $receiver, @JetValueParameter(name="edit") @NotNull PathEdit edit2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)edit2, (String)"edit");
        List<PathEdit> list = Collections.singletonList(edit2);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.singletonList(edit)");
        DirCachePackage$dirCacheEditor$74a8d23a.edit($receiver, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void edit(@JetValueParameter(name="$receiver") Repository $receiver, @JetValueParameter(name="edits") @NotNull List<? extends PathEdit> edits) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(edits, (String)"edits");
        if (edits.isEmpty()) {
            return;
        }
        DirCache dirCache = $receiver.lockDirCache();
        try {
            DirCache dirCache2 = dirCache;
            Intrinsics.checkExpressionValueIsNotNull((Object)dirCache2, (String)"dirCache");
            new DirCacheEditor(edits, $receiver, dirCache2, dirCache.getEntryCount() + 4).commit();
        }
        finally {
            dirCache.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void deleteAllFiles(@JetValueParameter(name="$receiver") Repository $receiver, @JetValueParameter(name="deletedSet", type="?") @Nullable Set<String> deletedSet, @JetValueParameter(name="fromWorkingTree") boolean fromWorkingTree) {
        File[] files2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DirCache dirCache = $receiver.lockDirCache();
        try {
            int n;
            int n2;
            if (deletedSet != null && (n2 = 0) <= (n = dirCache.getEntryCount() - 1)) {
                while (true) {
                    void i;
                    DirCacheEntry entry;
                    if (Intrinsics.areEqual((Object)(entry = dirCache.getEntry((int)i)).getFileMode(), (Object)FileMode.REGULAR_FILE)) {
                        String string = entry.getPathString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.getPathString()");
                        deletedSet.add(string);
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            DirCache dirCache2 = dirCache;
            Intrinsics.checkExpressionValueIsNotNull((Object)dirCache2, (String)"dirCache");
            new DirCacheTerminator(dirCache2).commit();
        }
        finally {
            dirCache.unlock();
        }
        if (fromWorkingTree && (files2 = IoPackage.listFiles((File)$receiver.getWorkTree(), (Function1)deleteAllFiles.files.1.INSTANCE$)) != null) {
            for (int i = 0; i < files2.length; ++i) {
                File file = files2[i];
                FileUtil.delete((File)file);
            }
        }
    }

    public static /* synthetic */ void deleteAllFiles$default(Repository repository, Set set, boolean bl, int n) {
        if ((n & 1) != 0) {
            set = null;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        DirCachePackage$dirCacheEditor$74a8d23a.deleteAllFiles(repository, set, bl);
    }

    public static final void writePath(@JetValueParameter(name="$receiver") Repository $receiver, @JetValueParameter(name="path") @NotNull String path, @JetValueParameter(name="bytes") @NotNull byte[] bytes, @JetValueParameter(name="size") int size) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        DirCachePackage$dirCacheEditor$74a8d23a.edit($receiver, new AddLoadedFile(path, bytes, size, 0L, 8, null));
        FileUtil.writeToFile((File)new File($receiver.getWorkTree(), path), (byte[])bytes, (int)0, (int)size);
    }

    public static /* synthetic */ void writePath$default(Repository repository, String string, byte[] byArray, int n, int n2) {
        if ((n2 & 4) != 0) {
            n = byArray.length;
        }
        DirCachePackage$dirCacheEditor$74a8d23a.writePath(repository, string, byArray, n);
    }

    public static final void deletePath(@JetValueParameter(name="$receiver") Repository $receiver, @JetValueParameter(name="path") @NotNull String path, @JetValueParameter(name="isFile") boolean isFile, @JetValueParameter(name="fromWorkingTree") boolean fromWorkingTree) {
        File workTree;
        File ioFile;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        DirCachePackage$dirCacheEditor$74a8d23a.edit($receiver, isFile ? (PathEdit)DirCachePackage$dirCacheEditor$74a8d23a.DeleteFile(path) : (PathEdit)new DeleteDirectory(path));
        if (fromWorkingTree && (ioFile = new File(workTree = $receiver.getWorkTree(), path)).exists()) {
            File file = workTree;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"workTree");
            SettingsRepositoryPackage$BaseRepositoryManager$f78edab6.removeWithParentsIfEmpty(ioFile, file, isFile);
        }
    }

    public static /* synthetic */ void deletePath$default(Repository repository, String string, boolean bl, boolean bl2, int n) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        DirCachePackage$dirCacheEditor$74a8d23a.deletePath(repository, string, bl, bl2);
    }
}

