/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.AuthenticationException;
import org.jetbrains.settingsRepository.IcsBundle;
import org.jetbrains.settingsRepository.IcsManager;
import org.jetbrains.settingsRepository.NoRemoteRepositoryException;
import org.jetbrains.settingsRepository.RepositoryManager;
import org.jetbrains.settingsRepository.SettingsRepositoryPackage$IcsManager$d5f67752;
import org.jetbrains.settingsRepository.SettingsRepositoryPackage$upstreamEditor$16e2ee27;
import org.jetbrains.settingsRepository.SettingsRepositoryPackage$upstreamEditor$16e2ee27$createMergeActions$;
import org.jetbrains.settingsRepository.SyncType;
import org.jetbrains.settingsRepository.actions.ActionsPackage$SyncAction$ab682cb6;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class SettingsRepositoryPackage$upstreamEditor$16e2ee27 {
    public static final void updateSyncButtonState(@JetValueParameter(name="url", type="?") @Nullable String url, @JetValueParameter(name="syncActions") @NotNull Action[] syncActions) {
        boolean enabled;
        Intrinsics.checkParameterIsNotNull((Object)syncActions, (String)"syncActions");
        try {
            enabled = url != null && url.length() > 1 && SettingsRepositoryPackage$IcsManager$d5f67752.getIcsManager().getRepositoryService().checkUrl(url, null);
        }
        catch (Exception e) {
            enabled = false;
        }
        for (int i = 0; i < syncActions.length; ++i) {
            Action syncAction = syncActions[i];
            syncAction.setEnabled(enabled);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Action[] createMergeActions(@JetValueParameter(name="project", type="?") @Nullable Project project, @JetValueParameter(name="urlTextField") @NotNull TextFieldWithBrowseButton urlTextField, @JetValueParameter(name="dialogParent") @NotNull Container dialogParent, @JetValueParameter(name="okAction") @NotNull Function0<? extends Unit> okAction) {
        void size;
        void syncTypes;
        Intrinsics.checkParameterIsNotNull((Object)urlTextField, (String)"urlTextField");
        Intrinsics.checkParameterIsNotNull((Object)dialogParent, (String)"dialogParent");
        Intrinsics.checkParameterIsNotNull(okAction, (String)"okAction");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = SyncType.values();
        if (SystemInfo.isMac) {
            Object[] objectArray = ArrayUtil.reverseArray((Object[])((Object[])((SyncType[])syncTypes.element)));
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"ArrayUtil.reverseArray(syncTypes)");
            syncTypes.element = (SyncType[])objectArray;
        }
        IcsManager icsManager2 = SettingsRepositoryPackage$IcsManager$d5f67752.getIcsManager();
        int n = 3;
        Action[] result = new Action[size];
        boolean bl = false;
        void var9_9 = size - true;
        if (bl <= var9_9) {
            void i;
            do {
                void it;
                void var10_10 = ++i;
                void var12_12 = i;
                Action[] actionArray = result;
                SyncType syncType = ((SyncType[])syncTypes.element)[it];
                AbstractAction abstractAction = new AbstractAction(syncType, IcsBundle.Companion.message("action." + (Intrinsics.areEqual((Object)((Object)syncType), (Object)((Object)SyncType.MERGE)) ? "Merge" : (Intrinsics.areEqual((Object)((Object)syncType), (Object)((Object)SyncType.OVERWRITE_LOCAL)) ? "ResetToTheirs" : "ResetToMy")) + "Settings.text", new Object[0]), (Ref.ObjectRef)syncTypes, urlTextField, icsManager2, dialogParent, project, okAction){
                    public static final /* synthetic */ KClass $kotlinClass;
                    final /* synthetic */ SyncType $syncType;
                    final /* synthetic */ Ref.ObjectRef $syncTypes$inlined;
                    final /* synthetic */ TextFieldWithBrowseButton $urlTextField$inlined;
                    final /* synthetic */ IcsManager $icsManager$inlined;
                    final /* synthetic */ Container $dialogParent$inlined;
                    final /* synthetic */ Project $project$inlined;
                    final /* synthetic */ Function0 $okAction$inlined;

                    static {
                        $kotlinClass = Reflection.createKotlinClass(createMergeActions$$inlined$Array$lambda$1.class);
                    }

                    public final boolean saveRemoteRepositoryUrl() {
                        String url = StringUtil.nullize((String)this.$urlTextField$inlined.getText());
                        if (url != null && !this.$icsManager$inlined.getRepositoryService().checkUrl(url, this.$dialogParent$inlined)) {
                            return false;
                        }
                        RepositoryManager repositoryManager = this.$icsManager$inlined.getRepositoryManager();
                        repositoryManager.createRepositoryIfNeed();
                        repositoryManager.setUpstream(url, null);
                        return true;
                    }

                    public void actionPerformed(ActionEvent event) {
                        boolean repositoryWillBeCreated = !this.$icsManager$inlined.getRepositoryManager().isRepositoryExists();
                        boolean upstreamSet = false;
                        try {
                            if (!this.saveRemoteRepositoryUrl()) {
                                if (repositoryWillBeCreated) {
                                    this.$icsManager$inlined.getRepositoryManager().deleteRepository();
                                }
                                return;
                            }
                            upstreamSet = true;
                            if (repositoryWillBeCreated && Intrinsics.areEqual((Object)((Object)this.$syncType), (Object)((Object)SyncType.OVERWRITE_LOCAL)) ^ true) {
                                ApplicationManager.getApplication().saveSettings();
                                this.$icsManager$inlined.sync(this.$syncType, this.$project$inlined, (Function0<? extends Unit>)((Function0)createMergeActions.1.actionPerformed.1.INSTANCE$));
                            } else {
                                this.$icsManager$inlined.sync(this.$syncType, this.$project$inlined, (Function0<? extends Unit>)((Function0)null));
                            }
                        }
                        catch (Throwable e) {
                            if (repositoryWillBeCreated) {
                                this.$icsManager$inlined.getRepositoryManager().deleteRepository();
                            }
                            SettingsRepositoryPackage$IcsManager$d5f67752.getLOG().warn(e);
                            if (!upstreamSet || e instanceof NoRemoteRepositoryException) {
                                Messages.showErrorDialog((Component)this.$dialogParent$inlined, (String)IcsBundle.Companion.message("set.upstream.failed.message", e.getMessage()), (String)IcsBundle.Companion.message("set.upstream.failed.title", new Object[0]));
                            } else {
                                Messages.showErrorDialog((Component)this.$dialogParent$inlined, (String)StringUtil.notNullize((String)e.getMessage(), (String)"Internal error"), (String)IcsBundle.Companion.message(e instanceof AuthenticationException ? "sync.not.authorized.title" : "sync.rejected.title", new Object[0]));
                            }
                            return;
                        }
                        ActionsPackage$SyncAction$ab682cb6.getNOTIFICATION_GROUP().createNotification(IcsBundle.Companion.message("sync.done.message", new Object[0]), NotificationType.INFORMATION).notify(this.$project$inlined);
                        this.$okAction$inlined.invoke();
                    }
                    {
                        void $super_call_param$2;
                        this.$syncType = syncType;
                        this.$syncTypes$inlined = objectRef;
                        this.$urlTextField$inlined = textFieldWithBrowseButton;
                        this.$icsManager$inlined = icsManager2;
                        this.$dialogParent$inlined = container;
                        this.$project$inlined = project;
                        this.$okAction$inlined = function0;
                        super((String)$super_call_param$2);
                    }
                };
                actionArray[var12_12] = abstractAction;
            } while (i != var9_9);
        }
        return (Action[])((Object[])result);
    }
}

