/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.errors.CheckoutConflictException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.merge.MergeMessageFormatter;
import org.eclipse.jgit.merge.MergeResult;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.merge.SquashMessageFormatter;
import org.eclipse.jgit.merge.ThreeWayMergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.RevWalkUtils;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.OperationResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.ImmutableUpdateResult;
import org.jetbrains.settingsRepository.SettingsRepositoryPackage$BaseRepositoryManager$f78edab6;
import org.jetbrains.settingsRepository.SettingsRepositoryPackage$IcsManager$d5f67752;
import org.jetbrains.settingsRepository.SettingsRepositoryPackage$RepositoryManager$a8a6e2c5;
import org.jetbrains.settingsRepository.UpdateResult;
import org.jetbrains.settingsRepository.git.CommitMessageFormatter;
import org.jetbrains.settingsRepository.git.GitPackage$GitEx$3dc0a22d;
import org.jetbrains.settingsRepository.git.GitPackage$GitRepositoryManager$849b556b;
import org.jetbrains.settingsRepository.git.GitPackage$JGitMergeProvider$9ab22031;
import org.jetbrains.settingsRepository.git.GitPackage$JGitProgressMonitor$1fce68cd;
import org.jetbrains.settingsRepository.git.GitPackage$pull$76315817;
import org.jetbrains.settingsRepository.git.GitRepositoryManager;
import org.jetbrains.settingsRepository.git.IdeaCommitMessageFormatter;
import org.jetbrains.settingsRepository.git.JGitMergeProvider;
import org.jetbrains.settingsRepository.git.MergeResultEx;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\u0002\u000e)!\u0001+\u001e7m\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NT!c]3ui&twm\u001d*fa>\u001c\u0018\u000e^8ss*\u0019q-\u001b;\u000b\u0007\u0005s\u0017P\u0003\u0004l_Rd\u0017N\u001c\u0006\u0007y%t\u0017\u000e\u001e \u000b\u000f5\fg.Y4fe*!r)\u001b;SKB|7/\u001b;pefl\u0015M\\1hKJT\u0011\"\u001b8eS\u000e\fGo\u001c:\u000b#A\u0013xn\u001a:fgNLe\u000eZ5dCR|'OC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\b_B,g.\u00199j\u0015!\u0001(o\\4sKN\u001c(BF2p[6LG/T3tg\u0006<WMR8s[\u0006$H/\u001a:\u000b-\r{W.\\5u\u001b\u0016\u001c8/Y4f\r>\u0014X.\u0019;uKJT\u0011dZ3u\u0007>lW.\u001b;NKN\u001c\u0018mZ3G_Jl\u0017\r\u001e;fe*11m\u001c8gS\u001eTAb\u0015;pe\u0016$7i\u001c8gS\u001eTq!Z2mSB\u001cXM\u0003\u0003kO&$(b\u00017jE*92n\u001c;mS:t#N^7/!2\fGOZ8s[RK\b/\u001a\u0006\nO\u0016$8i\u001c8gS\u001eTAbZ3u\u0013:$\u0017nY1u_JT!bZ3u\u001b\u0006t\u0017mZ3s\u00151\u0011X-\\8uK\u000e{gNZ5h\u00151\u0011V-\\8uK\u000e{gNZ5h\u0015%!(/\u00198ta>\u0014HOC\bhKR\u0014V-\\8uK\u000e{gNZ5h\u0015)\u0011X\r]8tSR|'/\u001f\u0006\u000b%\u0016\u0004xn]5u_JL(\"D4fiJ+\u0007o\\:ji>\u0014\u0018PC\u0003gKR\u001c\u0007NC\nqe\u00164(+\u001a4Va\u0012\fG/\u001a*fgVdGO\u0003\u0004SKN,H\u000e\u001e\u0006\n%\u00164W\u000b\u001d3bi\u0016T1AU3g\u0015A\u0011VMZ+qI\u0006$X\r\n*fgVdGOC\u0003nKJ<WMC\u0006v]B,W\r\\3e%\u00164'\"D7fe\u001e,7\u000b\u001e:bi\u0016<\u0017PC\u0007NKJ<Wm\u0015;sCR,w-\u001f\u0006\u0007G>lW.\u001b;\u000b\u000f\t{w\u000e\\3b]*ya-Y:u\r>\u0014x/\u0019:e\u001b>$WMC\bGCN$hi\u001c:xCJ$Wj\u001c3f\u00151iUM]4f\u0007>lW.\u00198e\u0015\r\t\u0007/\u001b\u0006\u0007gF,\u0018m\u001d5\u000b\u0015\u0019|'oY3NKJ<WMC\u0007d_6l\u0017\u000e^'fgN\fw-\u001a\u0006\u0007'R\u0014\u0018N\\4\u000b\u001b5+'oZ3SKN,H\u000e^#y\u0015qiUM]4f\u0007>lW.\u00198eI\u0019\u000b7\u000f\u001e$pe^\f'\u000fZ'pI\u0016TAA[1wC*!A.\u00198h\u0015\u0011\u0001X\u000f\u001c7\u000b)A\u0014XMZ3uG\",GMU3g)>lUM]4f\u00151)\u0006\u000fZ1uKJ+7/\u001e7uy\u000bQ!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!B\u0002\u0005\u0004!\u0001A\u0002A\u0003\u0002\u0011\r)1\u0001\"\u0002\t\u00061\u0001Qa\u0001C\u0002\u0011\u0013a\u0001!B\u0001\t\r\u0015\u0011A\u0001\u0002E\u0007\u000b\t!I\u0001C\u0004\u0006\u0005\u0011)\u0001rB\u0003\u0004\t\u0017AY\u0001\u0004\u0001\u0006\u0007\u0011\r\u0001\u0012\u0003\u0007\u0001\u000b\t!\u0019\u0001#\u0003\u0006\u0005\u0011-\u00012B\u0003\u0003\t\u0007A\t\"\u0002\u0002\u0005\u0001!UQA\u0001C\t\u0011-)!\u0001B\u0005\t\u0018\u0015\u0019A1\u0003\u0005\u000b\u0019\u0001)!\u0001b\u0005\t\u0015\u0015\u0011A!\u0003\u0005\u0010\u000b\r!1\u0002#\b\r\u0001\u0015\u0011Aa\u0003E\u000f\u000b\r!\u0019\u0002#\t\r\u0001\u0015\u0011A1\u0003E\u0011\u000b\r!\u0019\u0002C\n\r\u0001\u0015\u0019A1\u0004E\u0013\u0019\u0001)1\u0001b\u0005\t(1\u0001QA\u0001C\n\u0011O)!\u0001b\u0005\t)\u0015\u0011A!\u0003E\u0015\u000b\r!\u0001\u0003\u0003\f\r\u0001\u0015\u0019AQ\u0001\u0005\u0018\u0019\u0001)!\u0001B\u0005\t3\u0015\u0019A1\u0005E\u0019\u0019\u0001)1\u0001\u0002\n\t11\u0001Qa\u0001C\u0003\u0011ma\u0001!B\u0002\u0005\u0004!]B\u0002A\u0003\u0003\t\u0007A9$\u0002\u0002\u0005!!1RA\u0001C\u0012\u0011q)\u0011\u0001#\u000f\u0006\u0005\u0011-\u0002\"H\u0003\u0003\tYA1$B\u0002\u0005\u0003!uB\u0002A\u0003\u0003\t\u0005Ai\u0004\u0002\u0005\r\u0005e\u0011Q!\u0001\u0005\u0004[=!\u0001\r\u0002\r\tC\t)\u0011\u0001#\u0004V\u0007!)1\u0001\u0002\u0005\n\u0003!AQb\u0001\u0003\n\u0013\u0005A\u0001\"\f\u000b\u0005A\u0012A\u001a\"I\u0004\u0006\u0003!Q\u0001\u0003D\u000b\u0004\u000b\u0005A!\u0002$\u0001V\u0007!)1\u0001b\u0005\n\u0003!UQb\u0001C\r\u0013\u0005A)\"L\b\u0005A\u0012AR!\t\u0002\u0006\u0003!1Qk\u0001\u0005\u0006\u0007\u0011)\u0011\"\u0001E\b\u001b\r!Q\"C\u0001\t\u00105zA\u0001\u0019\u0003\u0019\t\u0005\u0012Q!\u0001E\u0004+\u000eAQa\u0001\u0003\u0005\u0013\u0005Aq!D\u0002\u0005\u001c%\t\u0001bB\u0017\u0010\t\u0001$\u0001DD\u0011\u0003\u000b\u0005A9\"V\u0002\t\u000b\r!a\"C\u0001\t\u00195\u0019AqD\u0005\u0002\u00111is\u0002\u00021\u00051A\t#!B\u0001\t\u001aU\u001b\u0001\"B\u0002\u0005!%\t\u0001\"D\u0007\u0004\tEI\u0011\u0001C\u0007.+\u0011\u0001\u00014EO\b\t\u0005A!#D\u0002\u0006\u0003!qA\u0012\u0001)\u0004\u0001\u0005\u001aQ!\u0001E\u000f\u0019\u0003\t6!\u0002C\u0012\u0013\u0005Aq\"D\u0001\t 5j\r\u0001\u0002\u0001\u0019*u5A\u0001\u0001\u0005\u0016\u001b\t)\u0011\u0001#\bQ\u0007\u0001ij\u0001B\u0001\t,5\u0011Q!\u0001E\u0011!\u000e\u0005QT\u0002\u0003\u0002\u0011[i!!B\u0001\t#A\u001b\u0011!(\u0004\u0005\u0003!=RBA\u0003\u0002\u0011K\u000161AO\u0007\t\u0005A\u0019$\u0004\u0002\u0006\u0003!\t\u0002k\u0001\u0002\u001e\u000e\u0011\t\u0001BG\u0007\u0003\u000b\u0005A\u0011\u0003UB\u0003;\u001f!\u0011\u0001#\u000e\u000e\u0007\u0015\t\u0001b\u0005G\u0001!\u000e\u0019\u0011EA\u0003\u0002\u0011O\t6!\u0005C\u0015\u0013\u0005AA#D\u0001\t\u001f5\t\u0001\u0012F\u0007\u0002\t\u0003i\u0011\u0001C\u000b\u000e\u0003\u0011\u0005Q\"\u0001C\u0001\u001b\u0005Ai#L\u0015\u0005\u0001amRT\u0002\u0003\u0002\u0011Wi!!B\u0001\t\"A\u001b\u0001!h\u0004\u0005\u0003!URbA\u0003\u0002\u0011Ma\t\u0001UB\u0001;\u001f!\u0011\u0001\u0003\u0010\u000e\u0007\u0015\t\u0001R\u0004G\u0001!\u000e\t\u0011eA\u0003\u0002\u0011]a\t!U\u0002\n\twI\u0011\u0001c\f\u000e\u0003!%R\"\u0001E\u0017\u001b\u0005Aq\"n\u0014\u0006N\u0011\u0019\u000f\u0001g\u0002\u001e\u000e\u0011\u0001\u0001\u0002B\u0007\u0003\u000b\u0005A9\u0001U\u0002\u0001;\u001b!\u0001\u0001C\u0003\u000e\u0005\u0015\t\u0001B\u0002)\u0004\u0002u5A!\u0001\u0005\t\u001b\t)\u0011\u0001#\u0004Q\u0007\u0005\t#!B\u0001\t\u0005E\u001b\u0011\u0002b\u0002\n\u0003\u0011\u0001Q\"\u0001\u0005\b\u001b\u0005Ay!D\u0001\t\u0011\u0001"})
public class Pull {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final Repository repository;
    private final StoredConfig config;
    @NotNull
    private final RemoteConfig remoteConfig;
    @NotNull
    private final GitRepositoryManager manager;
    @NotNull
    private final ProgressIndicator indicator;
    @NotNull
    private final CommitMessageFormatter commitMessageFormatter;

    static {
        $kotlinClass = Reflection.createKotlinClass(Pull.class);
    }

    @NotNull
    public final Repository getRepository() {
        return this.repository;
    }

    public final StoredConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final RemoteConfig getRemoteConfig() {
        return this.remoteConfig;
    }

    @Nullable
    public final UpdateResult pull(@JetValueParameter(name="mergeStrategy") @NotNull MergeStrategy mergeStrategy, @JetValueParameter(name="commitMessage", type="?") @Nullable String commitMessage, @JetValueParameter(name="prefetchedRefToMerge", type="?") @Nullable Ref prefetchedRefToMerge) {
        Ref ref;
        Intrinsics.checkParameterIsNotNull((Object)mergeStrategy, (String)"mergeStrategy");
        this.indicator.checkCanceled();
        SettingsRepositoryPackage$IcsManager$d5f67752.getLOG().debug("Pull");
        Repository repository = this.manager.getRepository();
        RepositoryState repositoryState = repository.getRepositoryState();
        if (Intrinsics.areEqual((Object)repositoryState, (Object)RepositoryState.SAFE) ^ true) {
            SettingsRepositoryPackage$IcsManager$d5f67752.getLOG().warn(MessageFormat.format(JGitText.get().cannotPullOnARepoWithState, repositoryState.name()));
        }
        if ((ref = prefetchedRefToMerge) == null) {
            ref = Pull.fetch$default(this, null, 1);
        }
        if (ref == null) {
            return null;
        }
        Ref refToMerge = ref;
        MergeResultEx mergeResult = Pull.merge$default(this, refToMerge, mergeStrategy, false, null, false, false, commitMessage, 60);
        MergeResult.MergeStatus mergeStatus = mergeResult.getMergeStatus();
        if (SettingsRepositoryPackage$IcsManager$d5f67752.getLOG().isDebugEnabled()) {
            SettingsRepositoryPackage$IcsManager$d5f67752.getLOG().debug(mergeStatus.toString());
        }
        if (Intrinsics.areEqual((Object)mergeStatus, (Object)MergeResult.MergeStatus.CONFLICTING)) {
            ObjectId[] mergedCommits = mergeResult.getMergedCommits();
            KotlinPackage.assert$default((((Object[])mergedCommits).length == 2 ? 1 : 0) != 0, null, (int)2);
            Map<String, MergeResult<?>> map = mergeResult.getConflicts();
            if (map == null) {
                Intrinsics.throwNpe();
            }
            Map<String, MergeResult<?>> conflicts = map;
            List<VirtualFile> unresolvedFiles = GitPackage$JGitMergeProvider$9ab22031.conflictsToVirtualFiles(conflicts);
            ObjectId objectId = mergedCommits[0];
            if (objectId == null) {
                Intrinsics.throwNpe();
            }
            ObjectId objectId2 = mergedCommits[1];
            if (objectId2 == null) {
                Intrinsics.throwNpe();
            }
            JGitMergeProvider mergeProvider = new JGitMergeProvider(repository, objectId, objectId2, conflicts);
            ArrayList<String> mergedFiles = new ArrayList<String>();
            while (true) {
                List<VirtualFile> resolvedFiles = SettingsRepositoryPackage$BaseRepositoryManager$f78edab6.resolveConflicts(unresolvedFiles, mergeProvider);
                for (VirtualFile file : resolvedFiles) {
                    mergedFiles.add(file.getPath());
                }
                if (resolvedFiles.size() == unresolvedFiles.size()) break;
                unresolvedFiles.removeAll((Collection)mergedFiles);
            }
            GitPackage$GitEx$3dc0a22d.commit$default(repository, null, null, null, null, 15);
            return mergeResult.getResult().toMutable().addChanged((Collection<? extends String>)mergedFiles);
        }
        if (!mergeStatus.isSuccessful()) {
            throw (Throwable)new IllegalStateException(mergeResult.toString());
        }
        return mergeResult.getResult();
    }

    @Nullable
    public static /* synthetic */ UpdateResult pull$default(Pull pull2, MergeStrategy mergeStrategy, String string, Ref ref, int n) {
        if ((n & 1) != 0) {
            ThreeWayMergeStrategy threeWayMergeStrategy = MergeStrategy.RECURSIVE;
            Intrinsics.checkExpressionValueIsNotNull((Object)threeWayMergeStrategy, (String)"MergeStrategy.RECURSIVE");
            mergeStrategy = (MergeStrategy)threeWayMergeStrategy;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            ref = null;
        }
        return pull2.pull(mergeStrategy, string, ref);
    }

    @Nullable
    public final Ref fetch(@JetValueParameter(name="prevRefUpdateResult", type="?") @Nullable RefUpdate.Result prevRefUpdateResult) {
        this.indicator.checkCanceled();
        Repository repository = this.manager.getRepository();
        FetchResult fetchResult = GitPackage$GitEx$3dc0a22d.fetch(repository, this.remoteConfig, this.manager.getCredentialsProvider(), GitPackage$JGitProgressMonitor$1fce68cd.asProgressMonitor(this.indicator));
        if (fetchResult == null) {
            return null;
        }
        FetchResult fetchResult2 = fetchResult;
        if (SettingsRepositoryPackage$IcsManager$d5f67752.getLOG().isDebugEnabled()) {
            GitPackage$GitRepositoryManager$849b556b.printMessages((OperationResult)fetchResult2);
            for (TrackingRefUpdate refUpdate : fetchResult2.getTrackingRefUpdates()) {
                SettingsRepositoryPackage$IcsManager$d5f67752.getLOG().debug(refUpdate.toString());
            }
        }
        this.indicator.checkCanceled();
        boolean hasChanges = false;
        for (RefSpec fetchRefSpec : this.remoteConfig.getFetchRefSpecs()) {
            TrackingRefUpdate refUpdate = fetchResult2.getTrackingRefUpdate(fetchRefSpec.getDestination());
            if (refUpdate == null) {
                SettingsRepositoryPackage$IcsManager$d5f67752.getLOG().debug("No ref update for " + fetchRefSpec);
                continue;
            }
            RefUpdate.Result refUpdateResult = refUpdate.getResult();
            if (Intrinsics.areEqual((Object)refUpdateResult, (Object)RefUpdate.Result.LOCK_FAILURE) || Intrinsics.areEqual((Object)refUpdateResult, (Object)RefUpdate.Result.IO_FAILURE)) {
                if (Intrinsics.areEqual((Object)prevRefUpdateResult, (Object)refUpdateResult)) {
                    throw (Throwable)new IOException("Ref update result " + refUpdateResult.name() + ", we have already tried to fetch again, but no luck");
                }
                SettingsRepositoryPackage$IcsManager$d5f67752.getLOG().warn("Ref update result " + refUpdateResult.name() + ", trying again after 500 ms");
                Thread.sleep(500L);
                return this.fetch(refUpdateResult);
            }
            if (!(Intrinsics.areEqual((Object)refUpdateResult, (Object)RefUpdate.Result.FAST_FORWARD) || Intrinsics.areEqual((Object)refUpdateResult, (Object)RefUpdate.Result.NEW) || Intrinsics.areEqual((Object)refUpdateResult, (Object)RefUpdate.Result.FORCED))) {
                throw (Throwable)new UnsupportedOperationException("Unsupported ref update result");
            }
            if (hasChanges) continue;
            hasChanges = Intrinsics.areEqual((Object)refUpdateResult, (Object)RefUpdate.Result.NO_CHANGE) ^ true;
        }
        if (!hasChanges) {
            SettingsRepositoryPackage$IcsManager$d5f67752.getLOG().debug("No remote changes");
            return null;
        }
        Ref ref = fetchResult2.getAdvertisedRef(GitPackage$GitEx$3dc0a22d.getRemoteBranchFullName((Config)this.config));
        if (ref == null) {
            throw (Throwable)new IllegalStateException("Could not get advertised ref");
        }
        return ref;
    }

    @Nullable
    public static /* synthetic */ Ref fetch$default(Pull pull2, RefUpdate.Result result, int n) {
        if ((n & 1) != 0) {
            result = null;
        }
        return pull2.fetch(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @NotNull
    public final MergeResultEx merge(@JetValueParameter(name="unpeeledRef") @NotNull Ref unpeeledRef, @JetValueParameter(name="mergeStrategy") @NotNull MergeStrategy mergeStrategy, @JetValueParameter(name="commit") boolean commit, @JetValueParameter(name="fastForwardMode") @NotNull MergeCommand.FastForwardMode fastForwardMode, @JetValueParameter(name="squash") boolean squash, @JetValueParameter(name="forceMerge") boolean forceMerge, @JetValueParameter(name="commitMessage", type="?") @Nullable String commitMessage) {
        Intrinsics.checkParameterIsNotNull((Object)unpeeledRef, (String)"unpeeledRef");
        Intrinsics.checkParameterIsNotNull((Object)mergeStrategy, (String)"mergeStrategy");
        Intrinsics.checkParameterIsNotNull((Object)fastForwardMode, (String)"fastForwardMode");
        this.indicator.checkCanceled();
        v0 = this.repository.getRef(Constants.HEAD);
        if (v0 == null) {
            throw (Throwable)new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
        }
        head = v0;
        revWalk = new RevWalk(this.repository);
        dirCacheCheckout = null;
        try {
            ref = this.repository.peel(unpeeledRef);
            objectId = ref.getPeeledObjectId();
            if (objectId == null) {
                objectId = ref.getObjectId();
            }
            srcCommit = revWalk.lookupCommit((AnyObjectId)objectId);
            headId = head.getObjectId();
            if (headId == null) {
                revWalk.parseHeaders((RevObject)srcCommit);
                dirCacheCheckout = new DirCacheCheckout(this.repository, this.repository.lockDirCache(), (ObjectId)srcCommit.getTree());
                dirCacheCheckout.setFailOnConflict(true);
                dirCacheCheckout.checkout();
                refUpdate = this.repository.updateRef(head.getTarget().getName());
                refUpdate.setNewObjectId((AnyObjectId)objectId);
                refUpdate.setExpectedOldObjectId((AnyObjectId)null);
                refUpdate.setRefLogMessage("initial pull", false);
                if (Intrinsics.areEqual((Object)refUpdate.update(), (Object)RefUpdate.Result.NEW) ^ true) {
                    throw (Throwable)new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                }
                v1 = (ObjectId)srcCommit;
                v2 = new ObjectId[]{null, (ObjectId)srcCommit};
                v3 = dirCacheCheckout.getUpdated().keySet();
                v4 = dirCacheCheckout.getRemoved();
                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"dirCacheCheckout.getRemoved()");
                var16_19 = new MergeResultEx(v1, MergeResult.MergeStatus.FAST_FORWARD, v2, new ImmutableUpdateResult(v3, v4), null, 16, null);
                return var16_19;
            }
            refLogMessage = new StringBuilder("merge ");
            refLogMessage.append(ref.getName());
            headCommit = revWalk.lookupCommit((AnyObjectId)headId);
            if (!forceMerge && revWalk.isMergedInto(srcCommit, headCommit)) {
                var17_21 = new MergeResultEx((ObjectId)headCommit, MergeResult.MergeStatus.ALREADY_UP_TO_DATE, new ObjectId[]{(ObjectId)headCommit, (ObjectId)srcCommit}, SettingsRepositoryPackage$RepositoryManager$a8a6e2c5.getEMPTY_UPDATE_RESULT(), null, 16, null);
                return var17_21;
            }
            if (!forceMerge && Intrinsics.areEqual((Object)fastForwardMode, (Object)MergeCommand.FastForwardMode.NO_FF) ^ true && revWalk.isMergedInto(headCommit, srcCommit)) {
                refLogMessage.append(": ").append(MergeResult.MergeStatus.FAST_FORWARD);
                dirCacheCheckout = new DirCacheCheckout(this.repository, (ObjectId)headCommit.getTree(), this.repository.lockDirCache(), (ObjectId)srcCommit.getTree());
                dirCacheCheckout.setFailOnConflict(true);
                dirCacheCheckout.checkout();
                if (squash) {
                    newHead = headId;
                    mergeStatus = MergeResult.MergeStatus.FAST_FORWARD_SQUASHED;
                    squashedCommits = RevWalkUtils.find((RevWalk)revWalk, (RevCommit)srcCommit, (RevCommit)headCommit);
                    this.repository.writeSquashCommitMsg(new SquashMessageFormatter().format((List)squashedCommits, head));
                } else {
                    v5 = (ObjectId)srcCommit;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"srcCommit");
                    GitPackage$pull$76315817.updateHead(refLogMessage, v5, headId, this.repository);
                    v6 = srcCommit;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"srcCommit");
                    newHead = (ObjectId)v6;
                    mergeStatus = MergeResult.MergeStatus.FAST_FORWARD;
                }
                v7 = new ObjectId[]{(ObjectId)headCommit, (ObjectId)srcCommit};
                v8 = dirCacheCheckout.getUpdated().keySet();
                v9 = dirCacheCheckout.getRemoved();
                Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"dirCacheCheckout.getRemoved()");
                squashedCommits = new MergeResultEx(newHead, mergeStatus, v7, new ImmutableUpdateResult(v8, v9), null, 16, null);
                return squashedCommits;
            }
            if (Intrinsics.areEqual((Object)fastForwardMode, (Object)MergeCommand.FastForwardMode.FF_ONLY)) {
                newHead = new MergeResultEx((ObjectId)headCommit, MergeResult.MergeStatus.ABORTED, new ObjectId[]{(ObjectId)headCommit, (ObjectId)srcCommit}, SettingsRepositoryPackage$RepositoryManager$a8a6e2c5.getEMPTY_UPDATE_RESULT(), null, 16, null);
                return newHead;
            }
            if (squash) {
                mergeMessage = "";
                this.repository.writeSquashCommitMsg(new SquashMessageFormatter().format(RevWalkUtils.find((RevWalk)revWalk, (RevCommit)srcCommit, (RevCommit)headCommit), head));
            } else {
                mergeMessage = this.commitMessageFormatter.mergeMessage(KotlinPackage.listOf((Object)ref), head);
                this.repository.writeMergeCommitMsg(mergeMessage);
                this.repository.writeMergeHeads((List)KotlinPackage.arrayListOf((Object[])new ObjectId[]{ref.getObjectId()}));
            }
            merger = mergeStrategy.newMerger(this.repository);
            lowLevelResults = null;
            failingPaths = null;
            unmergedPaths = null;
            if (merger instanceof ResolveMerger) {
                ((ResolveMerger)merger).setCommitNames(new String[]{"BASE", "HEAD", ref.getName()});
                ((ResolveMerger)merger).setWorkingTreeIterator((WorkingTreeIterator)new FileTreeIterator(this.repository));
                noProblems = ((ResolveMerger)merger).merge(new AnyObjectId[]{(AnyObjectId)headCommit, (AnyObjectId)srcCommit});
                lowLevelResults = ((ResolveMerger)merger).getMergeResults();
                failingPaths = ((ResolveMerger)merger).getFailingPaths();
                unmergedPaths = ((ResolveMerger)merger).getUnmergedPaths();
            } else {
                noProblems = merger.merge(new AnyObjectId[]{(AnyObjectId)headCommit, (AnyObjectId)srcCommit});
            }
            refLogMessage.append(": Merge made by ");
            refLogMessage.append(revWalk.isMergedInto(headCommit, srcCommit) != false ? "recursive" : mergeStrategy.getName());
            refLogMessage.append('.');
            if (merger instanceof ResolveMerger) {
                v10 = ((ResolveMerger)merger).getToBeCheckedOut().keySet();
                v11 = ((ResolveMerger)merger).getToBeDeleted();
                Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"merger.getToBeDeleted()");
                v12 = new ImmutableUpdateResult(v10, v11);
            } else {
                v12 = result = (ImmutableUpdateResult)null;
            }
            if (noProblems) {
                if (!(merger instanceof ResolveMerger)) {
                    dirCacheCheckout = new DirCacheCheckout(this.repository, (ObjectId)headCommit.getTree(), this.repository.lockDirCache(), merger.getResultTreeId());
                    dirCacheCheckout.setFailOnConflict(true);
                    dirCacheCheckout.checkout();
                    v13 = dirCacheCheckout.getUpdated().keySet();
                    v14 = dirCacheCheckout.getRemoved();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v14, (String)"dirCacheCheckout.getRemoved()");
                    result = new ImmutableUpdateResult(v13, v14);
                }
                newHeadId = null;
                mergeStatus = null;
                if (!commit && squash) {
                    mergeStatus = MergeResult.MergeStatus.MERGED_SQUASHED_NOT_COMMITTED;
                }
                if (!commit && !squash) {
                    mergeStatus = MergeResult.MergeStatus.MERGED_NOT_COMMITTED;
                }
                if (commit && !squash) {
                    newHeadId = GitPackage$GitEx$3dc0a22d.commit$default(this.repository, commitMessage, refLogMessage.toString(), null, null, 12).getId();
                    mergeStatus = MergeResult.MergeStatus.MERGED;
                }
                if (commit && squash) {
                    newHeadId = headCommit.getId();
                    mergeStatus = MergeResult.MergeStatus.MERGED_SQUASHED;
                }
                v15 = mergeStatus;
                if (v15 == null) {
                    Intrinsics.throwNpe();
                }
                v16 = new ObjectId[]{headCommit.getId(), srcCommit.getId()};
                v17 = result;
                if (v17 == null) {
                    Intrinsics.throwNpe();
                }
                var26_37 = new MergeResultEx(newHeadId, v15, v16, v17, null, 16, null);
                return var26_37;
            }
            if (failingPaths == null) {
                this.repository.writeMergeCommitMsg(new MergeMessageFormatter().formatWithConflicts(mergeMessage, unmergedPaths));
                v18 = null;
                v19 = new ObjectId[]{headCommit.getId(), srcCommit.getId()};
                v20 = result;
                if (v20 == null) {
                    Intrinsics.throwNpe();
                }
                var24_34 = new MergeResultEx(v18, MergeResult.MergeStatus.CONFLICTING, v19, v20, lowLevelResults);
                return var24_34;
            }
            this.repository.writeMergeCommitMsg((String)null);
            this.repository.writeMergeHeads((List)null);
            v21 = null;
            v22 = new ObjectId[]{headCommit.getId(), srcCommit.getId()};
            v23 = result;
            if (v23 == null) {
                Intrinsics.throwNpe();
            }
            var24_35 = new MergeResultEx(v21, MergeResult.MergeStatus.FAILED, v22, v23, lowLevelResults);
            ** try [egrp 7[TRYBLOCK] [15 : 1608->1642)] { 
        }
lbl166:
        // 1 sources

        catch (Throwable var11_13) {
            throw var11_13;
        }
        finally {
            revWalk.close();
        }
lbl-1000:
        // 1 sources

        {
            try {
                return var24_35;
            }
            catch (CheckoutConflictException e) {
                throw (Throwable)new org.eclipse.jgit.api.errors.CheckoutConflictException(dirCacheCheckout == null ? KotlinPackage.listOf() : dirCacheCheckout.getConflicts(), e);
            }
        }
    }

    @NotNull
    public static /* synthetic */ MergeResultEx merge$default(Pull pull2, Ref ref, MergeStrategy mergeStrategy, boolean bl, MergeCommand.FastForwardMode fastForwardMode, boolean bl2, boolean bl3, String string, int n) {
        if ((n & 2) != 0) {
            ThreeWayMergeStrategy threeWayMergeStrategy = MergeStrategy.RECURSIVE;
            Intrinsics.checkExpressionValueIsNotNull((Object)threeWayMergeStrategy, (String)"MergeStrategy.RECURSIVE");
            mergeStrategy = (MergeStrategy)threeWayMergeStrategy;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            fastForwardMode = MergeCommand.FastForwardMode.FF;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x20) != 0) {
            bl3 = false;
        }
        if ((n & 0x40) != 0) {
            string = null;
        }
        return pull2.merge(ref, mergeStrategy, bl, fastForwardMode, bl2, bl3, string);
    }

    @NotNull
    public final GitRepositoryManager getManager() {
        return this.manager;
    }

    @NotNull
    public final ProgressIndicator getIndicator() {
        return this.indicator;
    }

    @NotNull
    public final CommitMessageFormatter getCommitMessageFormatter() {
        return this.commitMessageFormatter;
    }

    public Pull(@JetValueParameter(name="manager") @NotNull GitRepositoryManager manager, @JetValueParameter(name="indicator") @NotNull ProgressIndicator indicator, @JetValueParameter(name="commitMessageFormatter") @NotNull CommitMessageFormatter commitMessageFormatter) {
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        Intrinsics.checkParameterIsNotNull((Object)commitMessageFormatter, (String)"commitMessageFormatter");
        this.manager = manager;
        this.indicator = indicator;
        this.commitMessageFormatter = commitMessageFormatter;
        this.repository = this.manager.getRepository();
        this.config = this.repository.getConfig();
        this.remoteConfig = new RemoteConfig((Config)this.config, Constants.DEFAULT_REMOTE_NAME);
    }

    public /* synthetic */ Pull(GitRepositoryManager gitRepositoryManager, ProgressIndicator progressIndicator, CommitMessageFormatter commitMessageFormatter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            commitMessageFormatter = new IdeaCommitMessageFormatter();
        }
        this(gitRepositoryManager, progressIndicator, commitMessageFormatter);
    }
}

