/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInsight;

import com.intellij.codeInsight.daemon.quickFix.ExternalLibraryDescriptor;
import com.intellij.codeInsight.daemon.quickFix.ExternalLibraryResolver;
import com.intellij.execution.junit.JUnit3Framework;
import com.intellij.execution.junit.JUnit4Framework;
import com.intellij.openapi.module.Module;
import com.intellij.testIntegration.JavaTestFramework;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitExternalLibraryResolver
extends ExternalLibraryResolver {
    public static final ExternalLibraryDescriptor JUNIT3 = JUnitExternalLibraryResolver.createJUnitDescriptor("3", JUnit3Framework.class);
    public static final ExternalLibraryDescriptor JUNIT4 = JUnitExternalLibraryResolver.createJUnitDescriptor("4", JUnit4Framework.class);
    private static Set<String> JUNIT4_ANNOTATIONS = ContainerUtil.set((Object[])new String[]{"Test", "Ignore", "RunWith", "Before", "BeforeClass", "After", "AfterClass"});

    @NotNull
    private static ExternalLibraryDescriptor createJUnitDescriptor(final String version, final Class<? extends JavaTestFramework> frameworkClass) {
        ExternalLibraryDescriptor externalLibraryDescriptor = new ExternalLibraryDescriptor("junit", "junit", version){

            @NotNull
            public List<String> locateLibraryClassesRoots(@NotNull Module contextModule) {
                if (contextModule == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextModule", "com/intellij/execution/junit/codeInsight/JUnitExternalLibraryResolver$1", "locateLibraryClassesRoots"));
                }
                List list = ((JavaTestFramework)TestFramework.EXTENSION_NAME.findExtension(frameworkClass)).getLibraryPaths();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/codeInsight/JUnitExternalLibraryResolver$1", "locateLibraryClassesRoots"));
                }
                return list;
            }

            public String getPresentableName() {
                return "JUnit" + version;
            }
        };
        if (externalLibraryDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/codeInsight/JUnitExternalLibraryResolver", "createJUnitDescriptor"));
        }
        return externalLibraryDescriptor;
    }

    @Nullable
    public ExternalLibraryResolver.ExternalClassResolveResult resolveClass(@NotNull String shortClassName, @NotNull ThreeState isAnnotation) {
        if (shortClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortClassName", "com/intellij/execution/junit/codeInsight/JUnitExternalLibraryResolver", "resolveClass"));
        }
        if (isAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isAnnotation", "com/intellij/execution/junit/codeInsight/JUnitExternalLibraryResolver", "resolveClass"));
        }
        if ("TestCase".equals(shortClassName)) {
            return new ExternalLibraryResolver.ExternalClassResolveResult("junit.framework.TestCase", JUNIT3);
        }
        if (isAnnotation == ThreeState.YES && JUNIT4_ANNOTATIONS.contains(shortClassName)) {
            return new ExternalLibraryResolver.ExternalClassResolveResult("org.junit." + shortClassName, JUNIT4);
        }
        return null;
    }

    @Nullable
    public ExternalLibraryDescriptor resolvePackage(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/execution/junit/codeInsight/JUnitExternalLibraryResolver", "resolvePackage"));
        }
        if (packageName.equals("org.junit")) {
            return JUNIT4;
        }
        if (packageName.equals("junit.framework")) {
            return JUNIT3;
        }
        return null;
    }
}

