/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.TailTypes;
import com.intellij.codeInsight.completion.BasicExpressionCompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionVariant;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaAwareCompletionData;
import com.intellij.codeInsight.completion.JavaMemberNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.ModifierChooser;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassLevelDeclarationStatement;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ContentFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.NotFilter;
import com.intellij.psi.filters.OrFilter;
import com.intellij.psi.filters.ScopeFilter;
import com.intellij.psi.filters.TextFilter;
import com.intellij.psi.filters.classes.EnumOrAnnotationTypeFilter;
import com.intellij.psi.filters.classes.InterfaceFilter;
import com.intellij.psi.filters.getters.JavaMembersGetter;
import com.intellij.psi.filters.position.AfterElementFilter;
import com.intellij.psi.filters.position.BeforeElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.filters.position.InsideElementFilter;
import com.intellij.psi.filters.position.LeftNeighbour;
import com.intellij.psi.filters.position.ParentElementFilter;
import com.intellij.psi.filters.position.StartElementFilter;
import com.intellij.psi.filters.position.SuperParentFilter;
import com.intellij.psi.filters.position.TokenTypeFilter;
import com.intellij.psi.impl.source.jsp.jspJava.JspClassLevelDeclarationStatement;
import com.intellij.psi.jsp.JspElementType;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JavaCompletionData
extends JavaAwareCompletionData {
    @NonNls
    private static final String[] BLOCK_FINALIZERS = new String[]{"{", "}", ";", ":", "else"};
    public static final ElementPattern<PsiElement> AFTER_DOT = PsiJavaPatterns.psiElement().afterLeaf(new String[]{"."});
    public static final PsiJavaElementPattern.Capture<PsiElement> VARIABLE_AFTER_FINAL = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"final"})).inside(PsiDeclarationStatement.class);
    public static final LeftNeighbour AFTER_TRY_BLOCK = new LeftNeighbour(new AndFilter((ElementFilter)new TextFilter("}"), (ElementFilter)new ParentElementFilter(new AndFilter((ElementFilter)new LeftNeighbour(new TextFilter("try")), (ElementFilter)new ParentElementFilter(new ClassFilter(PsiTryStatement.class))))));
    private static final PsiJavaElementPattern.Capture<PsiElement> INSIDE_PARAMETER_LIST = (PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiJavaCodeReferenceElement.class).insideStarting((ElementPattern)PsiJavaPatterns.psiElement().withTreeParent((ElementPattern)PsiJavaPatterns.psiElement(PsiParameterList.class).andNot((ElementPattern)PsiJavaPatterns.psiElement(PsiAnnotationParameterList.class)))));
    private static final AndFilter START_OF_CODE_FRAGMENT = new AndFilter((ElementFilter)new ScopeFilter(new AndFilter(new ClassFilter(JavaCodeFragment.class), new ClassFilter(PsiExpressionCodeFragment.class, false), new ClassFilter(PsiJavaCodeReferenceCodeFragment.class, false), new ClassFilter(PsiTypeCodeFragment.class, false))), (ElementFilter)new StartElementFilter());
    static final NotNullLazyValue<ElementFilter> END_OF_BLOCK = new AtomicNotNullLazyValue<ElementFilter>(){

        @NotNull
        protected ElementFilter compute() {
            OrFilter orFilter = new OrFilter(new AndFilter((ElementFilter)new LeftNeighbour(new OrFilter(new AndFilter((ElementFilter)new TextFilter(BLOCK_FINALIZERS), (ElementFilter)new NotFilter(new SuperParentFilter(new ClassFilter(PsiAnnotation.class)))), new TextFilter("*/"), new TokenTypeFilter(JspElementType.HOLDER_TEMPLATE_DATA), new ClassFilter(OuterLanguageElement.class), new AndFilter((ElementFilter)new TextFilter(")"), (ElementFilter)new NotFilter(new OrFilter(new ParentElementFilter(new ClassFilter(PsiExpressionList.class)), new ParentElementFilter(new ClassFilter(PsiParameterList.class)), new ParentElementFilter(new ClassFilter(PsiTypeCastExpression.class))))))), (ElementFilter)new NotFilter(new TextFilter("."))), START_OF_CODE_FRAGMENT);
            if (orFilter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionData$1", "compute"));
            }
            return orFilter;
        }
    };
    static final ElementPattern<PsiElement> START_SWITCH = PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("{")).withParents(new Class[]{PsiCodeBlock.class, PsiSwitchStatement.class}));
    private static final ElementPattern<PsiElement> SUPER_OR_THIS_PATTERN = PsiJavaPatterns.and((ElementPattern[])new ElementPattern[]{JavaSmartCompletionContributor.INSIDE_EXPRESSION, StandardPatterns.not((ElementPattern)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"case"})), StandardPatterns.not((ElementPattern)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText(".")).afterLeaf(new String[]{"this", "super"}))), StandardPatterns.not((ElementPattern)PsiJavaPatterns.psiElement().inside(PsiAnnotation.class)), StandardPatterns.not(START_SWITCH), StandardPatterns.not(JavaMemberNameCompletionContributor.INSIDE_TYPE_PARAMS_PATTERN)});
    private static final String[] PRIMITIVE_TYPES = new String[]{"short", "boolean", "double", "long", "int", "float", "char", "byte"};
    private static final NotNullLazyValue<ElementFilter> CLASS_BODY = new AtomicNotNullLazyValue<ElementFilter>(){

        @NotNull
        protected ElementFilter compute() {
            OrFilter orFilter = new OrFilter(new AfterElementFilter(new TextFilter("{")), new ScopeFilter(new ClassFilter(JspClassLevelDeclarationStatement.class)));
            if (orFilter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionData$2", "compute"));
            }
            return orFilter;
        }
    };
    public static final ElementPattern<PsiElement> START_FOR = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("(")).afterLeaf(new String[]{"for"}))).withParents(new Class[]{PsiJavaCodeReferenceElement.class, PsiExpressionStatement.class, PsiForStatement.class});
    private static final PsiJavaElementPattern.Capture<PsiElement> CLASS_REFERENCE = (PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiReferenceExpression().referencing((ElementPattern)PsiJavaPatterns.psiClass().andNot((ElementPattern)PsiJavaPatterns.psiElement(PsiTypeParameter.class))));
    private static final ElementPattern<PsiElement> EXPR_KEYWORDS = PsiJavaPatterns.and((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiReferenceExpression.class).withParent((ElementPattern)StandardPatterns.not((ElementPattern)PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiTypeCastExpression.class), PsiJavaPatterns.psiElement(PsiSwitchLabelStatement.class), PsiJavaPatterns.psiElement(PsiExpressionStatement.class), PsiJavaPatterns.psiElement(PsiPrefixExpression.class)})))), StandardPatterns.not((ElementPattern)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"."}))});
    public static final NotNullLazyValue<ElementPattern<PsiElement>> DECLARATION_START = new NotNullLazyValue<ElementPattern<PsiElement>>(){

        @NotNull
        protected ElementPattern<PsiElement> compute() {
            ObjectPattern objectPattern = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().andNot((ElementPattern)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"@", "."}))).andOr(new ElementPattern[]{((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().and((ElementPattern)new FilterPattern((ElementFilter)CLASS_BODY.getValue()))).andOr(new ElementPattern[]{new FilterPattern((ElementFilter)END_OF_BLOCK.getValue()), PsiJavaPatterns.psiElement().afterLeaf(PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement().inside(PsiModifierList.class), ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withElementType(JavaTokenType.GT)).inside(PsiTypeParameterList.class)}))}), PsiJavaPatterns.psiElement().withParents(new Class[]{PsiJavaCodeReferenceElement.class, PsiTypeElement.class, PsiMember.class}), PsiJavaPatterns.psiElement().withParents(new Class[]{PsiJavaCodeReferenceElement.class, PsiTypeElement.class, PsiClassLevelDeclarationStatement.class})});
            if (objectPattern == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionData$3", "compute"));
            }
            return objectPattern;
        }
    };

    public static boolean isInsideParameterList(PsiElement position) {
        PsiElement prev = PsiTreeUtil.prevVisibleLeaf((PsiElement)position);
        PsiModifierList modifierList = (PsiModifierList)PsiTreeUtil.getParentOfType((PsiElement)prev, PsiModifierList.class);
        if (modifierList != null) {
            if (PsiTreeUtil.isAncestor((PsiElement)modifierList, (PsiElement)position, (boolean)false)) {
                return false;
            }
            PsiElement parent = modifierList.getParent();
            return parent instanceof PsiParameterList || parent instanceof PsiParameter && parent.getParent() instanceof PsiParameterList;
        }
        return INSIDE_PARAMETER_LIST.accepts((Object)position);
    }

    public JavaCompletionData() {
        this.declareCompletionSpaces();
        this.initVariantsInFileScope();
        this.initVariantsInClassScope();
        this.initVariantsInMethodScope();
        this.defineScopeEquivalence(PsiMethod.class, PsiClassInitializer.class);
        this.defineScopeEquivalence(PsiMethod.class, JavaCodeFragment.class);
    }

    private void declareCompletionSpaces() {
        this.declareFinalScope(PsiFile.class);
        CompletionVariant variant = new CompletionVariant((ElementFilter)CLASS_BODY.getValue());
        variant.includeScopeClass(PsiClass.class, true);
        this.registerVariant(variant);
        variant = new CompletionVariant(new AndFilter((ElementFilter)new InsideElementFilter(new ClassFilter(PsiCodeBlock.class)), (ElementFilter)new NotFilter(new InsideElementFilter(new ClassFilter(JspClassLevelDeclarationStatement.class)))));
        variant.includeScopeClass(PsiMethod.class, true);
        variant.includeScopeClass(PsiClassInitializer.class, true);
        this.registerVariant(variant);
        variant = new CompletionVariant(new AfterElementFilter(new TextFilter("=")));
        variant.includeScopeClass(PsiField.class, true);
        this.registerVariant(variant);
        this.declareFinalScope(PsiLiteralExpression.class);
        this.declareFinalScope(PsiComment.class);
    }

    protected void initVariantsInFileScope() {
    }

    protected void initVariantsInClassScope() {
        AndFilter position = new AndFilter(new NotFilter((ElementFilter)CLASS_BODY.getValue()), new NotFilter(new AfterElementFilter(new ContentFilter(new TextFilter("extends")))), new NotFilter(new AfterElementFilter(new ContentFilter(new TextFilter("implements")))), new NotFilter(new LeftNeighbour(new LeftNeighbour(new TextFilter("<", ",")))), new NotFilter(new ScopeFilter(new EnumOrAnnotationTypeFilter())), new LeftNeighbour(new OrFilter(new ClassFilter(PsiIdentifier.class), new TextFilter(">"))));
        CompletionVariant variant = new CompletionVariant(position);
        variant.includeScopeClass(PsiClass.class, true);
        variant.addCompletion("extends", TailType.HUMBLE_SPACE_BEFORE_WORD);
        variant.excludeScopeClass(PsiAnonymousClass.class);
        variant.excludeScopeClass(PsiTypeParameter.class);
        this.registerVariant(variant);
        position = new AndFilter(new NotFilter((ElementFilter)CLASS_BODY.getValue()), new NotFilter(new BeforeElementFilter(new ContentFilter(new TextFilter("extends")))), new NotFilter(new AfterElementFilter(new ContentFilter(new TextFilter("implements")))), new NotFilter(new LeftNeighbour(new LeftNeighbour(new TextFilter("<", ",")))), new LeftNeighbour(new OrFilter(new ClassFilter(PsiIdentifier.class), new TextFilter(">"))), new NotFilter(new ScopeFilter(new InterfaceFilter())));
        variant = new CompletionVariant(position);
        variant.includeScopeClass(PsiClass.class, true);
        variant.addCompletion("implements", TailType.HUMBLE_SPACE_BEFORE_WORD);
        variant.excludeScopeClass(PsiAnonymousClass.class);
        this.registerVariant(variant);
        CompletionVariant variant2 = new CompletionVariant(PsiElement.class, (ElementPattern)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)PsiJavaPatterns.psiElement(PsiIdentifier.class).afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText((ElementPattern)PsiJavaPatterns.string().oneOf(new String[]{",", "<"}))).withParent(PsiTypeParameterList.class))));
        variant2.addCompletion("extends", TailType.HUMBLE_SPACE_BEFORE_WORD);
        this.registerVariant(variant2);
    }

    private void initVariantsInMethodScope() {
        LeftNeighbour position = new LeftNeighbour(new AndFilter((ElementFilter)new TextFilter(")"), (ElementFilter)new ParentElementFilter(new ClassFilter(PsiParameterList.class))));
        CompletionVariant variant = new CompletionVariant(PsiMethod.class, position);
        variant.includeScopeClass(PsiClass.class);
        variant.addCompletion("throws");
        this.registerVariant(variant);
        variant = new CompletionVariant(PsiAnnotationMethod.class, position);
        variant.addCompletion("default");
        this.registerVariant(variant);
        CompletionVariant variant2 = new CompletionVariant(PsiMethod.class, new LeftNeighbour(new TextFilter("return")));
        variant2.addCompletion("true", TailType.NONE);
        variant2.addCompletion("false", TailType.NONE);
        this.registerVariant(variant2);
        position = AFTER_TRY_BLOCK;
        variant = new CompletionVariant(position);
        variant.includeScopeClass(PsiCodeBlock.class, true);
        variant.addCompletion("catch", TailTypes.CATCH_LPARENTH);
        variant.addCompletion("finally", TailTypes.FINALLY_LBRACE);
        this.registerVariant(variant);
        position = new LeftNeighbour(new AndFilter((ElementFilter)new TextFilter("}"), (ElementFilter)new ParentElementFilter(new AndFilter((ElementFilter)new LeftNeighbour(new NotFilter(new TextFilter("try"))), (ElementFilter)new OrFilter(new ParentElementFilter(new ClassFilter(PsiTryStatement.class)), new ParentElementFilter(new ClassFilter(PsiCatchSection.class)))))));
        variant = new CompletionVariant(position);
        variant.includeScopeClass(PsiCodeBlock.class, false);
        variant.addCompletion("catch", TailTypes.CATCH_LPARENTH);
        variant.addCompletion("finally", TailTypes.FINALLY_LBRACE);
        this.registerVariant(variant);
        position = new LeftNeighbour(new OrFilter(new AndFilter((ElementFilter)new TextFilter("}"), (ElementFilter)new ParentElementFilter(new ClassFilter(PsiIfStatement.class), 3)), new AndFilter((ElementFilter)new TextFilter(";"), (ElementFilter)new ParentElementFilter(new ClassFilter(PsiIfStatement.class), 2))));
        variant = new CompletionVariant(PsiMethod.class, position);
        variant.addCompletion("else");
        this.registerVariant(variant);
    }

    private static TailType getReturnTail(PsiElement position) {
        PsiElement scope = position;
        while (!(scope instanceof PsiFile) && !(scope instanceof PsiClassInitializer)) {
            if (scope instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)scope;
                if (method.isConstructor() || PsiType.VOID.equals((Object)method.getReturnType())) {
                    return TailType.SEMICOLON;
                }
                return TailType.HUMBLE_SPACE_BEFORE_WORD;
            }
            if (scope instanceof PsiLambdaExpression) {
                PsiType returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiLambdaExpression)scope));
                if (PsiType.VOID.equals((Object)returnType)) {
                    return TailType.SEMICOLON;
                }
                return TailType.HUMBLE_SPACE_BEFORE_WORD;
            }
            scope = scope.getParent();
        }
        return TailType.NONE;
    }

    private static void addStatementKeywords(Consumer<LookupElement> variant, PsiElement position) {
        variant.consume((Object)new OverrideableSpace(JavaCompletionData.createKeyword(position, "switch"), TailTypes.SWITCH_LPARENTH));
        variant.consume((Object)new OverrideableSpace(JavaCompletionData.createKeyword(position, "while"), TailTypes.WHILE_LPARENTH));
        variant.consume((Object)new OverrideableSpace(JavaCompletionData.createKeyword(position, "do"), TailTypes.DO_LBRACE));
        variant.consume((Object)new OverrideableSpace(JavaCompletionData.createKeyword(position, "for"), TailTypes.FOR_LPARENTH));
        variant.consume((Object)new OverrideableSpace(JavaCompletionData.createKeyword(position, "if"), TailTypes.IF_LPARENTH));
        variant.consume((Object)new OverrideableSpace(JavaCompletionData.createKeyword(position, "try"), TailTypes.TRY_LBRACE));
        variant.consume((Object)new OverrideableSpace(JavaCompletionData.createKeyword(position, "throw"), TailType.INSERT_SPACE));
        variant.consume((Object)new OverrideableSpace(JavaCompletionData.createKeyword(position, "new"), TailType.INSERT_SPACE));
        variant.consume((Object)new OverrideableSpace(JavaCompletionData.createKeyword(position, "synchronized"), TailTypes.SYNCHRONIZED_LPARENTH));
        if (PsiUtil.getLanguageLevel((PsiElement)position).isAtLeast(LanguageLevel.JDK_1_4)) {
            variant.consume((Object)new OverrideableSpace(JavaCompletionData.createKeyword(position, "assert"), TailType.INSERT_SPACE));
        }
        TailType returnTail = JavaCompletionData.getReturnTail(position);
        Object ret = JavaCompletionData.createKeyword(position, "return");
        if (returnTail != TailType.NONE) {
            ret = new OverrideableSpace((LookupElement)ret, returnTail);
        }
        variant.consume(ret);
    }

    public void fillCompletions(CompletionParameters parameters, Consumer<LookupElement> result) {
        PsiFile file;
        PsiTryStatement tryStatement;
        PsiElement position = parameters.getPosition();
        if (PsiTreeUtil.getParentOfType((PsiElement)position, PsiComment.class, (boolean)false) != null) {
            return;
        }
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)position, PsiExpressionStatement.class);
        if (statement == null) {
            statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)position, PsiDeclarationStatement.class);
        }
        PsiElement prevLeaf = PsiTreeUtil.prevVisibleLeaf((PsiElement)position);
        if (!(statement == null || statement.getTextRange().getStartOffset() != position.getTextRange().getStartOffset() || ((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withSuperParent(2, PsiSwitchStatement.class)).afterLeaf(new String[]{"{"})).accepts((Object)statement) || (tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)prevLeaf, PsiTryStatement.class)) != null && tryStatement.getCatchSections().length <= 0 && tryStatement.getFinallyBlock() == null)) {
            result.consume((Object)new OverrideableSpace(JavaCompletionData.createKeyword(position, "final"), TailType.HUMBLE_SPACE_BEFORE_WORD));
        }
        if (JavaCompletionData.isStatementPosition(position)) {
            if (PsiTreeUtil.getParentOfType((PsiElement)position, PsiSwitchStatement.class, (boolean)false, (Class[])new Class[]{PsiMember.class}) != null) {
                result.consume((Object)new OverrideableSpace(JavaCompletionData.createKeyword(position, "case"), TailType.INSERT_SPACE));
                result.consume((Object)new OverrideableSpace(JavaCompletionData.createKeyword(position, "default"), TailType.CASE_COLON));
                if (START_SWITCH.accepts((Object)position)) {
                    return;
                }
            }
            JavaCompletionData.addBreakContinue(result, position);
            JavaCompletionData.addStatementKeywords(result, position);
        }
        if (SUPER_OR_THIS_PATTERN.accepts((Object)position)) {
            boolean insideInheritorClass;
            boolean afterDot = AFTER_DOT.accepts((Object)position);
            boolean insideQualifierClass = JavaCompletionData.isInsideQualifierClass(position);
            boolean bl = insideInheritorClass = PsiUtil.isLanguageLevel8OrHigher((PsiElement)position) && JavaCompletionData.isInsideInheritorClass(position);
            if (!afterDot || insideQualifierClass || insideInheritorClass) {
                if (!afterDot || insideQualifierClass) {
                    result.consume((Object)JavaCompletionData.createKeyword(position, "this"));
                }
                LookupItem superItem = (LookupItem)JavaCompletionData.createKeyword(position, "super");
                if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("{")).withSuperParent(2, (ElementPattern)PsiJavaPatterns.psiMethod().constructor(true)))).accepts((Object)position)) {
                    PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)position, PsiMethod.class, (boolean)false, (Class[])new Class[]{PsiClass.class});
                    assert (method != null);
                    final boolean hasParams = JavaCompletionData.superConstructorHasParameters(method);
                    superItem.setInsertHandler((InsertHandler)new ParenthesesInsertHandler<LookupElement>(){

                        protected boolean placeCaretInsideParentheses(InsertionContext context, LookupElement item) {
                            return hasParams;
                        }

                        public void handleInsert(InsertionContext context, LookupElement item) {
                            super.handleInsert(context, item);
                            TailType.insertChar((Editor)context.getEditor(), (int)context.getTailOffset(), (char)';');
                        }
                    });
                }
                result.consume((Object)superItem);
            }
        }
        if (JavaCompletionData.isExpressionPosition(position)) {
            if (PsiTreeUtil.getParentOfType((PsiElement)position, PsiAnnotation.class) == null) {
                result.consume(TailTypeDecorator.withTail(JavaCompletionData.createKeyword(position, "new"), TailType.INSERT_SPACE));
                result.consume((Object)JavaCompletionData.createKeyword(position, "null"));
            }
            if (JavaCompletionData.mayExpectBoolean(parameters)) {
                result.consume((Object)JavaCompletionData.createKeyword(position, "true"));
                result.consume((Object)JavaCompletionData.createKeyword(position, "false"));
            }
        }
        if (!((file = position.getContainingFile()) instanceof PsiExpressionCodeFragment || file instanceof PsiJavaCodeReferenceCodeFragment || file instanceof PsiTypeCodeFragment)) {
            if (prevLeaf == null) {
                result.consume((Object)new OverrideableSpace(JavaCompletionData.createKeyword(position, "package"), TailType.HUMBLE_SPACE_BEFORE_WORD));
                result.consume((Object)new OverrideableSpace(JavaCompletionData.createKeyword(position, "import"), TailType.HUMBLE_SPACE_BEFORE_WORD));
            } else if (((ElementFilter)END_OF_BLOCK.getValue()).isAcceptable((Object)position, position) && PsiTreeUtil.getParentOfType((PsiElement)position, PsiMember.class) == null) {
                result.consume((Object)new OverrideableSpace(JavaCompletionData.createKeyword(position, "import"), TailType.HUMBLE_SPACE_BEFORE_WORD));
            }
        }
        if ((JavaCompletionData.isInsideParameterList(position) || JavaCompletionData.isAtResourceVariableStart(position) || JavaCompletionData.isAtCatchVariableStart(position)) && !((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"final"})).accepts((Object)position) && !AFTER_DOT.accepts((Object)position)) {
            result.consume(TailTypeDecorator.withTail(JavaCompletionData.createKeyword(position, "final"), TailType.HUMBLE_SPACE_BEFORE_WORD));
        }
        if (JavaCompletionData.isInstanceofPlace(position)) {
            result.consume((Object)LookupElementDecorator.withInsertHandler((LookupElement)JavaCompletionData.createKeyword(position, "instanceof"), (InsertHandler)new InsertHandler<LookupElementDecorator<LookupElement>>(){

                public void handleInsert(InsertionContext context, LookupElementDecorator<LookupElement> item) {
                    TailType tailType = TailType.HUMBLE_SPACE_BEFORE_WORD;
                    if (tailType.isApplicable(context)) {
                        tailType.processTail(context.getEditor(), context.getTailOffset());
                    }
                    if ('!' == context.getCompletionChar()) {
                        context.setAddCompletionChar(false);
                        context.commitDocument();
                        PsiInstanceOfExpression expr = (PsiInstanceOfExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), PsiInstanceOfExpression.class, (boolean)false);
                        if (expr != null) {
                            String space = context.getCodeStyleSettings().SPACE_WITHIN_PARENTHESES ? " " : "";
                            context.getDocument().insertString(expr.getTextRange().getStartOffset(), (CharSequence)("!(" + space));
                            context.getDocument().insertString(context.getTailOffset(), (CharSequence)(space + ")"));
                        }
                    }
                }
            }));
        }
        if (JavaCompletionData.isSuitableForClass(position)) {
            for (String s : ModifierChooser.getKeywords(position)) {
                result.consume((Object)new OverrideableSpace(JavaCompletionData.createKeyword(position, s), TailType.HUMBLE_SPACE_BEFORE_WORD));
            }
            result.consume((Object)new OverrideableSpace(JavaCompletionData.createKeyword(position, "class"), TailType.HUMBLE_SPACE_BEFORE_WORD));
            if (PsiTreeUtil.getParentOfType((PsiElement)position, PsiCodeBlock.class, (boolean)true, (Class[])new Class[]{PsiMember.class}) == null) {
                result.consume((Object)new OverrideableSpace(JavaCompletionData.createKeyword(position, "interface"), TailType.HUMBLE_SPACE_BEFORE_WORD));
                if (PsiUtil.getLanguageLevel((PsiElement)position).isAtLeast(LanguageLevel.JDK_1_5)) {
                    result.consume((Object)new OverrideableSpace(JavaCompletionData.createKeyword(position, "enum"), TailType.INSERT_SPACE));
                }
            }
        }
        JavaCompletionData.addPrimitiveTypes(result, position);
        if (JavaCompletionData.isAfterTypeDot(position)) {
            result.consume((Object)JavaCompletionData.createKeyword(position, "class"));
        }
        JavaCompletionData.addUnfinishedMethodTypeParameters(position, result);
        if (JavaMemberNameCompletionContributor.INSIDE_TYPE_PARAMS_PATTERN.accepts((Object)position)) {
            result.consume((Object)new OverrideableSpace(JavaCompletionData.createKeyword(position, "extends"), TailType.HUMBLE_SPACE_BEFORE_WORD));
            result.consume((Object)new OverrideableSpace(JavaCompletionData.createKeyword(position, "super"), TailType.HUMBLE_SPACE_BEFORE_WORD));
        }
    }

    private static boolean mayExpectBoolean(CompletionParameters parameters) {
        for (ExpectedTypeInfo info : JavaSmartCompletionContributor.getExpectedTypes(parameters)) {
            PsiType type = info.getType();
            if (!(type instanceof PsiClassType) && type != PsiType.BOOLEAN) continue;
            return true;
        }
        return false;
    }

    private static boolean isExpressionPosition(PsiElement position) {
        return EXPR_KEYWORDS.accepts((Object)position) || ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().insideStarting((ElementPattern)PsiJavaPatterns.psiElement(PsiClassObjectAccessExpression.class))).accepts((Object)position);
    }

    public static boolean isInstanceofPlace(PsiElement position) {
        PsiType type;
        PsiElement prev = PsiTreeUtil.prevVisibleLeaf((PsiElement)position);
        if (prev == null) {
            return false;
        }
        PsiElement expr = PsiTreeUtil.getParentOfType((PsiElement)prev, PsiExpression.class);
        if (expr != null && expr.getTextRange().getEndOffset() == prev.getTextRange().getEndOffset()) {
            return true;
        }
        return position instanceof PsiIdentifier && position.getParent() instanceof PsiLocalVariable && (type = ((PsiLocalVariable)position.getParent()).getType()) instanceof PsiClassType && ((PsiClassType)type).resolve() == null;
    }

    public static boolean isSuitableForClass(PsiElement position) {
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"@"})).accepts((Object)position) || PsiTreeUtil.getNonStrictParentOfType((PsiElement)position, (Class[])new Class[]{PsiLiteralExpression.class, PsiComment.class}) != null) {
            return false;
        }
        PsiElement prev = PsiTreeUtil.prevVisibleLeaf((PsiElement)position);
        if (prev == null) {
            return true;
        }
        if (((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withoutText(".")).inside((ElementPattern)PsiJavaPatterns.psiElement(PsiModifierList.class).withParent((ElementPattern)StandardPatterns.not((ElementPattern)PsiJavaPatterns.psiElement(PsiParameter.class)).andNot((ElementPattern)PsiJavaPatterns.psiElement(PsiParameterList.class))))).accepts((Object)prev) && !((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiAnnotationParameterList.class)).accepts((Object)prev)) {
            return true;
        }
        return ((ElementFilter)END_OF_BLOCK.getValue()).isAcceptable((Object)position, position);
    }

    static void addExpectedTypeMembers(CompletionParameters parameters, CompletionResultSet result) {
        if (parameters.getInvocationCount() <= 1) {
            for (ExpectedTypeInfo info : JavaSmartCompletionContributor.getExpectedTypes(parameters)) {
                new JavaMembersGetter(info.getDefaultType(), parameters).addMembers(false, (Consumer<LookupElement>)result);
            }
        }
    }

    private static void addUnfinishedMethodTypeParameters(PsiElement position, Consumer<LookupElement> result) {
        ProcessingContext context = new ProcessingContext();
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside((ElementPattern)PsiJavaPatterns.psiElement(PsiTypeElement.class).afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText(">")).withParent((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement(PsiTypeParameterList.class).withParent(PsiErrorElement.class)).save("typeParameterList"))))).accepts((Object)position, context)) {
            PsiTypeParameterList list = (PsiTypeParameterList)context.get((Object)"typeParameterList");
            PsiElement current = list.getParent().getParent();
            if (current instanceof PsiField) {
                current = current.getParent();
            }
            if (current instanceof PsiClass) {
                for (PsiTypeParameter typeParameter : list.getTypeParameters()) {
                    result.consume((Object)new JavaPsiClassReferenceElement((PsiClass)typeParameter));
                }
            }
        }
    }

    static boolean isAfterPrimitiveOrArrayType(PsiElement element) {
        return ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiReferenceExpression().withFirstChild((ElementPattern)PsiJavaPatterns.psiElement(PsiClassObjectAccessExpression.class).withLastChild((ElementPattern)StandardPatterns.not((ElementPattern)PsiJavaPatterns.psiElement().withText("class")))))).accepts((Object)element);
    }

    static boolean isAfterTypeDot(PsiElement position) {
        if (JavaCompletionData.isInsideParameterList(position) || position.getContainingFile() instanceof PsiJavaCodeReferenceCodeFragment) {
            return false;
        }
        return ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText(".")).afterLeaf(CLASS_REFERENCE))).accepts((Object)position) || JavaCompletionData.isAfterPrimitiveOrArrayType(position);
    }

    private static void addPrimitiveTypes(Consumer<LookupElement> result, PsiElement position) {
        boolean inGenerics;
        if (AFTER_DOT.accepts((Object)position)) {
            return;
        }
        boolean afterNew = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("new")).andNot((ElementPattern)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"throw", "."})))).accepts((Object)position);
        if (afterNew) {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)position.getProject());
            for (String primitiveType : PRIMITIVE_TYPES) {
                result.consume((Object)PsiTypeLookupItem.createLookupItem(factory.createTypeFromText(primitiveType + "[]", null), null));
            }
            result.consume((Object)PsiTypeLookupItem.createLookupItem(factory.createTypeFromText("void[]", null), null));
            return;
        }
        boolean inCast = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("(")).withParent((ElementPattern)PsiJavaPatterns.psiElement((Class[])new Class[]{PsiParenthesizedExpression.class, PsiTypeCastExpression.class})))).accepts((Object)position);
        boolean typeFragment = position.getContainingFile() instanceof PsiTypeCodeFragment && PsiTreeUtil.prevVisibleLeaf((PsiElement)position) == null;
        boolean declaration = ((ElementPattern)DECLARATION_START.getValue()).accepts((Object)position);
        boolean expressionPosition = JavaCompletionData.isExpressionPosition(position);
        boolean bl = inGenerics = PsiTreeUtil.getParentOfType((PsiElement)position, PsiReferenceParameterList.class) != null;
        if (START_FOR.accepts((Object)position) || JavaCompletionData.isInsideParameterList(position) || inGenerics || VARIABLE_AFTER_FINAL.accepts((Object)position) || inCast || declaration || typeFragment || expressionPosition || JavaCompletionData.isStatementPosition(position)) {
            for (String primitiveType : PRIMITIVE_TYPES) {
                result.consume((Object)JavaCompletionData.createKeyword(position, primitiveType));
            }
        }
        if (declaration) {
            result.consume((Object)new OverrideableSpace(JavaCompletionData.createKeyword(position, "void"), TailType.HUMBLE_SPACE_BEFORE_WORD));
        } else if (typeFragment && ((PsiTypeCodeFragment)position.getContainingFile()).isVoidValid()) {
            result.consume((Object)JavaCompletionData.createKeyword(position, "void"));
        }
    }

    private static boolean isAtResourceVariableStart(PsiElement position) {
        return ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().insideStarting((ElementPattern)PsiJavaPatterns.psiElement(PsiTypeElement.class).withParent(PsiResourceList.class))).accepts((Object)position);
    }

    private static boolean isAtCatchVariableStart(PsiElement position) {
        return ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().insideStarting((ElementPattern)PsiJavaPatterns.psiElement(PsiTypeElement.class).withParent(PsiCatchSection.class))).accepts((Object)position);
    }

    private static void addBreakContinue(Consumer<LookupElement> result, PsiElement position) {
        PsiLoopStatement loop = (PsiLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)position, PsiLoopStatement.class);
        Object br = JavaCompletionData.createKeyword(position, "break");
        Object cont = JavaCompletionData.createKeyword(position, "continue");
        TailType tailType = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().insideSequence(true, new ElementPattern[]{PsiJavaPatterns.psiElement(PsiLabeledStatement.class), PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiFile.class), PsiJavaPatterns.psiElement(PsiMethod.class), PsiJavaPatterns.psiElement(PsiClassInitializer.class)})})).accepts((Object)position) ? TailType.HUMBLE_SPACE_BEFORE_WORD : TailType.SEMICOLON;
        br = TailTypeDecorator.withTail(br, tailType);
        cont = TailTypeDecorator.withTail(cont, tailType);
        if (loop != null && new InsideElementFilter(new ClassFilter(PsiStatement.class)).isAcceptable(position, (PsiElement)loop)) {
            result.consume(br);
            result.consume(cont);
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiSwitchStatement.class)).accepts((Object)position)) {
            result.consume(br);
        }
    }

    private static boolean isStatementPosition(PsiElement position) {
        PsiElement stmt;
        PsiIfStatement ifStatement;
        if (PsiTreeUtil.getNonStrictParentOfType((PsiElement)position, (Class[])new Class[]{PsiLiteralExpression.class, PsiComment.class}) != null) {
            return false;
        }
        if (((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withSuperParent(2, PsiConditionalExpression.class)).andNot((ElementPattern)PsiJavaPatterns.psiElement().insideStarting((ElementPattern)PsiJavaPatterns.psiElement(PsiConditionalExpression.class)))).accepts((Object)position)) {
            return false;
        }
        if (((ElementFilter)END_OF_BLOCK.getValue()).isAcceptable((Object)position, position) && PsiTreeUtil.getParentOfType((PsiElement)position, PsiCodeBlock.class, (boolean)true, (Class[])new Class[]{PsiMember.class}) != null) {
            return true;
        }
        return ((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParents(new Class[]{PsiReferenceExpression.class, PsiExpressionStatement.class, PsiIfStatement.class})).andNot((ElementPattern)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"."}))).accepts((Object)position) && ((ifStatement = (PsiIfStatement)(stmt = position.getParent().getParent()).getParent()).getElseBranch() == stmt || ifStatement.getThenBranch() == stmt);
    }

    protected static LookupElement createKeyword(PsiElement position, String keyword) {
        return BasicExpressionCompletionContributor.createKeywordLookupItem(position, keyword);
    }

    private static boolean isInsideQualifierClass(PsiElement position) {
        PsiElement qualifierClass;
        PsiElement qualifier;
        if (position.getParent() instanceof PsiJavaCodeReferenceElement && (qualifier = ((PsiJavaCodeReferenceElement)position.getParent()).getQualifier()) instanceof PsiJavaCodeReferenceElement && (qualifierClass = ((PsiJavaCodeReferenceElement)qualifier).resolve()) instanceof PsiClass) {
            PsiElement parent = position;
            PsiManager psiManager = position.getManager();
            while ((parent = PsiTreeUtil.getParentOfType((PsiElement)parent, PsiClass.class, (boolean)true)) != null) {
                if (!psiManager.areElementsEquivalent(parent, qualifierClass)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isInsideInheritorClass(PsiElement position) {
        PsiElement qualifierClass;
        PsiElement qualifier;
        if (position.getParent() instanceof PsiJavaCodeReferenceElement && (qualifier = ((PsiJavaCodeReferenceElement)position.getParent()).getQualifier()) instanceof PsiJavaCodeReferenceElement && (qualifierClass = ((PsiJavaCodeReferenceElement)qualifier).resolve()) instanceof PsiClass && ((PsiClass)qualifierClass).isInterface()) {
            PsiElement parent = position;
            while ((parent = PsiTreeUtil.getParentOfType((PsiElement)parent, PsiClass.class, (boolean)true)) != null) {
                if (PsiUtil.getEnclosingStaticElement((PsiElement)position, (PsiClass)((PsiClass)parent)) != null || !((PsiClass)parent).isInheritor((PsiClass)qualifierClass, true)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean superConstructorHasParameters(PsiMethod method) {
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return false;
        }
        PsiClass superClass = psiClass.getSuperClass();
        if (superClass != null) {
            for (PsiMethod psiMethod : superClass.getConstructors()) {
                PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)method.getProject()).getResolveHelper();
                if (!resolveHelper.isAccessible((PsiMember)psiMethod, (PsiElement)method, null) || psiMethod.getParameterList().getParameters().length <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public static class OverrideableSpace
    extends TailTypeDecorator<LookupElement> {
        private final TailType myTail;

        public OverrideableSpace(LookupElement keyword, TailType tail) {
            super(keyword);
            this.myTail = tail;
        }

        @Override
        protected TailType computeTailType(InsertionContext context) {
            return context.shouldAddCompletionChar() ? TailType.NONE : this.myTail;
        }
    }
}

