/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.BraceHighlightingHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.CaretAdapter;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEventMulticasterEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Alarm;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class BraceHighlighter
implements StartupActivity {
    private final Alarm myAlarm = new Alarm();

    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/highlighting/BraceHighlighter", "runActivity"));
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        EditorEventMulticaster eventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        CaretAdapter myCaretListener = new CaretAdapter(){

            public void caretPositionChanged(CaretEvent e) {
                BraceHighlighter.this.myAlarm.cancelAllRequests();
                Editor editor = e.getEditor();
                SelectionModel selectionModel = editor.getSelectionModel();
                if (editor.getProject() != project || selectionModel.hasSelection()) {
                    return;
                }
                Document document = editor.getDocument();
                int line = e.getNewPosition().line;
                if (line < 0 || line >= document.getLineCount()) {
                    return;
                }
                BraceHighlighter.updateBraces(editor, BraceHighlighter.this.myAlarm);
            }
        };
        eventMulticaster.addCaretListener((CaretListener)myCaretListener, (Disposable)project);
        SelectionListener mySelectionListener = new SelectionListener(){

            public void selectionChanged(SelectionEvent e) {
                BraceHighlighter.this.myAlarm.cancelAllRequests();
                Editor editor = e.getEditor();
                if (editor.getProject() != project) {
                    return;
                }
                TextRange oldRange = e.getOldRange();
                TextRange newRange = e.getNewRange();
                if (oldRange != null && newRange != null && !(oldRange.isEmpty() ^ newRange.isEmpty())) {
                    return;
                }
                BraceHighlighter.updateBraces(editor, BraceHighlighter.this.myAlarm);
            }
        };
        eventMulticaster.addSelectionListener(mySelectionListener, (Disposable)project);
        DocumentAdapter documentListener = new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                Editor[] editors;
                BraceHighlighter.this.myAlarm.cancelAllRequests();
                for (Editor editor : editors = EditorFactory.getInstance().getEditors(e.getDocument(), project)) {
                    BraceHighlighter.updateBraces(editor, BraceHighlighter.this.myAlarm);
                }
            }
        };
        eventMulticaster.addDocumentListener((DocumentListener)documentListener, (Disposable)project);
        FocusChangeListener myFocusChangeListener = new FocusChangeListener(){

            @Override
            public void focusLost(Editor editor) {
                BraceHighlighter.this.clearBraces(editor);
            }

            @Override
            public void focusGained(Editor editor) {
                BraceHighlighter.updateBraces(editor, BraceHighlighter.this.myAlarm);
            }
        };
        ((EditorEventMulticasterEx)eventMulticaster).addFocusChangeListner(myFocusChangeListener, (Disposable)project);
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        fileEditorManager.addFileEditorManagerListener((FileEditorManagerListener)new FileEditorManagerAdapter(){

            public void selectionChanged(@NotNull FileEditorManagerEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/highlighting/BraceHighlighter$5", "selectionChanged"));
                }
                BraceHighlighter.this.myAlarm.cancelAllRequests();
            }
        }, (Disposable)project);
    }

    static void updateBraces(@NotNull Editor editor, @NotNull Alarm alarm) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/highlighting/BraceHighlighter", "updateBraces"));
        }
        if (alarm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alarm", "com/intellij/codeInsight/highlighting/BraceHighlighter", "updateBraces"));
        }
        Document document = editor.getDocument();
        if (document instanceof DocumentEx && ((DocumentEx)document).isInBulkUpdate()) {
            return;
        }
        BraceHighlightingHandler.lookForInjectedAndMatchBracesInOtherThread(editor, alarm, new Processor<BraceHighlightingHandler>(){

            public boolean process(BraceHighlightingHandler handler) {
                handler.updateBraces();
                return false;
            }
        });
    }

    private void clearBraces(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/highlighting/BraceHighlighter", "clearBraces"));
        }
        BraceHighlightingHandler.lookForInjectedAndMatchBracesInOtherThread(editor, this.myAlarm, new Processor<BraceHighlightingHandler>(){

            public boolean process(BraceHighlightingHandler handler) {
                handler.clearBraceHighlighters();
                return false;
            }
        });
    }
}

