/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class LookupArranger {
    protected final List<LookupElement> myItems = new ArrayList<LookupElement>();
    private final List<LookupElement> myMatchingItems = new ArrayList<LookupElement>();
    private final List<LookupElement> myExactPrefixItems = new ArrayList<LookupElement>();
    private final List<LookupElement> myInexactPrefixItems = new ArrayList<LookupElement>();
    private String myAdditionalPrefix = "";

    public void addElement(Lookup lookup, LookupElement item, LookupElementPresentation presentation) {
        this.myItems.add(item);
        this.updateCache(lookup, item);
    }

    private void updateCache(Lookup lookup, LookupElement item) {
        if (!this.prefixMatches((LookupImpl)lookup, item)) {
            return;
        }
        this.myMatchingItems.add(item);
        if (LookupArranger.isPrefixItem(lookup, item, true)) {
            this.myExactPrefixItems.add(item);
        } else if (LookupArranger.isPrefixItem(lookup, item, false)) {
            this.myInexactPrefixItems.add(item);
        }
    }

    private boolean prefixMatches(LookupImpl lookup, LookupElement item) {
        PrefixMatcher matcher = lookup.itemMatcherNullable(item);
        if (matcher == null) {
            return false;
        }
        if (!this.myAdditionalPrefix.isEmpty()) {
            matcher = matcher.cloneWithPrefix(matcher.getPrefix() + this.myAdditionalPrefix);
        }
        return matcher.prefixMatches(item);
    }

    public void prefixChanged(Lookup lookup) {
        this.myAdditionalPrefix = ((LookupImpl)lookup).getAdditionalPrefix();
        this.rebuildItemCache(lookup);
    }

    private void rebuildItemCache(Lookup lookup) {
        this.myMatchingItems.clear();
        this.myExactPrefixItems.clear();
        this.myInexactPrefixItems.clear();
        for (LookupElement item : this.myItems) {
            this.updateCache(lookup, item);
        }
    }

    protected List<LookupElement> retainItems(Set<LookupElement> retained, Lookup lookup) {
        ArrayList filtered = ContainerUtil.newArrayList();
        ArrayList removed = ContainerUtil.newArrayList();
        for (LookupElement item : this.myItems) {
            (retained.contains(item) ? filtered : removed).add(item);
        }
        this.myItems.clear();
        this.myItems.addAll(filtered);
        this.rebuildItemCache(lookup);
        return removed;
    }

    public abstract Pair<List<LookupElement>, Integer> arrangeItems(@NotNull Lookup var1, boolean var2);

    public abstract LookupArranger createEmptyCopy();

    protected List<LookupElement> getPrefixItems(boolean exactly) {
        return Collections.unmodifiableList(exactly ? this.myExactPrefixItems : this.myInexactPrefixItems);
    }

    protected static boolean isPrefixItem(Lookup lookup, LookupElement item, boolean exactly) {
        String pattern = lookup.itemPattern(item);
        if (Comparing.strEqual((String)pattern, (String)item.getLookupString(), (boolean)item.isCaseSensitive())) {
            return true;
        }
        if (!exactly) {
            for (String s : item.getAllLookupStrings()) {
                if (!s.equalsIgnoreCase(pattern)) continue;
                return true;
            }
        }
        return false;
    }

    protected List<LookupElement> getMatchingItems() {
        return this.myMatchingItems;
    }

    public Map<LookupElement, StringBuilder> getRelevanceStrings() {
        return Collections.emptyMap();
    }

    public static class DefaultArranger
    extends LookupArranger {
        @Override
        public Pair<List<LookupElement>, Integer> arrangeItems(@NotNull Lookup lookup, boolean onExplicitAction) {
            if (lookup == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookup", "com/intellij/codeInsight/lookup/LookupArranger$DefaultArranger", "arrangeItems"));
            }
            LinkedHashSet<LookupElement> result = new LinkedHashSet<LookupElement>();
            result.addAll(this.getPrefixItems(true));
            result.addAll(this.getPrefixItems(false));
            List<LookupElement> items = this.getMatchingItems();
            for (LookupElement item : items) {
                if (!CompletionServiceImpl.isStartMatch(item, (LookupImpl)lookup)) continue;
                result.add(item);
            }
            result.addAll(items);
            ArrayList list = new ArrayList(result);
            int selected = !lookup.isSelectionTouched() && onExplicitAction ? 0 : list.indexOf(lookup.getCurrentItem());
            return new Pair(list, (Object)(selected >= 0 ? selected : 0));
        }

        @Override
        public LookupArranger createEmptyCopy() {
            return new DefaultArranger();
        }
    }
}

