/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.lookup.DefaultLookupItemRenderer;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.VariableLookupItem;
import com.intellij.codeInsight.lookup.impl.ElementLookupRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.util.PsiUtilCore;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class JavaElementLookupRenderer
implements ElementLookupRenderer {
    @Override
    public boolean handlesItem(Object element) {
        return element instanceof PsiVariable || element instanceof PsiKeyword || element instanceof PsiExpression || element instanceof PsiTypeElement || element instanceof BeanPropertyElement;
    }

    public void renderElement(LookupItem item, Object element, LookupElementPresentation presentation) {
        presentation.setIcon(DefaultLookupItemRenderer.getRawIcon((LookupElement)item, presentation.isReal()));
        presentation.setItemText(JavaElementLookupRenderer.getName(element, item));
        presentation.setStrikeout(JavaElementLookupRenderer.isToStrikeout(item));
        presentation.setItemTextBold(item.getAttribute(LookupItem.HIGHLIGHTED_ATTR) != null);
        presentation.setTailText((String)item.getAttribute(LookupItem.TAIL_TEXT_ATTR), item.getAttribute(LookupItem.TAIL_TEXT_SMALL_ATTR) != null);
        presentation.setTypeText(JavaElementLookupRenderer.getTypeText(element, item));
    }

    private static String getName(Object o, LookupItem<?> item) {
        String presentableText = item.getPresentableText();
        if (presentableText != null) {
            return presentableText;
        }
        String name = "";
        if (o instanceof PsiElement) {
            PsiElement element = (PsiElement)o;
            if (element.isValid()) {
                name = element instanceof PsiKeyword || element instanceof PsiExpression || element instanceof PsiTypeElement ? element.getText() : PsiUtilCore.getName((PsiElement)element);
            }
        } else if (o instanceof PsiArrayType) {
            name = ((PsiArrayType)o).getDeepComponentType().getPresentableText();
        } else if (o instanceof PsiType) {
            name = ((PsiType)o).getPresentableText();
        }
        if (item.getAttribute(LookupItem.FORCE_QUALIFY) != null && o instanceof PsiMember && ((PsiMember)o).getContainingClass() != null) {
            name = ((PsiMember)o).getContainingClass().getName() + "." + name;
        }
        return StringUtil.notNullize((String)name);
    }

    @Nullable
    private static String getTypeText(Object o, LookupItem item) {
        PsiElement element;
        String text = null;
        if (o instanceof PsiElement && (element = (PsiElement)o).isValid()) {
            if (element instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)element;
                PsiType type = variable.getType();
                if (item instanceof VariableLookupItem) {
                    type = ((VariableLookupItem)item).getSubstitutor().substitute(type);
                }
                text = type.getPresentableText();
            } else if (element instanceof PsiExpression) {
                PsiExpression expression = (PsiExpression)element;
                PsiType type = expression.getType();
                if (type != null) {
                    text = type.getPresentableText();
                }
            } else if (element instanceof BeanPropertyElement) {
                return JavaElementLookupRenderer.getTypeText(item, ((BeanPropertyElement)element).getPropertyType());
            }
        }
        return text;
    }

    @Nullable
    private static String getTypeText(LookupItem item, @Nullable PsiType returnType) {
        if (returnType == null) {
            return null;
        }
        PsiSubstitutor substitutor = (PsiSubstitutor)item.getAttribute(LookupItem.SUBSTITUTOR);
        if (substitutor != null) {
            return substitutor.substitute(returnType).getPresentableText();
        }
        return returnType.getPresentableText();
    }

    public static boolean isToStrikeout(LookupItem<?> item) {
        PsiElement element;
        List<PsiMethod> allMethods = JavaCompletionUtil.getAllMethods(item);
        if (allMethods != null) {
            for (PsiMethod method : allMethods) {
                if (!method.isValid()) {
                    return false;
                }
                if (JavaElementLookupRenderer.isDeprecated((PsiElement)method)) continue;
                return false;
            }
            return true;
        }
        if (item.getObject() instanceof PsiElement && (element = (PsiElement)item.getObject()).isValid()) {
            return JavaElementLookupRenderer.isDeprecated(element);
        }
        return false;
    }

    private static boolean isDeprecated(PsiElement element) {
        return element instanceof PsiDocCommentOwner && ((PsiDocCommentOwner)element).isDeprecated();
    }
}

