/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.concurrencyAnnotations;

import com.intellij.codeInsight.daemon.quickFix.ExternalLibraryDescriptor;
import com.intellij.codeInsight.daemon.quickFix.ExternalLibraryResolver;
import com.intellij.codeInspection.concurrencyAnnotations.JCiPUtil;
import com.intellij.openapi.module.Module;
import com.intellij.util.PathUtil;
import com.intellij.util.ThreeState;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.GuardedBy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JCiPExternalLibraryResolver
extends ExternalLibraryResolver {
    private static final ExternalLibraryDescriptor JDCIP_LIBRARY_DESCRIPTOR = new ExternalLibraryDescriptor("net.jcip", "jcip-annotations", null){

        @Override
        @NotNull
        public List<String> locateLibraryClassesRoots(@NotNull Module contextModule) {
            if (contextModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextModule", "com/intellij/codeInspection/concurrencyAnnotations/JCiPExternalLibraryResolver$1", "locateLibraryClassesRoots"));
            }
            List<String> list = Collections.singletonList(PathUtil.getJarPathForClass(GuardedBy.class));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/concurrencyAnnotations/JCiPExternalLibraryResolver$1", "locateLibraryClassesRoots"));
            }
            return list;
        }

        @Override
        public String getPresentableName() {
            return "jcip-annotations.jar";
        }
    };

    @Override
    @Nullable
    public ExternalLibraryResolver.ExternalClassResolveResult resolveClass(@NotNull String shortClassName, @NotNull ThreeState isAnnotation) {
        if (shortClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortClassName", "com/intellij/codeInspection/concurrencyAnnotations/JCiPExternalLibraryResolver", "resolveClass"));
        }
        if (isAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isAnnotation", "com/intellij/codeInspection/concurrencyAnnotations/JCiPExternalLibraryResolver", "resolveClass"));
        }
        if (JCiPUtil.isJCiPAnnotation(shortClassName) && isAnnotation == ThreeState.YES) {
            return new ExternalLibraryResolver.ExternalClassResolveResult("net.jcip.annotations." + shortClassName, JDCIP_LIBRARY_DESCRIPTOR);
        }
        return null;
    }

    @Override
    @Nullable
    public ExternalLibraryDescriptor resolvePackage(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/codeInspection/concurrencyAnnotations/JCiPExternalLibraryResolver", "resolvePackage"));
        }
        if (packageName.equals("net.jcip.annotations")) {
            return JDCIP_LIBRARY_DESCRIPTOR;
        }
        return null;
    }
}

