/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions;

import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.export.ExportToHTMLDialog;
import com.intellij.codeInspection.export.HTMLExportFrameMaker;
import com.intellij.codeInspection.export.HTMLExportUtil;
import com.intellij.codeInspection.export.HTMLExporter;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.util.RefEntityAlphabeticalComparator;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ExportHTMLAction
extends AnAction
implements DumbAware {
    private final InspectionResultsView myView;
    @NonNls
    private static final String PROBLEMS = "problems";
    @NonNls
    private static final String HTML = "HTML";
    @NonNls
    private static final String XML = "XML";

    public ExportHTMLAction(InspectionResultsView view) {
        super(InspectionsBundle.message((String)"inspection.action.export.html", (Object[])new Object[0]), null, AllIcons.Actions.Export);
        this.myView = view;
    }

    public void actionPerformed(AnActionEvent e) {
        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(InspectionsBundle.message((String)"inspection.action.export.popup.title", (Object[])new Object[0]), new String[]{HTML, XML}){

            public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                ExportHTMLAction.this.exportHTML(Comparing.strEqual((String)selectedValue, (String)ExportHTMLAction.HTML));
                return PopupStep.FINAL_CHOICE;
            }
        });
        InspectionResultsView.showPopup(e, (JBPopup)popup);
    }

    private void exportHTML(final boolean exportToHTML) {
        ExportToHTMLDialog exportToHTMLDialog = new ExportToHTMLDialog(this.myView.getProject(), exportToHTML);
        final ExportToHTMLSettings exportToHTMLSettings = ExportToHTMLSettings.getInstance(this.myView.getProject());
        if (exportToHTMLSettings.OUTPUT_DIRECTORY == null) {
            exportToHTMLSettings.OUTPUT_DIRECTORY = PathManager.getHomePath() + File.separator + "inspections";
        }
        exportToHTMLDialog.reset();
        if (!exportToHTMLDialog.showAndGet()) {
            return;
        }
        exportToHTMLDialog.apply();
        final String outputDirectoryName = exportToHTMLSettings.OUTPUT_DIRECTORY;
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                Runnable exportRunnable = new Runnable(){

                    @Override
                    public void run() {
                        ApplicationManager.getApplication().runReadAction(new Runnable(){

                            @Override
                            public void run() {
                                if (!exportToHTML) {
                                    ExportHTMLAction.this.dupm2XML(outputDirectoryName);
                                } else {
                                    final HTMLExportFrameMaker maker = new HTMLExportFrameMaker(outputDirectoryName, ExportHTMLAction.this.myView.getProject());
                                    maker.start();
                                    try {
                                        InspectionTreeNode root = ExportHTMLAction.this.myView.getTree().getRoot();
                                        TreeUtil.traverse((TreeNode)root, (TreeUtil.Traverse)new TreeUtil.Traverse(){

                                            public boolean accept(Object node) {
                                                if (node instanceof InspectionNode) {
                                                    ExportHTMLAction.this.exportHTML(maker, (InspectionNode)node);
                                                }
                                                return true;
                                            }
                                        });
                                    }
                                    catch (ProcessCanceledException processCanceledException) {
                                        // empty catch block
                                    }
                                    maker.done();
                                }
                            }
                        });
                    }
                };
                if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(exportRunnable, exportToHTML ? InspectionsBundle.message((String)"inspection.generating.html.progress.title", (Object[])new Object[0]) : InspectionsBundle.message((String)"inspection.generating.xml.progress.title", (Object[])new Object[0]), true, ExportHTMLAction.this.myView.getProject())) {
                    return;
                }
                if (exportToHTML && exportToHTMLSettings.OPEN_IN_BROWSER) {
                    BrowserUtil.browse((File)new File(exportToHTMLSettings.OUTPUT_DIRECTORY, "index.html"));
                }
            }
        });
    }

    private void dupm2XML(final String outputDirectoryName) {
        try {
            new File(outputDirectoryName).mkdirs();
            InspectionTreeNode root = this.myView.getTree().getRoot();
            final IOException[] ex = new IOException[1];
            TreeUtil.traverse((TreeNode)root, (TreeUtil.Traverse)new TreeUtil.Traverse(){

                public boolean accept(Object node) {
                    if (node instanceof InspectionNode) {
                        InspectionNode toolNode = (InspectionNode)node;
                        Element problems = new Element(ExportHTMLAction.PROBLEMS);
                        InspectionToolWrapper toolWrapper = toolNode.getToolWrapper();
                        Set toolWrappers = ExportHTMLAction.this.getWorkedTools(toolNode);
                        for (InspectionToolWrapper wrapper : toolWrappers) {
                            InspectionToolPresentation presentation = ExportHTMLAction.this.myView.getGlobalInspectionContext().getPresentation(wrapper);
                            presentation.exportResults(problems);
                        }
                        PathMacroManager.getInstance((ComponentManager)ExportHTMLAction.this.myView.getProject()).collapsePaths(problems);
                        try {
                            JDOMUtil.writeDocument((Document)new Document(problems), (String)(outputDirectoryName + File.separator + toolWrapper.getShortName() + ".xml"), (String)CodeStyleSettingsManager.getSettings(null).getLineSeparator());
                        }
                        catch (IOException e) {
                            ex[0] = e;
                        }
                    }
                    return true;
                }
            });
            if (ex[0] != null) {
                throw ex[0];
            }
            Element element = new Element("inspections");
            String profileName = this.myView.getCurrentProfileName();
            if (profileName != null) {
                element.setAttribute("profile", profileName);
            }
            JDOMUtil.writeDocument((Document)new Document(element), (String)(outputDirectoryName + File.separator + ".descriptions" + ".xml"), (String)CodeStyleSettingsManager.getSettings(null).getLineSeparator());
        }
        catch (IOException e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showErrorDialog((Component)ExportHTMLAction.this.myView, (String)e.getMessage());
                }
            });
        }
    }

    @NotNull
    private Set<InspectionToolWrapper> getWorkedTools(@NotNull InspectionNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/ui/actions/ExportHTMLAction", "getWorkedTools"));
        }
        HashSet<InspectionToolWrapper> result = new HashSet<InspectionToolWrapper>();
        InspectionToolWrapper wrapper = node.getToolWrapper();
        if (this.myView.getCurrentProfileName() != null) {
            result.add(wrapper);
            HashSet<InspectionToolWrapper> hashSet = result;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/actions/ExportHTMLAction", "getWorkedTools"));
            }
            return hashSet;
        }
        String shortName = wrapper.getShortName();
        GlobalInspectionContextImpl context = this.myView.getGlobalInspectionContext();
        Tools tools = context.getTools().get(shortName);
        if (tools != null) {
            for (ScopeToolState state : tools.getTools()) {
                InspectionToolWrapper toolWrapper = state.getTool();
                result.add(toolWrapper);
            }
        }
        HashSet<InspectionToolWrapper> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/actions/ExportHTMLAction", "getWorkedTools"));
        }
        return hashSet;
    }

    private void exportHTML(HTMLExportFrameMaker frameMaker, InspectionNode node) {
        final Set<InspectionToolWrapper> toolWrappers = this.getWorkedTools(node);
        InspectionToolWrapper toolWrapper = node.getToolWrapper();
        final HTMLExporter exporter = new HTMLExporter(frameMaker.getRootFolder() + "/" + toolWrapper.getShortName(), this.myView.getGlobalInspectionContext().getPresentation(toolWrapper).getComposer());
        frameMaker.startInspection(toolWrapper);
        HTMLExportUtil.runExport(this.myView.getProject(), new ThrowableRunnable<IOException>(){

            public void run() throws IOException {
                ExportHTMLAction.this.exportHTML(toolWrappers, exporter);
                exporter.generateReferencedPages();
            }
        });
    }

    private void exportHTML(@NotNull Set<InspectionToolWrapper> toolWrappers, HTMLExporter exporter) throws IOException {
        if (toolWrappers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrappers", "com/intellij/codeInspection/ui/actions/ExportHTMLAction", "exportHTML"));
        }
        StringBuffer packageIndex = new StringBuffer();
        packageIndex.append("<html><body>");
        HashMap<String, Set> content = new HashMap<String, Set>();
        for (InspectionToolWrapper toolWrapper : toolWrappers) {
            InspectionToolPresentation presentation = this.myView.getGlobalInspectionContext().getPresentation(toolWrapper);
            Map<String, Set<RefEntity>> toolContent = presentation.getContent();
            content.putAll(toolContent);
        }
        Set defaultPackageEntities = (Set)content.remove(null);
        if (defaultPackageEntities != null) {
            content.put("default package", defaultPackageEntities);
        }
        ArrayList packageNames = new ArrayList(content.keySet());
        Collections.sort(packageNames);
        for (Object packageName : packageNames) {
            ExportHTMLAction.appendPackageReference(packageIndex, (String)packageName);
            ArrayList packageContent = new ArrayList((Collection)content.get(packageName));
            Collections.sort(packageContent, RefEntityAlphabeticalComparator.getInstance());
            StringBuffer contentIndex = new StringBuffer();
            contentIndex.append("<html><body>");
            for (RefEntity refElement : packageContent) {
                refElement = refElement.getRefManager().getRefinedElement(refElement);
                contentIndex.append("<a HREF=\"");
                contentIndex.append(exporter.getURL(refElement));
                contentIndex.append("\" target=\"elementFrame\">");
                contentIndex.append(refElement.getName());
                contentIndex.append("</a><br>");
                exporter.createPage(refElement);
            }
            contentIndex.append("</body></html>");
            HTMLExportUtil.writeFile(exporter.getRootFolder(), (String)packageName + "-index.html", contentIndex, this.myView.getProject());
        }
        HashSet<RefModule> modules = new HashSet<RefModule>();
        for (InspectionToolWrapper toolWrapper : toolWrappers) {
            InspectionToolPresentation presentation = this.myView.getGlobalInspectionContext().getPresentation(toolWrapper);
            Set<RefModule> problems = presentation.getModuleProblems();
            modules.addAll(problems);
        }
        ArrayList sortedModules = new ArrayList(modules);
        Collections.sort(sortedModules, RefEntityAlphabeticalComparator.getInstance());
        for (RefModule module : sortedModules) {
            ExportHTMLAction.appendPackageReference(packageIndex, module.getName());
            StringBuffer contentIndex = new StringBuffer();
            contentIndex.append("<html><body>");
            contentIndex.append("<a HREF=\"");
            contentIndex.append(exporter.getURL((RefEntity)module));
            contentIndex.append("\" target=\"elementFrame\">");
            contentIndex.append(module.getName());
            contentIndex.append("</a><br>");
            exporter.createPage((RefEntity)module);
            contentIndex.append("</body></html>");
            HTMLExportUtil.writeFile(exporter.getRootFolder(), module.getName() + "-index.html", contentIndex, this.myView.getProject());
        }
        packageIndex.append("</body></html>");
        HTMLExportUtil.writeFile(exporter.getRootFolder(), "index.html", packageIndex, this.myView.getProject());
    }

    private static void appendPackageReference(StringBuffer packageIndex, String packageName) {
        packageIndex.append("<a HREF=\"");
        packageIndex.append(packageName);
        packageIndex.append("-index.html\" target=\"packageFrame\">");
        packageIndex.append(packageName);
        packageIndex.append("</a><br>");
    }
}

