/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.impl.stores.FileBasedStorage;
import com.intellij.openapi.components.impl.stores.StorageData;
import com.intellij.openapi.components.impl.stores.XmlElementStorage;
import java.io.File;
import java.io.IOException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultProjectStorage
extends FileBasedStorage {
    public DefaultProjectStorage(@NotNull File file, @NotNull String fileSpec, PathMacroManager pathMacroManager) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/configurationStore/DefaultProjectStorage", "<init>"));
        }
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/configurationStore/DefaultProjectStorage", "<init>"));
        }
        super(file, fileSpec, RoamingType.DISABLED, pathMacroManager.createTrackingSubstitutor(), "defaultProject", null);
    }

    @Override
    @Nullable
    protected Element loadLocalData() {
        Element element = super.loadLocalData();
        if (element == null) {
            return null;
        }
        try {
            return element.getChild("component").getChild("defaultProject");
        }
        catch (NullPointerException e) {
            LOG.warn("Cannot read default project");
            return null;
        }
    }

    @Override
    @NotNull
    protected XmlElementStorage.XmlElementStorageSaveSession createSaveSession(@NotNull StorageData storageData) {
        if (storageData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageData", "com/intellij/configurationStore/DefaultProjectStorage", "createSaveSession"));
        }
        FileBasedStorage.FileSaveSession fileSaveSession = new FileBasedStorage.FileSaveSession(storageData){

            @Override
            protected void doSave(@Nullable Element element) throws IOException {
                super.doSave(new Element("application").addContent(new Element("component").setAttribute("name", "ProjectManager").addContent(element)));
            }
        };
        if (fileSaveSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/configurationStore/DefaultProjectStorage", "createSaveSession"));
        }
        return fileSaveSession;
    }
}

